package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.State;

/**
 * 订单状态（前端状态）
 * 
 * @author Paul-xiong
 *
 */
public enum OrderState implements State {
	ALL(1, "全部"), 
	PAYING(2, "待支付"),
	WAITING_DELIVER(3, "待发货"),
	DELIVERING(4, "待收货"),
	DONE(5, "已完成"),
	CANCELLED(6, "已取消"),;

	private final int id;
	private final String name;

	private OrderState(final int id, final String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

}
