/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.enums.Customize;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum LimitType {
    LOWER("0", "\u5c0f\u5199\u5b57\u6bcd", "a-z"),
    UPPER("1", "\u5927\u5199\u5b57\u6bcd", "A-Z"),
    NUMBER("2", "\u6570\u5b57", "0-9"),
    HEART_SYMBOL("3", "\u7231\u5fc3\u8868\u60c5", "(\\[\\[love\\]\\])*"),
    POINT_SYMBOL("4", "\u82f1\u6587\u70b9\u5b57\u7b26", "."),
    SMILE_SYMBOL("5", "\u7b11\u8138\u8868\u60c5", "(\\[\\[smile\\]\\])*"),
    ARROW_HEART_SYMBOL("6", "\u4e00\u7bad\u7a7f\u5fc3\u8868\u60c5", "(\\[\\[arrowheart\\]\\])*"),
    POINT_MIDDLE_SYMBOL("7", "\u82f1\u6587\u4e2d\u95f4\u70b9\u5b57\u7b26", "\u2022");

    private String code;
    private String value;
    private String regEx;

    private LimitType(String code, String value, String regEx) {
        this.code = code;
        this.value = value;
        this.regEx = regEx;
    }

    public String getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public String getRegEx() {
        return this.regEx;
    }

    public static LimitType getLimitTypeByCode(String code) {
        LimitType[] limitTypeArray = LimitType.values();
        int n = limitTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LimitType value = limitTypeArray[n2];
            if (StringUtils.equals((CharSequence)value.getCode(), (CharSequence)code)) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public static List<LimitType> getLimitTypeByCodes(List<String> codes) {
        if (codes == null) {
            return null;
        }
        ArrayList limitTypes = Lists.newArrayList();
        for (String code : codes) {
            LimitType limitType = LimitType.getLimitTypeByCode(code);
            if (limitType == null) continue;
            limitTypes.add(limitType);
        }
        return limitTypes;
    }

    public static String getRegEx(List<LimitType> limitTypes) {
        boolean isHeartSymbol = false;
        boolean isSmileSymbol = false;
        boolean isArrowHeartSymbol = false;
        StringBuffer regEx = new StringBuffer();
        StringBuffer regEx1 = new StringBuffer();
        for (LimitType limitType : limitTypes) {
            if (HEART_SYMBOL.equals((Object)limitType)) {
                isHeartSymbol = true;
                continue;
            }
            if (SMILE_SYMBOL.equals((Object)limitType)) {
                isSmileSymbol = true;
                continue;
            }
            if (ARROW_HEART_SYMBOL.equals((Object)limitType)) {
                isArrowHeartSymbol = true;
                continue;
            }
            regEx1.append(limitType.getRegEx());
        }
        if (StringUtils.isNotEmpty((CharSequence)regEx1)) {
            regEx1.insert(0, "[");
            regEx1.append("]*");
        }
        regEx.append("^(");
        regEx.append(regEx1);
        if (isHeartSymbol) {
            regEx.append(HEART_SYMBOL.getRegEx());
        }
        if (isSmileSymbol) {
            regEx.append(SMILE_SYMBOL.getRegEx());
        }
        if (isArrowHeartSymbol) {
            regEx.append(ARROW_HEART_SYMBOL.getRegEx());
        }
        regEx.append(")*$");
        return regEx.toString();
    }
}

