/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.coll;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.mark.Unmodifiable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CollectionUtil {
    public static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        public String apply(Object input) {
            return input.toString();
        }
    };
    private static final Collection<Class<?>> KNOWN_UNMODIFIABLE_CLASSES = Arrays.asList(Collections.unmodifiableCollection(Collections.emptyList()).getClass(), Collections.emptyList().getClass(), Collections.emptySet().getClass(), Collections.emptyMap().getClass(), Collections.emptyEnumeration().getClass());

    public static Collection<String> toString(Collection<?> source) {
        return Collections2.transform(source, TO_STRING);
    }

    public static boolean isUnmodifiable(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Unmodifiable) {
            return true;
        }
        for (Class<?> knownUnmodifiableClass : KNOWN_UNMODIFIABLE_CLASSES) {
            if (!knownUnmodifiableClass.isAssignableFrom(obj.getClass())) continue;
            return true;
        }
        return false;
    }

    private CollectionUtil() {
    }

    public static <T> List<T> avoidNull(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    public static <K, V> Map<K, V> map(List<K> keys, List<V> values) {
        int size = keys.size();
        if (size != values.size()) {
            throw new WrongArgException("size", size);
        }
        LinkedHashMap rt = Maps.newLinkedHashMap();
        int i = 0;
        while (i < size) {
            rt.put(keys.get(i), values.get(i));
            ++i;
        }
        return rt;
    }
}

