package com.thebeastshop.support.vo.product;

import java.math.BigDecimal;
import java.util.List;

import com.thebeastshop.support.Label;

/**
 * 商品详细
 * 
 * @author Paul-xiong
 *
 */
public class ProductDetailVo {
	private ProductBasicVo productBasic;
	private List<ProductBadgeVo> badges;
	private List<ProductTipVo> tips;
	private ProductVariantVo variant;

	public ProductDetailVo(ProductBasicVo productBasic, List<ProductBadgeVo> badges, List<ProductTipVo> tips,
			ProductVariantVo variant) {
		super();
		this.productBasic = productBasic;
		this.badges = badges;
		this.tips = tips;
		this.variant = variant;
	}

	public Long getId() {
		return productBasic.getId();
	}

	public List<String> getImages() {
		return productBasic.getImages();
	}

	public String getBrand() {
		return productBasic.getBrand();
	}

	public String getName() {
		return productBasic.getName();
	}

	public String getSummary() {
		return productBasic.getSummary();
	}

	public BigDecimal getRawPrice() {
		return productBasic.getRawPrice();
	}

	public BigDecimal getPrice() {
		return productBasic.getPrice();
	}

	public Boolean getSoldOut() {
		return productBasic.getSoldOut();
	}

	public String getH5url() {
		return productBasic.getH5url();
	}

	public List<Label> getLabels() {
		return productBasic.getLabels();
	}

	public List<ProductBadgeVo> getBadges() {
		return badges;
	}

	public List<ProductTipVo> getTips() {
		return tips;
	}

	public ProductVariantVo getVariant() {
		return variant;
	}

}
