package com.thebeastshop.support.vo.cart;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import com.thebeastshop.support.Label;
import com.thebeastshop.support.vo.announcement.AnnouncementVo;

/**
 * @author Liang Wenjian
 */
public class CartVo implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -6585821989342529298L;
	/**
	 * 公告
	 */
	private List<AnnouncementVo> announcements;
	/**
	 * 商品包
	 */
	private List<CartProductPackVo> packs;
	/**
	 * 额外商品包（加价购商品）
	 */
	private List<CartProductPackVo> addiblePacks;
	/**
	 * 购物车标签
	 */
	private List<Label> labels;
	/**
	 * 无效商品
	 */
	private List<CartProductPackVo> invalidPacks;
	/**
	 * 邮费
	 */
	private BigDecimal postage;
	/**
	 * 优惠金额
	 */
	private BigDecimal savedPrice;
	/**
	 * 最终价格
	 */
	private BigDecimal price;
	/**
	 * 全场活动的优惠价格
	 */
	private BigDecimal fullActivityPrice;

	public CartVo() {
		super();
	}

	public List<AnnouncementVo> getAnnouncements() {
		return announcements;
	}

	public void setAnnouncements(final List<AnnouncementVo> announcements) {
		this.announcements = announcements;
	}

	public List<CartProductPackVo> getPacks() {
		return packs;
	}

	public void setPacks(final List<CartProductPackVo> packs) {
		this.packs = packs;
	}

	public List<CartProductPackVo> getAddiblePacks() {
		return addiblePacks;
	}

	public void setAddiblePacks(final List<CartProductPackVo> addiblePacks) {
		this.addiblePacks = addiblePacks;
	}

	public List<Label> getLabels() {
		return labels;
	}

	public void setLabels(final List<Label> labels) {
		this.labels = labels;
	}

	public List<CartProductPackVo> getInvalidPacks() {
		return invalidPacks;
	}

	public void setInvalidPacks(final List<CartProductPackVo> invalidPacks) {
		this.invalidPacks = invalidPacks;
	}

	public BigDecimal getPostage() {
		return postage;
	}

	public void setPostage(final BigDecimal postage) {
		this.postage = postage;
	}

	public BigDecimal getSavedPrice() {
		return savedPrice;
	}

	public void setSavedPrice(BigDecimal savedPrice) {
		this.savedPrice = savedPrice;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(final BigDecimal price) {
		this.price = price;
	}

	public BigDecimal getFullActivityPrice() {
		return fullActivityPrice;
	}

	public void setFullActivityPrice(BigDecimal fullActivityPrice) {
		this.fullActivityPrice = fullActivityPrice;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + hashCode() + ":{" + "announcements:" + announcements + ", packs:" + packs
				+ ", addiblePacks:" + addiblePacks + ", labels:" + labels + ", invalidPacks:" + invalidPacks
				+ ", postage:" + postage + ", savedPrice:" + savedPrice + ", price:" + price + '}';
	}
}
