package com.thebeastshop.support.vo.cart;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.common.collect.Lists;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.vo.product.SpvVo;

/**
 * 商品包
 * 
 * @author Paul-xiong
 *
 */
public class CartProductPackVo implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 7949689391932894329L;
	/**
	 * 
	 */
	private Long id;
	/**
	 * 数量
	 */
	private int count = 1;
	/**
	 * 商品包来源
	 */
	private CartPackSource source = CartPackSource.RAW;
	/**
	 * spv信息
	 */
	private SpvVo spv;
	/**
	 * 标签
	 */
	private Collection<Label> labels = Lists.newArrayList();
	/**
	 * 是否已获得（加价购才有）
	 */
	private Boolean owned = false;
	/**
	 * 是否有效
	 */
	private boolean valid = true;
	/**
	 * 商品包所属赠品列表
	 */
	private List<CartProductPackVo> gifts;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}

	public CartPackSource getSource() {
		return source;
	}

	public void setSource(CartPackSource source) {
		this.source = source;
	}

	public SpvVo getSpv() {
		return spv;
	}

	public void setSpv(SpvVo spv) {
		this.spv = spv;
	}

	public Collection<Label> getLabels() {
		return labels;
	}

	public void setLabels(Collection<Label> labels) {
		this.labels = labels;
	}

	public Boolean getOwned() {
		return owned;
	}

	public void setOwned(Boolean owned) {
		this.owned = owned;
	}

	public boolean isValid() {
		return valid;
	}

	public void setValid(boolean valid) {
		this.valid = valid;
	}

	public List<CartProductPackVo> getGifts() {
		return gifts;
	}

	public void setGifts(List<CartProductPackVo> gifts) {
		this.gifts = gifts;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this).append("id", id).append("count", count).append("labels", labels)
				.append("spv", spv).append("gifts", gifts).append("source", source).append("owned", owned)
				.append("valid", valid).toString();
	}
}
