package com.thebeastshop.support.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;

import com.thebeastshop.support.mark.HasPrice;

/**
 * 价格计算工具
 * 
 * @author Paul-xiong
 *
 */
public class PriceUtil {

	/**
	 * 保留到分，厘位四舍五入
	 *
	 * @return
	 */
	public static BigDecimal keepToCent(final BigDecimal d) {
		return d.setScale(2, RoundingMode.HALF_UP);
	}

	public static BigDecimal keepToCent(final HasPrice hasPrice) {
		return keepToCent(hasPrice.getPrice());
	}

	/**
	 * 计算总价，四舍五入保留到分
	 *
	 * @param price
	 * @param count
	 * @return
	 */
	public static BigDecimal multiPrice(final BigDecimal price, final int count) {
		return keepToCent(price.multiply(BigDecimal.valueOf(count)));
	}

	/**
	 * 计算总价
	 *
	 * @param source
	 * @return
	 */
	public static BigDecimal sumPrice(final Collection<? extends HasPrice> source) {
		BigDecimal rt = BigDecimal.ZERO;
		for (final HasPrice t : source) {
			rt = rt.add(t.getPrice());
		}
		return keepToCent(rt);
	}
}
