package com.thebeastshop.support;

import com.thebeastshop.support.mark.Validatable;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author Liang Wenjian
 */
public class Label implements Validatable, Serializable {

	private String type;
	private String typeColor;
	private String typeBgColor;
	private String summary;
	private String summaryColor = "#000000";
	private String link;
	private Integer count;
	private boolean valid = true;

	public Label() {
		super();
	}

	public Label(String type, String typeColor, String typeBgColor, String summary, String summaryColor, String link,
			Integer count, boolean valid) {
		super();
		this.type = type;
		this.typeColor = typeColor;
		this.typeBgColor = typeBgColor;
		this.summary = summary;
		this.summaryColor = summaryColor;
		this.link = link;
		this.count = count;
		this.valid = valid;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(final String summary) {
		this.summary = summary;
	}

	@Override
	public boolean isValid() {
		return valid;
	}

	public void setValid(final boolean valid) {
		this.valid = valid;
	}

	public String getLink() {
		return link;
	}

	public void setLink(final String link) {
		this.link = link;
	}

	public Integer getCount() {
		return count;
	}

	public void setCount(final Integer count) {
		this.count = count;
	}

	public String getSummaryColor() {
		return summaryColor;
	}

	public void setSummaryColor(final String summaryColor) {
		this.summaryColor = summaryColor;
	}

	public String getTypeColor() {
		return typeColor;
	}

	public void setTypeColor(String typeColor) {
		this.typeColor = typeColor;
	}

	public String getTypeBgColor() {
		return typeBgColor;
	}

	public void setTypeBgColor(String typeBgColor) {
		this.typeBgColor = typeBgColor;
	}

	@Override
	public boolean equals(final Object o) {
		if (this == o) {
			return true;
		}
		if (!(o instanceof Label)) {
			return false;
		}
		final Label label = (Label) o;
		return Objects.equals(isValid(), label.isValid()) && Objects.equals(getType(), label.getType())
				&& Objects.equals(getSummary(), label.getSummary()) && Objects.equals(getLink(), label.getLink())
				&& Objects.equals(getCount(), label.getCount())
				&& Objects.equals(getSummaryColor(), label.getSummaryColor());
	}

	@Override
	public int hashCode() {
		return Objects.hash(getType(), getSummary(), isValid(), getLink(), getCount(), getSummaryColor());
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + hashCode() + ":{" + "type:'" + type + '\'' + ", summary:'" + summary + '\''
				+ ", valid:" + valid + ", link:'" + link + '\'' + ", count:" + count + ", summaryColor:'" + summaryColor
				+ '\'' + '}';
	}

}
