/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.support.mark.HasIdGetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IdUtil {
    private static Comparator<HasIdGetter<?>> ID_ASC = new Comparator<HasIdGetter<?>>(){

        @Override
        public int compare(HasIdGetter<?> o1, HasIdGetter<?> o2) {
            return Long.compare(Long.valueOf(o1.getId().toString()), Long.valueOf(o2.getId().toString()));
        }
    };
    private static Comparator<HasIdGetter<?>> ID_DESC = new Comparator<HasIdGetter<?>>(){

        @Override
        public int compare(HasIdGetter<?> o1, HasIdGetter<?> o2) {
            return Long.compare(Long.valueOf(o2.getId().toString()), Long.valueOf(o1.getId().toString()));
        }
    };

    public static <I extends Comparable<I>> List<I> toIds(Collection<? extends HasIdGetter<I>> source) {
        ArrayList list = Lists.newArrayList();
        for (HasIdGetter<I> i : source) {
            list.add(i.getId());
        }
        return list;
    }

    @SafeVarargs
    public static <I extends Comparable<I>> boolean contains(HasIdGetter<I> entity, I ... ids) {
        return IdUtil.contains(entity, Arrays.asList(ids));
    }

    public static <I extends Comparable<I>> boolean contains(HasIdGetter<I> entity, Collection<I> ids) {
        return ids.contains(entity.getId());
    }

    @SafeVarargs
    public static <I extends Comparable<I>> boolean contains(I id, HasIdGetter<I> ... entities) {
        return IdUtil.contains(id, Arrays.asList(entities));
    }

    public static <I extends Comparable<I>> boolean contains(I id, Collection<? extends HasIdGetter<I>> entities) {
        return IdUtil.toIds(entities).contains(id);
    }

    public static <I extends Comparable<I>> Collection<I> toParentIds(Collection<? extends HasIdGetter.HasParent<I>> source) {
        ArrayList list = Lists.newArrayList();
        for (HasIdGetter.HasParent<I> i : source) {
            list.add(i.getParentId());
        }
        return list;
    }

    public static <I extends Comparable<I>, T extends HasIdGetter<I>> Map<I, T> map(Iterable<T> source) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (HasIdGetter t : source) {
            map.put(t.getId(), t);
        }
        return map;
    }

    public static int hashCode(HasIdGetter<?> hasIdGetter) {
        return hasIdGetter == null || hasIdGetter.getId() == null ? 0 : hasIdGetter.getId().hashCode();
    }

    public static boolean equalsUsingId(HasIdGetter<?> hasIdGetter1, HasIdGetter<?> hasIdGetter2) {
        return IdUtil.equalsUsingId(hasIdGetter1, hasIdGetter2, false);
    }

    public static boolean equalsUsingId(HasIdGetter<?> hasIdGetter1, HasIdGetter<?> hasIdGetter2, boolean nullEquals) {
        if (hasIdGetter1 == null) {
            if (hasIdGetter2 == null) {
                return nullEquals;
            }
            return false;
        }
        if (hasIdGetter2 == null) {
            return false;
        }
        Object id1 = hasIdGetter1.getId();
        Object id2 = hasIdGetter2.getId();
        if (id1 == null) {
            if (id2 == null) {
                return nullEquals;
            }
            return false;
        }
        if (id2 == null) {
            return false;
        }
        return id1.equals(id2);
    }

    public static <T extends HasIdGetter<?>> List<T> idAsc(Collection<T> source) {
        return IdUtil.sort(source, ID_ASC);
    }

    public static <T extends HasIdGetter<?>> List<T> idDesc(Collection<T> source) {
        return IdUtil.sort(source, ID_DESC);
    }

    public static <T extends HasIdGetter<?>> T findById(Object id, Collection<T> source) {
        for (HasIdGetter t : source) {
            if (!Objects.equals(id, t.getId())) continue;
            return (T)t;
        }
        return null;
    }

    private static <T extends HasIdGetter<?>> List<T> sort(Collection<T> source, Comparator<HasIdGetter<?>> comparator) {
        List list = source instanceof List ? (List)source : Lists.newArrayList(source);
        Collections.sort(list, comparator);
        return list;
    }
}

