/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.util;

import com.google.common.collect.Lists;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    public static final String JSON = "application/json";
    public static final String XML = "application/xml";
    public static final String FORM = "application/x-www-form-urlencoded";

    public static String doGet(String url, Map<String, ?> params, String charset) throws Exception {
        if (params != null && !params.isEmpty()) {
            if (!url.endsWith("?")) {
                url = url + "?";
            }
            url = url + HttpUtil.buildQuery(params, Lists.newArrayList(), charset);
        }
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        HttpEntity entity = response.getEntity();
        String dataStr = EntityUtils.toString((HttpEntity)entity, (String)charset);
        return dataStr;
    }

    public static String doJsonPost(String url, String content, String charset) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        StringEntity jsonEntity = new StringEntity(content, charset);
        httpPost.addHeader("Content-Type", JSON);
        httpPost.setEntity((HttpEntity)jsonEntity);
        CloseableHttpResponse res = HttpClients.createDefault().execute((HttpUriRequest)httpPost);
        HttpEntity entity = res.getEntity();
        String dataStr = EntityUtils.toString((HttpEntity)entity, (String)charset);
        return dataStr;
    }

    public static String doXmlPost(String url, String content, String charset) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        StringEntity xmlEntity = new StringEntity(content, charset);
        httpPost.addHeader("Content-Type", XML);
        httpPost.setEntity((HttpEntity)xmlEntity);
        CloseableHttpResponse res = HttpClients.createDefault().execute((HttpUriRequest)httpPost);
        HttpEntity entity = res.getEntity();
        String dataStr = EntityUtils.toString((HttpEntity)entity, (String)charset);
        return dataStr;
    }

    public static String doFormPost(String url, Map<String, ?> map, String charset) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        List<NameValuePair> nvps = HttpUtil.map2NameValuePairList(map);
        UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(nvps, charset);
        httpPost.addHeader("Content-Type", FORM);
        httpPost.setEntity((HttpEntity)postEntity);
        CloseableHttpResponse res = HttpClients.createDefault().execute((HttpUriRequest)httpPost);
        HttpEntity entity = res.getEntity();
        String dataStr = EntityUtils.toString((HttpEntity)entity, (String)charset);
        return dataStr;
    }

    public static String buildQuery(Map<String, ?> params, List<String> exclusiveParas, String charset) throws Exception {
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Object value = params.get(key);
            if (StringUtils.isBlank((CharSequence)key) || value == null || value.equals("") || exclusiveParas.contains(key)) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + URLEncoder.encode(value.toString(), charset));
            ++index;
        }
        return content.toString();
    }

    public static List<NameValuePair> map2NameValuePairList(Map<String, ?> map) {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        for (Map.Entry<String, ?> parasEntry : map.entrySet()) {
            String parasName = parasEntry.getKey();
            Object parasValue = parasEntry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)parasName) || parasValue == null || parasValue.equals("")) continue;
            nvps.add((NameValuePair)new BasicNameValuePair(parasName, parasValue.toString()));
        }
        return nvps;
    }

    public static Map<String, Object> paraFilter(Map<String, ?> map, List<String> paraNames) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, ?> e : map.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            if (value == null || value.equals("") || paraNames.contains(key)) continue;
            result.put(key, value);
        }
        return result;
    }
}

