package com.thebeastshop.support;

import com.google.common.collect.Lists;
import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;
import com.thebeastshop.support.mark.HasName;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/**
 * 会员访问的来源渠道
 *
 * @author Liang Wenjian
 */
public enum AccessWay implements HasIntIdGetter, HasName {
    UNKNOWN(0, "未知"),
    PC(1, "PC"),
    APP(2, "APP"),
    WAP(3, "WAP"),
    OFFLINE(4, "线下门店");

    public static final Collection<AccessWay> ALL = Collections.unmodifiableCollection(Arrays.asList(values()));

    public final int id;
    public final String name;

    AccessWay(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }

    public static AccessWay valueOf(final int id) {
        for (final AccessWay accessWay : values()) {
            if (accessWay.getId() == id) {
                return accessWay;
            }
        }
        return UNKNOWN;
    }

    public static Collection<AccessWay> valuesOf(final int bits) {
        final Collection<AccessWay> rt = Lists.newArrayList();
        for (final AccessWay accessWay : values()) {
            final Integer id = accessWay.getId();
            if ((bits & 1 << id) != 0) {
                rt.add(accessWay);
            }
        }
        return rt;
    }
}
