package com.thebeastshop.support.vo;

import java.io.Serializable;

/**
 * 抄自org.apache.httpcomponents/httpcore/4.3.2 org.apache.http.message.BasicNameValuePair
 *
 * @author Liang Wenjian
 */
public class NameValuePair implements Cloneable, Serializable {
    private static final long serialVersionUID = 153134524369023108L;

    private final String name;
    @SuppressWarnings("serial")
    private final Object value;

    public NameValuePair(final String name, final Object value) {
        this.name = notNull(name, "Name");
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Object getValue() {
        return value;
    }

    public String toString() {
        return name + "=" + value;
    }

    public boolean equals(final Object object) {
        if(this == object) {
            return true;
        } else if(!(object instanceof NameValuePair)) {
            return false;
        } else {
            final NameValuePair that = (NameValuePair) object;
            return name.equals(that.name) && equals(value, that.value);
        }
    }

    public int hashCode() {
        final byte hash = 17;
        int hash1 = hashCode(hash, name);
        hash1 = hashCode(hash1, value);
        return hash1;
    }

    @Override
    public Object clone()
        throws CloneNotSupportedException {
        return super.clone();
    }

    private static <T> T notNull(final T argument, final String name) {
        if(argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        } else {
            return argument;
        }
    }

    private static boolean equals(final Object obj1, final Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    private static int hashCode(final int seed, final int hashcode) {
        return seed * 37 + hashcode;
    }

    private static int hashCode(final int seed, final Object obj) {
        return hashCode(seed, obj != null ? obj.hashCode() : 0);
    }
}
