package com.thebeastshop.support.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;

import com.thebeastshop.support.mark.HasPrice;

/**
 * 价格计算工具
 * 
 * @author Paul-xiong
 *
 */
public class PriceUtil {

	/**
	 * 保留到分，厘位四舍五入
	 *
	 * @return
	 */
	public static double keepToCent(final double d) {
		return BigDecimal.valueOf(d).setScale(2, RoundingMode.HALF_UP).doubleValue();
	}

	public static double keepToCent(final HasPrice hasPrice) {
		return keepToCent(hasPrice.getPrice());
	}

	/**
	 * 计算总价，四舍五入保留到分
	 *
	 * @param price
	 * @param count
	 * @return
	 */
	public static double multiPrice(final double price, final int count) {
		return keepToCent(price * count);
	}

	/**
	 * 计算总价
	 *
	 * @param source
	 * @return
	 */
	public static double sumPrice(final Collection<? extends HasPrice> source) {
		double rt = 0;
		for (final HasPrice t : source) {
			rt += t.getPrice();
		}
		return keepToCent(rt);
	}
}
