/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.support.util;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.support.util.json.jackson.Jacksons;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

/**
 * json工具类
 *
 * @author Paul-xiong
 */
public class JsonUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);

    private static final Jacksons JACKSONS = Jacksons.defaultJacksons();

    public static String toJson(final Object obj) {
        return JACKSONS.toString(obj);
    }

    public static <T> T toObject(final String json, final Class<T> clazz) throws Exception {
        return JACKSONS.toObject(json, clazz);
    }

    public static <T> List<T> toList(final String json, final Class<T> clazz) {
        return JACKSONS.toBeans(json, clazz);
    }

    public static Map<String, Object> toMap(final String json) throws Exception {
        // convert JSON string to Map
        return JACKSONS.toMap(json);
//        final Map<String, Object> map = OBJECT_MAPPER.readValue(json, new TypeReference<Map<String, Object>>() {});
    }

    public static String toJson(final Map<String, ?> map) throws Exception {
        // convert map to JSON string
        return JACKSONS.toString(map);
    }

    /**
     * @author lijing
     * 使用alibaba的json转换
     * @param json
     * @param clazz
     * @param <T>
     * @return
     * @throws Exception
     */
    public static <T> T alibabaToObject(final String json,final Class<T> clazz) throws Exception{
        return JSON.parseObject(json, clazz);
    }

    /**
     * 使用alibabajson转为集合对象
     * @param json
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> List<T> alibabaToList(final String json, final Class<T> clazz) {
        return JSON.parseArray(json,clazz);
    }
}
