/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.support.util;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import com.google.common.collect.Lists;

/**
 * http工具
 * 
 * @author Paul-xiong
 *
 */
public class HttpUtil {
	public static final String JSON = "application/json";

	public static final String XML = "application/xml";

	public static final String FORM = "application/x-www-form-urlencoded";

	/**
	 * 执行get请求
	 * 
	 * @param url
	 *            url链接
	 * @param params
	 *            请求参数
	 * @param charset
	 *            字符编码
	 * @return
	 * @throws Exception
	 */
	public static String doGet(String url, Map<String, ?> params, String charset) throws Exception {
		if (params != null && !params.isEmpty()) {
			if (!url.endsWith("?")) {
				url += "?";
			}
			url += buildQuery(params, Lists.<String> newArrayList(), charset);
		}

		HttpGet httpGet = new HttpGet(url);
		CloseableHttpClient httpclient = HttpClients.createDefault();
		HttpResponse response = httpclient.execute(httpGet);
		HttpEntity entity = response.getEntity();
		String dataStr = EntityUtils.toString(entity, charset);
		return dataStr;
	}

	/**
	 * 执行json格式的post请求
	 * 
	 * @param url
	 *            url链接
	 * @param content
	 *            请求参数内容
	 * @param charset
	 *            字符编码
	 * @return
	 * @throws Exception
	 */
	public static String doJsonPost(String url, String content, String charset) throws Exception {
		HttpPost httpPost = new HttpPost(url);
		StringEntity jsonEntity = new StringEntity(content, charset);
		httpPost.addHeader("Content-Type", JSON);
		httpPost.setEntity(jsonEntity);

		// 设置请求器的配置
		// httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(50).setConnectTimeout(50).setSocketTimeout(50).build());

		HttpResponse res = HttpClients.createDefault().execute(httpPost);

		HttpEntity entity = res.getEntity();

		String dataStr = EntityUtils.toString(entity, charset);
		return dataStr;
	}

	/**
	 * 执行xml格式的post请求
	 * 
	 * @param url
	 *            url链接
	 * @param content
	 *            请求参数内容
	 * @param charset
	 *            字符编码
	 * @return
	 * @throws Exception
	 */
	public static String doXmlPost(String url, String content, String charset) throws Exception {
		HttpPost httpPost = new HttpPost(url);
		StringEntity xmlEntity = new StringEntity(content, charset);
		httpPost.addHeader("Content-Type", XML);
		httpPost.setEntity(xmlEntity);

		// 设置请求器的配置
		// httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(50).setConnectTimeout(50).setSocketTimeout(50).build());

		HttpResponse res = HttpClients.createDefault().execute(httpPost);

		HttpEntity entity = res.getEntity();

		String dataStr = EntityUtils.toString(entity, charset);
		return dataStr;
	}

	/**
	 * 执行form表单的post请求
	 * 
	 * @param url
	 *            url链接
	 * @param paramObj
	 *            请求参数map集合
	 * @param charset
	 *            字符编码
	 * @return
	 * @throws Exception
	 */
	public static String doFormPost(String url, Map<String, ?> map, String charset) throws Exception {
		HttpPost httpPost = new HttpPost(url);
		List<NameValuePair> nvps = map2NameValuePairList(map);
		UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(nvps, charset);
		httpPost.addHeader("Content-Type", FORM);
		httpPost.setEntity(postEntity);

		// 设置请求器的配置
		// httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(50).setConnectTimeout(50).setSocketTimeout(50).build());

		HttpResponse res = HttpClients.createDefault().execute(httpPost);

		HttpEntity entity = res.getEntity();

		String dataStr = EntityUtils.toString(entity, charset);
		return dataStr;
	}

	/**
	 * 拼接url请求参数（&key=value形式）
	 * 
	 * @param params
	 *            参数集合
	 * @param exclusivePara
	 *            排除的参数
	 * @param charset
	 *            字符编码
	 * @return
	 * @throws Exception
	 */
	public static String buildQuery(Map<String, ?> params, List<String> exclusiveParas, String charset)
			throws Exception {
		StringBuilder content = new StringBuilder();
		List<String> keys = new ArrayList<String>(params.keySet());
		Collections.sort(keys);
		int index = 0;
		for (int i = 0; i < keys.size(); i++) {
			String key = keys.get(i);
			Object value = params.get(key);
			if (StringUtils.isBlank(key) || value == null || value.equals("") || exclusiveParas.contains(key)) {
				continue;
			}
			content.append((index == 0 ? "" : "&") + key + "=" + URLEncoder.encode(value.toString(), charset));
			index++;
		}
		return content.toString();
	}

	public static List<NameValuePair> map2NameValuePairList(Map<String, ?> map) {
		List<NameValuePair> nvps = new ArrayList<NameValuePair>();
		for (Entry<String, ?> parasEntry : map.entrySet()) {
			String parasName = parasEntry.getKey();
			Object parasValue = parasEntry.getValue();
			if (StringUtils.isNotBlank(parasName) && parasValue != null && !parasValue.equals("")) {
				nvps.add(new BasicNameValuePair(parasName, parasValue.toString()));
			}
		}
		return nvps;
	}

	/**
	 * 过滤空值和指定参数
	 * 
	 * @param map
	 *            参数集合
	 * @param paraNames
	 *            需要过滤参数集合
	 * @return
	 * @throws Exception
	 */
	public static Map<String, Object> paraFilter(Map<String, ?> map, List<String> paraNames) throws Exception {
		Map<String, Object> result = new HashMap<String, Object>();
		for (Entry<String, ?> e : map.entrySet()) {
			String key = e.getKey();
			Object value = e.getValue();
			if (value == null || value.equals("") || paraNames.contains(key)) {
				continue;
			}
			result.put(key, value);
		}
		return result;
	}
}
