/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.support.util;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

/**
 * @author Eric.Lou
 * @version $Id: BeanFactoryUtil.java, v 0.1 2016-05-27 下午3:22
 */
public class BeanFactoryUtil implements BeanFactoryAware {

    private static BeanFactory factory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.factory = beanFactory;
    }

    public static Object getBean(String beanName){
        return factory.getBean(beanName);
    }

    public static <T> T getBean(String beanName,Class<T> clazz){
        return factory.getBean(beanName,clazz);
    }

    public static <T> T getBean(Class<T> clazz){
        return factory.getBean(clazz);
    }

}
