package com.thebeastshop.support.exception;

import com.thebeastshop.support.vo.NameValuePair;

import java.util.Arrays;

/**
 * 检测到参数错误时应抛出此异常。
 *
 * @author Liang Wenjian
 */
public class WrongArgException extends BaseException {

    private static final long serialVersionUID = -5954465849908546225L;

    private final NameValuePair[] args;

    //TODO:以后可以考虑开‘期望值’字段。

    //----------------------------------------------------

    public WrongArgException(final String argName, final Object actualValue) {
        super(replaceParams(argName, actualValue), NEXT_STEP_IDS_OF_RETRY);
        args = new NameValuePair[]{new NameValuePair(argName, actualValue)};
    }

    public WrongArgException(final String message, final String argName, final Object actualValue) {
        super(message, NEXT_STEP_IDS_OF_RETRY);
        args = new NameValuePair[]{new NameValuePair(argName, actualValue)};
    }

    public WrongArgException(final Throwable cause, final String argName, final Object actualValue) {
        this(replaceParams(argName, actualValue), cause, argName, actualValue);
    }

    public WrongArgException(final String message, final Throwable cause, final String argName,
                                final Object actualValue) {
        super(message, cause, NEXT_STEP_IDS_OF_RETRY);
        args = new NameValuePair[]{new NameValuePair(argName, actualValue)};
    }

    public WrongArgException(final NameValuePair... args) {
        this(replaceParams(args), args);
    }

    public WrongArgException(final String message, final NameValuePair... args) {
        super(message, NEXT_STEP_IDS_OF_RETRY);
        this.args = args;
    }

    public WrongArgException(final String message, final Throwable cause, final NameValuePair... args) {
        super(message, cause, NEXT_STEP_IDS_OF_RETRY);
        this.args = args;
    }
    //----------------------------------------------------

    public NameValuePair[] getArgs() {
        return args;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + hashCode() + ":{" +
                   "args:'" + Arrays.toString(args) + "'}";
    }

    protected static String replaceParams(final NameValuePair... args) {
        final StringBuilder sb = new StringBuilder();
        for(final NameValuePair arg : args) {
            final String argName = arg.getName();
            final Object actualValue = arg.getValue();
            sb.append("参数“").append(argName).append("”值“").append(actualValue).append("”有误，");
        }
        return sb.append("请修正后重新请求。").toString();
    }

    protected static String replaceParams(final String argName, final Object actualValue) {
        return "参数“" + argName + "”值“" + actualValue + "”有误，" + "请修正后重新请求。";
    }
}
