package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.State;

/**
 * 支付类型
 * 
 * @author Paul-xiong
 *
 */
public enum PaymentType implements State {
    CUSTOMER_SERVICE(0, "客服"),
    CASH(1, "现金"),
    DEBIT_CARD(2, "借记卡"),
    CREDIT_CARD(3, "信用卡"),
    WEIXIN(4, "微信"),
    ALIPAY(5, "支付宝"),
    CMB(6, "招行"),
    TRANSFER(7, "转账"),
    ;

    public final int id;
    public final String name;

    PaymentType(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }

}
