/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.mark;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

@FunctionalInterface
public interface Scoped {
    public static final String PROPERTY_NAME = "scope";

    public String getScope();

    public static class ScopeUtil {
        public static <T extends Scoped> Set<String> toScope(Iterable<T> source) {
            HashSet rt = Sets.newHashSet();
            for (Scoped t : source) {
                rt.add(t.getScope());
            }
            return rt;
        }

        public static <T extends Scoped> Collection<String> toScope(Collection<T> source) {
            return source.stream().map(Scoped::getScope).collect(Collectors.toSet());
        }

        public static <T extends Scoped> Multimap<String, T> map(Collection<T> source) {
            ArrayListMultimap map = ArrayListMultimap.create();
            for (Scoped t : source) {
                map.put((Object)t.getScope(), (Object)t);
            }
            return map;
        }

        public static boolean contains(String target, Collection<String> source) {
            for (String s : source) {
                if (!s.equalsIgnoreCase(target)) continue;
                return true;
            }
            return false;
        }
    }
}

