/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.mark;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;

@FunctionalInterface
public interface HasPrice {
    public double getPrice();

    public static double keepToCent(double d) {
        return BigDecimal.valueOf(d).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public static double keepToCent(HasPrice hasPrice) {
        return HasPrice.keepToCent(hasPrice.getPrice());
    }

    public static double multiPrice(double price, int count) {
        return HasPrice.keepToCent(price * (double)count);
    }

    public static double sumPrice(Collection<? extends HasPrice> source) {
        double rt = 0.0;
        for (HasPrice hasPrice : source) {
            rt += hasPrice.getPrice();
        }
        return HasPrice.keepToCent(rt);
    }
}

