package com.thebeastshop.support.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.thebeastshop.support.encode.MD5Util;

/**
 * MD5签名工具
 * 
 * @author Paul-xiong
 *
 */
public class MD5SignUtil {
	/**
	 * 获取签名内容
	 * 
	 * @param sortedParams
	 * @return
	 */
	public static String getSignContent(Map<String, ?> sortedParams) {
		StringBuffer content = new StringBuffer();
		List<String> keys = new ArrayList<String>(sortedParams.keySet());
		Collections.sort(keys);
		int index = 0;
		for (int i = 0; i < keys.size(); i++) {
			String key = keys.get(i);
			Object value = sortedParams.get(key);
			if (StringUtils.isNotBlank(key) && value != null && !value.equals("")) {
				content.append((index == 0 ? "" : "&") + key + "=" + value);
				index++;
			}
		}
		return content.toString();
	}

	/**
	 * 获取签名内容
	 * 
	 * @param obj
	 * @return
	 */
	public static String getSignContent(Object obj) throws Exception {
		Map<String, Object> sortedParams = BeanUtil.bean2Map(obj);
		return getSignContent(sortedParams);
	}

	/**
	 * 签名算法
	 * 
	 * @param o
	 * @param key
	 * @return
	 * @throws Exception
	 */
	public static String md5Sign(Object o, String key, String charset) throws Exception {
		return md5Sign(o, key, charset, true);
	}

	/**
	 * 签名算法
	 * 
	 * @param o
	 * @param key
	 * @param needKeyName
	 *            是否需要加上 &key 拼接
	 * @return
	 * @throws Exception
	 */
	public static String md5Sign(Object o, String key, String charset, boolean needKeyName) throws Exception {
		Map<String, Object> map = BeanUtil.bean2Map(o);
		return md5Sign(map, key, charset, needKeyName);
	}

	/**
	 * 签名算法
	 * 
	 * @param map
	 * @param key
	 * @return
	 */
	public static String md5Sign(Map<String, ?> map, String key, String charset) {
		return md5Sign(map, key, charset, true);
	}

	/**
	 * 签名算法
	 * 
	 * @param map
	 * @param key
	 * @param needKeyName
	 *            是否需要加上 &key 拼接
	 * @return
	 */
	public static String md5Sign(Map<String, ?> map, String key, String charset, boolean needKeyName) {
		String result = getSignContent(map);

		if (StringUtils.isNotBlank(key)) {
			if (needKeyName) {
				result += "&key=" + key;
			} else {
				result += key;
			}

		}
		return md5Sign(result, charset);
	}

	/**
	 * 签名算法
	 * 
	 * @param content
	 * @param charset
	 * @return
	 */
	public static String md5Sign(String content, String charset) {
		return MD5Util.md5ToHexString(content);
	}
}
