package com.thebeastshop.support.mark;

import java.util.Collection;

/**
 * @author Liang Wenjian
 */
@FunctionalInterface
public interface HasCount {

    /**
     * 获取数量。
     *
     * @return
     */
    int getCount();

    /**
     * 数量累加
     *
     * @param hasCounts
     * @return
     */
    static int count(final Collection<? extends HasCount> hasCounts) {
        int rt = 0;
        for (final HasCount hasCount : hasCounts) {
            rt += hasCount.getCount();
        }
        return rt;
    }
}
