package com.thebeastshop.support.mark;

import java.util.Comparator;

/**
 * 实现本接口意味着拥有enabled属性。
 *
 * @author Liang Wenjian
 */
@FunctionalInterface
public interface Able {

    String PROPERTY_NAME = "able";

    /**
     * 获取enabled属性的值。
     *
     * @return
     */
    boolean isEnabled();

    Comparator<Able> ABLE_ASC = (o1, o2) -> Boolean.valueOf(o1.isEnabled()).compareTo(o2.isEnabled());

    Comparator<Able> ABLE_DESC = ABLE_ASC.reversed();
}
