package com.thebeastshop.support.exception;

import com.thebeastshop.support.mark.Retryable;

/**
 * 电商平台api返回500响应时应抛出的异常。
 *
 * @author Liang Wenjian
 */
public class PlatInternalException extends BaseException implements PlatProblem, Retryable {
    public static final String DEFAULT_MSG = PlatProblemUtil.PLAT_NAME_PLACEHOLDER + "平台接口出现错误，请稍后重试或联系客服。";

    private static final long serialVersionUID = 1077946455116054913L;

    private final PlatErrInfo platErrInfo;
    private final int retryInterval;

    //----------------------------------------------------

    public PlatInternalException(final PlatErrInfo platErrInfo) {
        this(platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatInternalException(final PlatErrInfo platErrInfo, final int retryInterval) {
        super(PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo), NEXT_STEP_IDS_OF_REPORT_PROBLEM);
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatInternalException(final String message, final PlatErrInfo platErrInfo) {
        this(message, platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatInternalException(final String message, final PlatErrInfo platErrInfo, final int retryInterval) {
        super(message, NEXT_STEP_IDS_OF_REPORT_PROBLEM);
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatInternalException(final Throwable cause, final PlatErrInfo platErrInfo) {
        this(PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo), cause, platErrInfo);
    }

    public PlatInternalException(final String message, final Throwable cause, final PlatErrInfo platErrInfo) {
        this(message, cause, platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatInternalException(final String message, final Throwable cause, final PlatErrInfo platErrInfo,
                                    final int retryInterval) {
        super(message, cause, NEXT_STEP_IDS_OF_REPORT_PROBLEM);
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatInternalException(final Throwable cause, final PlatErrInfo platErrInfo, final int retryInterval) {
        this(PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo), cause, platErrInfo, retryInterval);
    }

    //----------------------------------------------------

    @Override
    public int getRetryInterval() {
        return retryInterval;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + hashCode() + ":{" +
                   "retryInterval:" + retryInterval +
                   ", platName:'" + getPlatName() + '\'' +
                   ", platErrCode:'" + getPlatErrCode() + '\'' +
                   ", platErrMsg:'" + getPlatErrMsg() + '\'' +
                   '}';
    }

    @Override
    public String getPlatName() {
        return platErrInfo.getPlatName();
    }

    @Override
    public String getPlatErrCode() {
        return platErrInfo.getPlatErrCode();
    }

    @Override
    public String getPlatErrMsg() {
        return platErrInfo.getPlatErrMsg();
    }
}
