/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.State;

/**
 * 物流类型
 * 
 * @author Paul-xiong
 *
 */
public enum  LogisticsType implements State {
    SHOP(1, "店送"),
    FEDEX(2, "联邦"),
    SF_AIR(3, "顺丰空运"),
    SF_LAND(4, "顺丰陆运"),
    YT(5, "圆通"),
    DEPPON(6, "德邦"),
    HT(7, "海涛顺丰"),
    ;

    public final int id;
    public final String name;

    LogisticsType(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}

