/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_STR_FORMAT = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT = "dd";
    public static final String MOUNTH_FORMAT = "MM";

    private static final SimpleDateFormat getFormat(String pattern, Locale locale) {
        return new SimpleDateFormat(pattern, locale);
    }

    public static String format(Date date, String pattern) {
        return DateUtil.format(date, pattern, Locale.getDefault());
    }

    public static String format(Date date, String pattern, Locale locale) {
        if (date == null) {
            return "";
        }
        if (StringUtils.isNotBlank((String)pattern)) {
            String format = DateUtil.getFormat(pattern, locale).format(date);
            return format;
        }
        throw new IllegalArgumentException("param pattern can not be null");
    }

    public static Date parse(String dateString, String pattern) {
        return DateUtil.parse(dateString, pattern, Locale.getDefault());
    }

    public static Date parse(String dateString, String pattern, Locale locale) {
        if (StringUtils.isNotBlank((String)dateString)) {
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = DateUtil.getFormat(pattern, locale).parse(dateString, parsePosition);
            Object[] objects = new Object[]{dateString, pattern};
            log.debug("dateString:[{}], pattern:[{}], parsePosition:[{}]", objects);
            return date;
        }
        throw new IllegalArgumentException("param dateString can not be null");
    }

    public static Date add(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int amount) {
        return DateUtil.add(date, 6, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtil.add(date, 12, amount);
    }

    public static Date dayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date dayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static String weekDayInChinese() {
        return DateUtil.weekDayInChinese(new Date());
    }

    public static String weekDayInChinese(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int week = calendar.get(7);
        switch (week) {
            case 1: {
                return "\u65e5";
            }
            case 2: {
                return "\u4e00";
            }
            case 3: {
                return "\u4e8c";
            }
            case 4: {
                return "\u4e09";
            }
            case 5: {
                return "\u56db";
            }
            case 6: {
                return "\u4e94";
            }
            case 7: {
                return "\u516d";
            }
        }
        return "";
    }

    public static Date getNow() {
        return new Date();
    }
}

