/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.mark;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.support.mark.IdCons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@FunctionalInterface
public interface HasIdGetter<I extends Comparable<I>>
extends IdCons {
    public static final String PROPERTY_NAME = "id";

    public I getId();

    public static class IdUtil
    implements IdCons {
        public static <I extends Comparable<I>> List<I> toIds(Collection<? extends HasIdGetter<I>> source) {
            return source.stream().map(HasIdGetter::getId).collect(Collectors.toList());
        }

        @SafeVarargs
        public static <I extends Comparable<I>> boolean contains(HasIdGetter<I> entity, I ... ids) {
            return IdUtil.contains(entity, Arrays.asList(ids));
        }

        public static <I extends Comparable<I>> boolean contains(HasIdGetter<I> entity, Collection<I> ids) {
            return ids.contains(entity.getId());
        }

        @SafeVarargs
        public static <I extends Comparable<I>> boolean contains(I id, HasIdGetter<I> ... entities) {
            return IdUtil.contains(id, Arrays.asList(entities));
        }

        public static <I extends Comparable<I>> boolean contains(I id, Collection<? extends HasIdGetter<I>> entities) {
            return IdUtil.toIds(entities).contains(id);
        }

        public static <I extends Comparable<I>> Collection<I> toParentIds(Collection<? extends HasParent<I>> source) {
            return source.stream().map(HasParent::getParentId).collect(Collectors.toList());
        }

        public static <I extends Comparable<I>, T extends HasIdGetter<I>> Map<I, T> map(Iterable<T> source) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (HasIdGetter t : source) {
                map.put(t.getId(), t);
            }
            return map;
        }

        public static int hashCode(HasIdGetter<?> hasIdGetter) {
            return hasIdGetter == null || hasIdGetter.getId() == null ? 0 : hasIdGetter.getId().hashCode();
        }

        public static boolean equalsUsingId(HasIdGetter<?> hasIdGetter1, HasIdGetter<?> hasIdGetter2) {
            return IdUtil.equalsUsingId(hasIdGetter1, hasIdGetter2, false);
        }

        public static boolean equalsUsingId(HasIdGetter<?> hasIdGetter1, HasIdGetter<?> hasIdGetter2, boolean nullEquals) {
            if (hasIdGetter1 == null) {
                if (hasIdGetter2 == null) {
                    return nullEquals;
                }
                return false;
            }
            if (hasIdGetter2 == null) {
                return false;
            }
            Object id1 = hasIdGetter1.getId();
            Object id2 = hasIdGetter2.getId();
            if (id1 == null) {
                if (id2 == null) {
                    return nullEquals;
                }
                return false;
            }
            if (id2 == null) {
                return false;
            }
            return id1.equals(id2);
        }

        public static <T extends HasIdGetter<?>> List<T> idAsc(Collection<T> source) {
            return IdUtil.sort(source, ID_ASC);
        }

        public static <T extends HasIdGetter<?>> List<T> idDesc(Collection<T> source) {
            return IdUtil.sort(source, ID_DESC);
        }

        public static <T extends HasIdGetter<?>> T findById(Object id, Collection<T> source) {
            for (HasIdGetter t : source) {
                if (!Objects.equals(id, t.getId())) continue;
                return (T)t;
            }
            return null;
        }

        private static <T extends HasIdGetter<?>> List<T> sort(Collection<T> source, Comparator<HasIdGetter<?>> comparator) {
            List list = source instanceof List ? (List)source : Lists.newArrayList(source);
            Collections.sort(list, comparator);
            return list;
        }

        private IdUtil() {
        }
    }

    public static class StrIdOnly
    extends IdOnly<String>
    implements HasStrId {
    }

    public static class IntIdOnly
    extends IdOnly<Integer>
    implements HasIntId {
    }

    public static class LongIdOnly
    extends IdOnly<Long>
    implements HasLongId {
    }

    public static class IdOnly<T extends Comparable<T>>
    implements HasId<T> {
        private T id;

        @Override
        public T getId() {
            return this.id;
        }

        @Override
        public void setId(T id) {
            this.id = id;
        }
    }

    public static interface HasStrId
    extends HasId<String>,
    HasStrIdGetter {
    }

    public static interface HasLongId
    extends HasId<Long>,
    HasLongIdGetter {
    }

    public static interface HasIntId
    extends HasId<Integer>,
    HasIntIdGetter {
    }

    public static interface HasId<I extends Comparable<I>>
    extends HasIdGetter<I> {
        public void setId(I var1);
    }

    @FunctionalInterface
    public static interface HasStrIdGetter
    extends HasIdGetter<String> {
        @Override
        public String getId();

        public static interface HasStrIdParent
        extends HasStrIdGetter,
        HasParent<String> {
            @Override
            public String getParentId();
        }
    }

    @FunctionalInterface
    public static interface HasLongIdGetter
    extends HasIdGetter<Long> {
        @Override
        public Long getId();

        public static interface HasLongIdParent
        extends HasLongIdGetter,
        HasParent<Long> {
            @Override
            public Long getParentId();
        }
    }

    @FunctionalInterface
    public static interface HasIntIdGetter
    extends HasIdGetter<Integer> {
        @Override
        public Integer getId();

        public static interface HasIntIdParent
        extends HasIntIdGetter,
        HasParent<Integer> {
            @Override
            public Integer getParentId();
        }
    }

    public static interface HasParent<I extends Comparable<I>>
    extends HasIdGetter<I> {
        public static final String PARENT_ID_PROPERTY_NAME = "parentId";
        public static final String PARENT_PROPERTY_NAME = "parent";

        public I getParentId();
    }
}

