/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2012 All Rights Reserved.
 */
package com.thebeastshop.support.util;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.thebeastshop.support.encode.Base64Util;
import com.thebeastshop.support.encode.RSAUtil;

/**
 * 支付宝签名工具
 * 
 * @author Paul-xiong
 *
 */
public class RSASignUtil {

	private static final String SIGN_TYPE_RSA = "RSA";

	private static final String SIGN_ALGORITHMS = "SHA1WithRSA";

	/**
	 * 获取签名内容
	 * 
	 * @param sortedParams
	 * @return
	 */
	public static String getSignContent(Map<String, ?> sortedParams) {
		StringBuffer content = new StringBuffer();
		List<String> keys = new ArrayList<String>(sortedParams.keySet());
		Collections.sort(keys);
		int index = 0;
		for (int i = 0; i < keys.size(); i++) {
			String key = keys.get(i);
			Object value = sortedParams.get(key);
			if (StringUtils.isNotBlank(key) && value != null && !value.equals("")) {
				content.append((index == 0 ? "" : "&") + key + "=" + value);
				index++;
			}
		}
		return content.toString();
	}

	/**
	 * 获取签名内容
	 * 
	 * @param obj
	 * @return
	 * @throws Exception
	 */
	public static String getSignContent(Object obj) throws Exception {
		Map<String, Object> sortedParams = BeanUtil.bean2Map(obj);
		return getSignContent(sortedParams);
	}

	/**
	 * 签名
	 * 
	 * @param content
	 * @param privateKey
	 * @param charset
	 * @return
	 * @throws Exception
	 */
	public static String rsaSign(String content, String privateKey, String charset) throws Exception {
		PrivateKey priKey = RSAUtil.getPrivateKeyFromPKCS8(SIGN_TYPE_RSA, privateKey);

		java.security.Signature signature = java.security.Signature.getInstance(SIGN_ALGORITHMS);

		signature.initSign(priKey);

		if (StringUtils.isEmpty(charset)) {
			signature.update(content.getBytes());
		} else {
			signature.update(content.getBytes(charset));
		}

		byte[] signed = signature.sign();

		return new String(Base64Util.encode(signed));
	}

	/**
	 * 签名
	 * 
	 * @param params
	 * @param privateKey
	 * @param charset
	 * @return
	 * @throws Exception
	 */
	public static String rsaSign(Map<String, ?> params, String privateKey, String charset) throws Exception {
		String signContent = getSignContent(params);

		return rsaSign(signContent, privateKey, charset);

	}

	/**
	 * 签名
	 * 
	 * @param obj
	 * @param privateKey
	 * @param charset
	 * @return
	 * @throws Exception
	 */
	public static String rsaSign(Object obj, String privateKey, String charset) throws Exception {
		Map<String, Object> params = BeanUtil.bean2Map(obj);
		return rsaSign(params, privateKey, charset);
	}

	/**
	 * 校验签名
	 * 
	 * @param content
	 * @param sign
	 * @param publicKey
	 * @param charset
	 * @return
	 * @throws Exception
	 */
	public static boolean rsaCheckSign(String content, String sign, String publicKey, String charset) throws Exception {
		PublicKey pubKey = RSAUtil.getPublicKeyFromX509("RSA", publicKey);

		java.security.Signature signature = java.security.Signature.getInstance(SIGN_ALGORITHMS);

		signature.initVerify(pubKey);

		if (StringUtils.isEmpty(charset)) {
			signature.update(content.getBytes());
		} else {
			signature.update(content.getBytes(charset));
		}

		return signature.verify(Base64Util.decode(new String(sign.getBytes())));
	}

}
