package com.thebeastshop.support.mark;

import java.util.Date;

/**
 * 会过期的事物的抽象接口。
 * 会过期的事物例子：证书、优惠券、活动等。
 *
 * @author Liang Wenjian
 */
public interface WillExpire {

    /**
     * 获取过期时间。
     *
     * @return 若不限过期时间则返回null
     */
    Date getExpireTime();

    /**
     * 是否已过期
     *
     * @return
     */
    default boolean isExpired() {
        final Date expireTime = getExpireTime();
        if (expireTime == null) {//没有过期时间，就视为永不过期吧。
            return false;
        }
        return new Date().after(expireTime);
    }

    /**
     * 开始时间
     *
     * @return 若不限开始时间则返回null。
     */
    Date getStartTime();
}
