package com.thebeastshop.support.mark;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 有范围的
 *
 * @author Liang Wenjian
 */
@FunctionalInterface
public interface Scoped {

    String PROPERTY_NAME = "scope";
    /**
     * 获取范围
     *
     * @return
     */
    String getScope();

    /**
     * 关于${@link Scoped}的工具类。
     */
    class ScopeUtil {

        /**
         * 将一个${@link Scoped}集合转换成它们的租户id的集合（去重）。
         *
         * @param source
         * @param <T>
         * @return
         */
        public static <T extends Scoped> Set<String> toScope(final Iterable<T> source) {
            final Set<String> rt = Sets.newHashSet();
            for (final T t : source) {
                rt.add(t.getScope());
            }
            return rt;
        }

        /**
         * 将一个${@link Scoped}集合转换成它们的租户id的集合。
         *
         * @param source
         * @param <T>
         * @return
         */
        public static <T extends Scoped> Collection<String> toScope(final Collection<T> source) {
            return source.stream()//
                    .map(Scoped::getScope)//
                    .collect(Collectors.toSet());
        }

        public static <T extends Scoped> Multimap<String, T> map(final Collection<T> source) {
            final Multimap<String, T> map = ArrayListMultimap.create();
            for (final T t : source) {
                map.put(t.getScope(), t);
            }

            return map;
        }

        public static boolean contains(final String target, final Collection<String> source) {
            for (final String s : source) {
                if (s.equalsIgnoreCase(target)) {
                    return true;
                }
            }
            return false;
        }
    }
}
