package com.thebeastshop.support.mark;

import java.util.Date;

/**
 * 实现本接口意味着拥有更新时间（updateTime）属性。
 *
 * @author Liang Wenjian
 */
@FunctionalInterface
public interface HasUpdateTime {
    /**
     * 获取创建时间
     *
     * @return 创建时间。
     */
    Date getUpdateTime();

    /**
     * 通过创建时间比较两个带有创建时间属性的对象。
     *
     * @param a 第一个对象
     * @param b 第二个对象
     * @return 第一个对象的创建时间与第二个对象的创建时间的比较结果（若第一个对象早于第二个对象，则返回负数；若晚于则返回正数，否则返回0）
     */
    static int compare(final HasUpdateTime a, final HasUpdateTime b) {
        return a.getUpdateTime().compareTo(b.getUpdateTime());
    }

}
