package com.thebeastshop.support.mark;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;

/**
 * 实现本接口意味着拥有价格（price）属性。
 *
 * @author Liang Wenjian
 */
@FunctionalInterface
public interface HasPrice {

    /**
     * 获取价格
     *
     * @return
     */
    double getPrice();

    //================================工具方法

    /**
     * 保留到分，厘位四舍五入
     *
     * @return
     */
    static double keepToCent(final double d) {
        return BigDecimal.valueOf(d).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    static double keepToCent(final HasPrice hasPrice) {
        return keepToCent(hasPrice.getPrice());
    }

    /**
     * 计算总价，四舍五入保留到分
     *
     * @param price
     * @param count
     * @return
     */
    static double multiPrice(final double price, final int count) {
        return keepToCent(price * count);
    }

    /**
     * 计算总价
     *
     * @param source
     * @return
     */
    static double sumPrice(final Collection<? extends HasPrice> source) {
        double rt = 0;
        for (final HasPrice t : source) {
            rt += t.getPrice();
        }
        return keepToCent(rt);
    }
}
