package com.thebeastshop.support.exception;

import com.thebeastshop.support.mark.Retryable;

/**
 * 连接平台时出现发生错误应抛出此异常。
 *
 * @author Liang Wenjian
 */
public class PlatNetworkException extends NetworkException implements PlatProblem, Retryable {
    public static final String DEFAULT_MSG = "调用" + PlatProblemUtil.PLAT_NAME_PLACEHOLDER + "平台接口时出现网络异常，请稍后重试或联系客服。";

    private static final long serialVersionUID = 1107836712614886538L;

    private final PlatErrInfo platErrInfo;
    private final int retryInterval;

    //----------------------------------------------------

    public PlatNetworkException(final PlatErrInfo platErrInfo) {
        this(platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatNetworkException(final PlatErrInfo platErrInfo, final int retryInterval) {
        super(PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo));
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatNetworkException(final String message, final PlatErrInfo platErrInfo) {
        this(message, platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatNetworkException(final String message, final PlatErrInfo platErrInfo, final int retryInterval) {
        super(message);
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatNetworkException(final String message, final Throwable cause, final PlatErrInfo platErrInfo) {
        this(message, cause, platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatNetworkException(final String message, final Throwable cause, final PlatErrInfo platErrInfo,
                                   final int retryInterval) {
        super(message, cause);
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatNetworkException(final Throwable cause, final PlatErrInfo platErrInfo) {
        this(cause, platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatNetworkException(final Throwable cause, final PlatErrInfo platErrInfo, final int retryInterval) {
        this(PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo), cause, platErrInfo, retryInterval);
    }

    //----------------------------------------------------

    @Override
    public int getRetryInterval() {
        return retryInterval;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + hashCode() + ":{" +
                   "platName:'" + getPlatName() + '\'' +
                   ", platErrCode:'" + getPlatErrCode() + '\'' +
                   ", platErrMsg:'" + getPlatErrMsg() + '\'' +
                   ", retryInterval:" + retryInterval +
                   '}';
    }

    @Override
    public String getPlatName() {
        return platErrInfo.getPlatName();
    }

    @Override
    public String getPlatErrCode() {
        return platErrInfo.getPlatErrCode();
    }

    @Override
    public String getPlatErrMsg() {
        return platErrInfo.getPlatErrMsg();
    }
}
