package com.thebeastshop.support;

import com.thebeastshop.support.mark.State;

/**
 * @author Eric.Lou
 * @version $Id: Title.java, v 0.1 2016-05-27 下午1:53
 */
public enum Title implements State {
    MR(1, "先生"),
    MS(2, "女士"),
    MISS(3, "小姐"),
    UNKNOWN(4, "保密"),
    ;

    public final int id;
    public final String name;

    Title(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}
