/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommDictionary;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class WhWarehouseVO
extends WhWarehouse {
    public static final Integer RELATE_IN = 1;
    public static final Integer RELATE_OUT = 2;
    public static final Integer WAREHOUSE_STATUS_CAN_USE = 1;
    public static final Integer WAREHOUSE_STATUS_DISABLED = 0;
    private Integer relateInOrOut;
    private Integer relateInOutSkuStatus;
    private Integer warehouseGroupType;
    public static final String WAREHOUSE_WH020600010096 = "WH020600010096";
    public static final String WAREHOUSE_MILD_DAMAGED = "WH020600010097";
    public static final String WAREHOUSE_MODERATE_DEFECTIVE = "WH020600010097";
    public static final String WAREHOUSE_MODERATE_DEFECTIVE_CONFIG = "zxl.warehouseModerateDefectiveCode";
    public static final String WAREHOUSE_SEVERE_DEFECTIVE = "WH020600010097";
    public static final String WAREHOUSE_SEVERE_DEFECTIVE_CONFIG = "zxl.warehouseSevereDefectiveCode";
    public static final String WAREHOUSE_WH020600010098 = "WH020600010098";
    public static final String WAREHOUSE_WH020600010101 = "WH020600010101";
    public static final String WAREHOUSE_DISPLAY_CONFIG = "zxl.warehouseDisplayCode";
    public static final String WAREHOUSE_WH020600010102 = "WH020600010102";
    public static final String WAREHOUSE_WH020600010120 = "WH020600010120";
    public static final String WAREHOUSE_WH02060036 = "WH02060036";
    public static final Integer TYPE_WAIT_FOR_DISPATCHING = 1;
    public static final Integer TYPE_DAMAGED = 2;
    public static final Integer TYPE_WASTED = 3;
    public static final Integer TYPE_GIFT = 4;
    public static final Integer TYPE_SAMPLE = 5;
    public static final Integer TYPE_PRODUCING = 6;
    public static final Integer TYPE_PROP = 7;
    public static final Integer TYPE_CHANNEL_SALES = 9;
    public static final Integer COMMODITY_STATUS_FOR_ALL_DAMAGED = 20;
    public static final Integer COMMODITY_STATUS_FOR_MILD_DAMAGED = 0;
    public static final Integer COMMODITY_STATUS_FOR_MODERATE_DAMAGED = 4;
    public static final Integer COMMODITY_STATUS_FOR_SEVERE_DAMAGED = 5;
    public static final Integer COMMODITY_STATUS_FOR_ALL_NONDEFECTIVE = 21;
    public static final Integer COMMODITY_STATUS_FOR_NONDEFECTIVE = 1;
    public static final Integer COMMODITY_STATUS_FOR_ALL_SAMPLE = 22;
    public static final Integer COMMODITY_STATUS_FOR_SAMPLE = 2;
    public static final Integer COMMODITY_STATUS_FOR_DISPLAY = 6;
    public static final Integer COMMODITY_STATUS_FOR_PROP = 7;
    public static final Integer COMMODITY_STATUS_FOR_ALL_WASTED = 23;
    public static final Integer COMMODITY_STATUS_FOR_WASTED = 3;
    public static final Integer COMMODITY_STATUS_FOR_HOLD_PENDING = 8;
    public static final Map<Integer, String> WAREHOUSE_TYPE_MAP = new HashMap(){
        {
            this.put(TYPE_WAIT_FOR_DISPATCHING, "\u826f\u54c1\u5f85\u5206\u914d\u4ed3");
            this.put(TYPE_DAMAGED, "\u6b8b\u6b21\u54c1\u4ed3");
            this.put(TYPE_WASTED, "\u5e9f\u54c1\u4ed3");
            this.put(TYPE_GIFT, "\u793c\u54c1\u4ed3");
            this.put(TYPE_SAMPLE, "\u6837\u54c1\u4ed3");
            this.put(TYPE_PRODUCING, "\u751f\u4ea7\u52a0\u5de5\u4ed3");
            this.put(TYPE_CHANNEL_SALES, "\u6e20\u9053\u9500\u552e\u4ed3");
            this.put(TYPE_PROP, "\u9053\u5177\u4ed3");
        }
    };
    public static final Map<Integer, String> COMMODITY_STATUS_DETAIL_MAP = new HashMap(){
        {
            this.put(COMMODITY_STATUS_FOR_NONDEFECTIVE, "\u826f\u54c1");
            this.put(COMMODITY_STATUS_FOR_SAMPLE, "\u6837\u54c1");
            this.put(COMMODITY_STATUS_FOR_DISPLAY, "\u9648\u5217\u54c1");
            this.put(COMMODITY_STATUS_FOR_MILD_DAMAGED, "\u8f7b\u6b8b\u54c1");
            this.put(COMMODITY_STATUS_FOR_MODERATE_DAMAGED, "\u4e2d\u6b8b\u54c1");
            this.put(COMMODITY_STATUS_FOR_SEVERE_DAMAGED, "\u91cd\u6b8b\u54c1");
            this.put(COMMODITY_STATUS_FOR_WASTED, "\u5e9f\u54c1");
            this.put(COMMODITY_STATUS_FOR_PROP, "\u8d44\u4ea7\uff08\u5de5\u7a0b\u90e8\u4e13\u7528\uff09");
            this.put(COMMODITY_STATUS_FOR_HOLD_PENDING, "\u5f85\u5b9a");
        }
    };
    public static final Map<Integer, String> NOT_DEFECTIVE_COMMODITY_STATUS_DETAIL_MAP = new HashMap(){
        {
            this.put(COMMODITY_STATUS_FOR_NONDEFECTIVE, "\u826f\u54c1");
            this.put(COMMODITY_STATUS_FOR_SAMPLE, "\u6837\u54c1");
            this.put(COMMODITY_STATUS_FOR_DISPLAY, "\u9648\u5217\u54c1");
            this.put(COMMODITY_STATUS_FOR_WASTED, "\u5e9f\u54c1");
            this.put(COMMODITY_STATUS_FOR_PROP, "\u8d44\u4ea7\uff08\u5de5\u7a0b\u90e8\u4e13\u7528\uff09");
            this.put(COMMODITY_STATUS_FOR_HOLD_PENDING, "\u5f85\u5b9a");
        }
    };
    public static final Map<Integer, String> RELATE_MAP = new HashMap(){
        {
            this.put(RELATE_IN, "\u5165");
            this.put(RELATE_OUT, "\u51fa");
        }
    };

    public Integer getRelateInOutSkuStatus() {
        return this.relateInOutSkuStatus;
    }

    public void setRelateInOutSkuStatus(Integer relateInOutSkuStatus) {
        this.relateInOutSkuStatus = relateInOutSkuStatus;
    }

    public Integer getRelateInOrOut() {
        return this.relateInOrOut;
    }

    public void setRelateInOrOut(Integer relateInOrOut) {
        this.relateInOrOut = relateInOrOut;
    }

    public Integer getWarehouseGroupType() {
        return this.warehouseGroupType;
    }

    public void setWarehouseGroupType(Integer warehouseGroupType) {
        this.warehouseGroupType = warehouseGroupType;
    }

    public static List<Integer> getSkuStatusList() {
        ArrayList skuStatus = new ArrayList(){
            {
                this.add(COMMODITY_STATUS_FOR_NONDEFECTIVE);
                this.add(COMMODITY_STATUS_FOR_SAMPLE);
                this.add(COMMODITY_STATUS_FOR_DISPLAY);
                this.add(COMMODITY_STATUS_FOR_MILD_DAMAGED);
                this.add(COMMODITY_STATUS_FOR_MODERATE_DAMAGED);
                this.add(COMMODITY_STATUS_FOR_SEVERE_DAMAGED);
                this.add(COMMODITY_STATUS_FOR_WASTED);
                this.add(COMMODITY_STATUS_FOR_PROP);
                this.add(COMMODITY_STATUS_FOR_HOLD_PENDING);
            }
        };
        return skuStatus;
    }

    public static List<Integer> getChildCommodityStatusByParentId(Integer parentId) {
        ArrayList<Integer> skuStatus = new ArrayList<Integer>();
        if (COMMODITY_STATUS_FOR_ALL_NONDEFECTIVE.equals(parentId)) {
            skuStatus.add(COMMODITY_STATUS_FOR_NONDEFECTIVE);
        } else if (COMMODITY_STATUS_FOR_ALL_DAMAGED.equals(parentId)) {
            skuStatus.add(COMMODITY_STATUS_FOR_MILD_DAMAGED);
            skuStatus.add(COMMODITY_STATUS_FOR_MODERATE_DAMAGED);
            skuStatus.add(COMMODITY_STATUS_FOR_SEVERE_DAMAGED);
        } else if (COMMODITY_STATUS_FOR_ALL_SAMPLE.equals(parentId)) {
            skuStatus.add(COMMODITY_STATUS_FOR_SAMPLE);
            skuStatus.add(COMMODITY_STATUS_FOR_DISPLAY);
        } else if (COMMODITY_STATUS_FOR_ALL_WASTED.equals(parentId)) {
            skuStatus.add(COMMODITY_STATUS_FOR_WASTED);
        }
        return skuStatus;
    }

    public static List<KeyValueVO> getCommodityStatusKeyValueVOs() {
        List<Integer> keyList = WhWarehouseVO.getSkuStatusList();
        ArrayList<KeyValueVO> commodityStatusKVs = new ArrayList<KeyValueVO>();
        for (Integer key : keyList) {
            String value = COMMODITY_STATUS_DETAIL_MAP.get(key);
            if (EmptyUtil.isEmpty((String)value)) continue;
            commodityStatusKVs.add(new KeyValueVO(key.toString(), value));
        }
        return commodityStatusKVs;
    }

    public static List<KeyValueVO> getCommodityStatusKeyValueVOsByDic(List<CommDictionary> commDictionaries) {
        ArrayList<KeyValueVO> commodityStatusKVs = new ArrayList<KeyValueVO>();
        if (CollectionUtils.isEmpty(commDictionaries)) {
            return commodityStatusKVs;
        }
        for (CommDictionary commDic : commDictionaries) {
            commodityStatusKVs.add(new KeyValueVO(commDic.getDictValue(), commDic.getDictName()));
        }
        return commodityStatusKVs;
    }

    public static Integer convertSkuStatusByCommodityStatus(Integer commodityStatus) {
        return commodityStatus;
    }

    public static String getSkuStatusName(Integer skuStatus) {
        if (EmptyUtil.isEmpty((Object)skuStatus)) {
            return "";
        }
        String skuStatusName = COMMODITY_STATUS_DETAIL_MAP.get(skuStatus);
        return EmptyUtil.isEmpty((String)skuStatusName) ? "" : skuStatusName;
    }

    public static boolean isDamagedCommodity(Integer skuStatus) {
        if (EmptyUtil.isEmpty((Object)skuStatus)) {
            return false;
        }
        return COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(skuStatus) || COMMODITY_STATUS_FOR_MODERATE_DAMAGED.equals(skuStatus) || COMMODITY_STATUS_FOR_SEVERE_DAMAGED.equals(skuStatus) || COMMODITY_STATUS_FOR_ALL_DAMAGED.equals(skuStatus);
    }

    public static String fetchDiffWarehouseByCommodityStatus(Integer commodityStatus) {
        return COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(commodityStatus) ? "WH020600360218" : (COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(commodityStatus) ? "WH020600360219" : (COMMODITY_STATUS_FOR_SAMPLE.equals(commodityStatus) ? "WH020600360220" : "WH020600360218"));
    }
}

