/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.List;

public class WhRecipeInvVO {
    private String warehouseCode;
    private String skuCode;
    private String skuName;
    private String skuNameCn;
    private String warehouseName;
    private String nameCn;
    private boolean customization = false;
    private boolean recipeExist = false;
    private List<WhMaterialRecipeInvVO> materialSkuInvList;

    public int getCanUseInv() {
        if (EmptyUtil.isEmpty(this.materialSkuInvList)) {
            return 0;
        }
        int quantity = Integer.MAX_VALUE;
        for (WhMaterialRecipeInvVO materialSkuInv : this.materialSkuInvList) {
            quantity = Math.min(materialSkuInv.getCanUseInv(), quantity);
        }
        return Math.max(quantity, 0);
    }

    public String getWarehouseCode() {
        return this.warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getSkuCode() {
        return this.skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return this.skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getSkuNameCn() {
        return this.skuNameCn;
    }

    public void setSkuNameCn(String skuNameCn) {
        this.skuNameCn = skuNameCn;
    }

    public String getWarehouseName() {
        return this.warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getNameCn() {
        return this.nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public boolean isCustomization() {
        return this.customization;
    }

    public void setCustomization(boolean customization) {
        this.customization = customization;
    }

    public List<WhMaterialRecipeInvVO> getMaterialSkuInvList() {
        return this.materialSkuInvList;
    }

    public void setMaterialSkuInvList(List<WhMaterialRecipeInvVO> materialSkuInvList) {
        this.materialSkuInvList = materialSkuInvList;
    }

    public boolean isRecipeExist() {
        return this.recipeExist;
    }

    public void setRecipeExist(boolean recipeExist) {
        this.recipeExist = recipeExist;
    }

    public static class WhMaterialRecipeInvVO {
        private String warehouseCode;
        private String skuCode;
        private Float recipeAmount;
        private String skuName;
        private String skuNameCn;
        private String warehouseName;
        private String nameCn;
        private WhInvVO skuInvVO;

        public int getCanUseInv() {
            if (this.skuInvVO == null) {
                return 0;
            }
            return Math.max((int)Math.floor((float)this.skuInvVO.getCanUseInv() / this.recipeAmount.floatValue()), 0);
        }

        public String getWarehouseCode() {
            return this.warehouseCode;
        }

        public void setWarehouseCode(String warehouseCode) {
            this.warehouseCode = warehouseCode;
        }

        public String getSkuCode() {
            return this.skuCode;
        }

        public void setSkuCode(String skuCode) {
            this.skuCode = skuCode;
        }

        public String getSkuName() {
            return this.skuName;
        }

        public void setSkuName(String skuName) {
            this.skuName = skuName;
        }

        public String getSkuNameCn() {
            return this.skuNameCn;
        }

        public void setSkuNameCn(String skuNameCn) {
            this.skuNameCn = skuNameCn;
        }

        public String getWarehouseName() {
            return this.warehouseName;
        }

        public void setWarehouseName(String warehouseName) {
            this.warehouseName = warehouseName;
        }

        public String getNameCn() {
            return this.nameCn;
        }

        public void setNameCn(String nameCn) {
            this.nameCn = nameCn;
        }

        public Float getRecipeAmount() {
            return this.recipeAmount;
        }

        public void setRecipeAmount(Float recipeAmount) {
            this.recipeAmount = recipeAmount;
        }

        public WhInvVO getSkuInvVO() {
            return this.skuInvVO;
        }

        public void setSkuInvVO(WhInvVO skuInvVO) {
            this.skuInvVO = skuInvVO;
        }
    }
}

