/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.util;

import com.thebeastshop.common.kafka.KafkaConsumerListener;
import com.thebeastshop.pegasus.integration.email.vo.EmailAttachmentVO;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.service.warehouse.common.SCMWmsMessage;
import com.thebeastshop.pegasus.service.warehouse.common.ScmSkuListVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsShelvesSkuInfoCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStockRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WmsScmCheckRecord;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhTakeStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsScmCheckRecordService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsShelvesSkuInfoService;
import com.thebeastshop.pegasus.service.warehouse.util.DateTool;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsShelvesSkuInfoVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RabbitReceiver
extends KafkaConsumerListener<SCMWmsMessage> {
    private static final Logger logger = LoggerFactory.getLogger(RabbitReceiver.class);
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhTakeStockService whTakeStockService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhWmsScmCheckRecordService whWmsScmCheckRecordService;
    @Autowired
    private WhWmsShelvesSkuInfoService whWmsShelvesSkuInfoService;
    private static final String[] EXCEL_HEAD = new String[]{"SKU_CODE", "SKU\u540d\u79f0", "\u5bf9\u5e94\u4ed3\u5e93", "\u5dee\u5f02\u6570", "SKU\u7c7b\u578b", "\u53ef\u7528\u5269\u4f59\u6570\u91cf"};
    private static final String[] EMAIL_ADDRESSS_XHJ = new String[]{"planning@thebeastshop.com", "david.yan@thebeastshop.com", "sizhen.ma@thebeastshop.com"};
    private static final String officialChannelCode = "WH020600010102";

    public void processMessage(String s, SCMWmsMessage scmWmsMessage) {
        ArrayList<List<String>> excelLines = new ArrayList<List<String>>();
        excelLines.add(this.getExcelHead());
        if (null != scmWmsMessage) {
            try {
                this.handlePandianDate(scmWmsMessage, excelLines);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            logger.info("scmWmsMessage\u5bf9\u8c61\u4e3a\u7a7a");
        }
    }

    public List<String> getExcelHead() {
        ArrayList<String> head = new ArrayList<String>();
        for (String ar : EXCEL_HEAD) {
            head.add(ar);
        }
        return head;
    }

    public void handlePandianDate(SCMWmsMessage scmWmsMessage, List<List<String>> excelLines) throws Exception {
        logger.info("\u8fdb\u5165 \u76d8\u70b9\u5bf9\u8c61\u5904\u7406\u4fe1\u606f  \u53c2\u6570  scmWmsMessage={}", (Object)scmWmsMessage);
        HashMap<String, Map<String, Integer>> goodProduct = new HashMap<String, Map<String, Integer>>();
        HashMap<String, Map<String, Integer>> defectiveProduct = new HashMap<String, Map<String, Integer>>();
        HashMap<String, Map<String, Integer>> sampleProduct = new HashMap<String, Map<String, Integer>>();
        List<ScmSkuListVO> scmSkuListVOList = scmWmsMessage.getSkuList();
        if (CollectionUtils.isNotEmpty(scmSkuListVOList)) {
            for (ScmSkuListVO scmSkuListVO : scmSkuListVOList) {
                HashMap<String, Integer> goodP;
                Integer quantityCount;
                Map goodsProd;
                if (null == scmSkuListVO || scmSkuListVO.getSkuCodeStatus() == null) continue;
                if (scmSkuListVO.getSkuCodeStatus() == 1) {
                    goodsProd = (Map)goodProduct.get(scmSkuListVO.getPhysicWarehouseCode());
                    if (goodsProd != null) {
                        quantityCount = (Integer)goodsProd.get(scmSkuListVO.getSkuCode());
                        if (quantityCount != null) {
                            quantityCount = quantityCount + scmSkuListVO.getQuantity();
                            goodsProd.put(scmSkuListVO.getSkuCode(), quantityCount);
                        } else {
                            goodsProd.put(scmSkuListVO.getSkuCode(), scmSkuListVO.getQuantity());
                        }
                        goodProduct.put(scmSkuListVO.getPhysicWarehouseCode(), goodsProd);
                        continue;
                    }
                    goodP = new HashMap<String, Integer>();
                    goodP.put(scmSkuListVO.getSkuCode(), scmSkuListVO.getQuantity());
                    goodProduct.put(scmSkuListVO.getPhysicWarehouseCode(), goodP);
                    continue;
                }
                if (scmSkuListVO.getSkuCodeStatus() == 0) {
                    goodsProd = (Map)defectiveProduct.get(scmSkuListVO.getPhysicWarehouseCode());
                    if (goodsProd != null) {
                        quantityCount = (Integer)goodsProd.get(scmSkuListVO.getSkuCode());
                        if (quantityCount != null) {
                            quantityCount = quantityCount + scmSkuListVO.getQuantity();
                            goodsProd.put(scmSkuListVO.getSkuCode(), quantityCount);
                        } else {
                            goodsProd.put(scmSkuListVO.getSkuCode(), scmSkuListVO.getQuantity());
                        }
                        defectiveProduct.put(scmSkuListVO.getPhysicWarehouseCode(), goodsProd);
                        continue;
                    }
                    goodP = new HashMap();
                    goodP.put(scmSkuListVO.getSkuCode(), scmSkuListVO.getQuantity());
                    defectiveProduct.put(scmSkuListVO.getPhysicWarehouseCode(), goodP);
                    continue;
                }
                goodsProd = (Map)sampleProduct.get(scmSkuListVO.getPhysicWarehouseCode());
                if (goodsProd != null) {
                    quantityCount = (Integer)goodsProd.get(scmSkuListVO.getSkuCode());
                    if (quantityCount != null) {
                        quantityCount = quantityCount + scmSkuListVO.getQuantity();
                        goodsProd.put(scmSkuListVO.getSkuCode(), quantityCount);
                    } else {
                        goodsProd.put(scmSkuListVO.getSkuCode(), scmSkuListVO.getQuantity());
                    }
                    sampleProduct.put(scmSkuListVO.getPhysicWarehouseCode(), goodsProd);
                    continue;
                }
                goodP = new HashMap();
                goodP.put(scmSkuListVO.getSkuCode(), scmSkuListVO.getQuantity());
                sampleProduct.put(scmSkuListVO.getPhysicWarehouseCode(), goodP);
            }
        }
        logger.info("goodProduct ={}", goodProduct);
        logger.info("defectiveProduct ={}", defectiveProduct);
        logger.info("sampleProduct ={}", sampleProduct);
        this.hanldGoodProduct(goodProduct, scmWmsMessage.getUserId(), scmWmsMessage.getWmsId(), excelLines);
        this.hanlddefectiveProduct(defectiveProduct, scmWmsMessage.getUserId(), scmWmsMessage.getWmsId(), excelLines);
        this.hanldsampleProduct(sampleProduct, scmWmsMessage.getUserId(), scmWmsMessage.getWmsId(), excelLines);
        logger.info("\u5904\u7406\u5b8c\u6210\uff01");
    }

    public EmailVO setEmail(byte[] number) {
        EmailVO emailVO = new EmailVO();
        ArrayList<EmailAttachmentVO> emailAttachmentVOs = new ArrayList<EmailAttachmentVO>();
        EmailAttachmentVO emailAttachmentVO = new EmailAttachmentVO(DateTool.date2String(new Date(), "yyyy-MM-dd") + new Random().nextInt(100) + "\u76d8\u70b9.xlsx", number);
        emailAttachmentVOs.add(emailAttachmentVO);
        emailVO.setAttachmentList(emailAttachmentVOs);
        emailVO.setContent("\u8fd9\u662f\u76d8\u70b9\u7684\u5dee\u5f02\u8868\u683c\uff0c\u8bf7\u67e5\u6536");
        emailVO.setSubject("\u8fd9\u662f\u76d8\u70b9\u7684\u5dee\u5f02\u8868\u683c\uff0c\u8bf7\u67e5\u6536");
        ArrayList<String> emailAddress = new ArrayList<String>();
        for (String str : EMAIL_ADDRESSS_XHJ) {
            emailAddress.add(str);
        }
        emailVO.setToAddressList(emailAddress);
        return emailVO;
    }

    public void hanldGoodProduct(Map<String, Map<String, Integer>> goodProduct, Long userId, Long wmsId, List<List<String>> excelLines) throws Exception {
        if (!goodProduct.isEmpty()) {
            for (Map.Entry<String, Map<String, Integer>> entry : goodProduct.entrySet()) {
                String physicWarehouseCode = entry.getKey();
                Map<String, Integer> skus = entry.getValue();
                for (Map.Entry<String, Integer> skusEn : skus.entrySet()) {
                    String skuCode = skusEn.getKey();
                    Integer quantity = skusEn.getValue();
                    List<WhWarehouse> whWarehouses = this.whInfoService.findWarehouseByPhysicalCodeAndStatus(physicWarehouseCode, 1);
                    if (quantity > 0) {
                        if (CollectionUtils.isNotEmpty(whWarehouses)) {
                            WhInvVO goodProductWhInvVO = this.whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode, whWarehouses.get(0).getCode());
                            Long id = this.saveCreateTakeStock(skuCode, quantity, userId, whWarehouses.get(0).getCode());
                            logger.info("\u8c03\u7528scm\u76d8\u70b9\u8fd4\u56de id ={}", (Object)id);
                            if (id > 0L) {
                                int c = this.saveWmsScmCheckRecord(wmsId, id, userId);
                                WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                ArrayList<String> ececlSet = new ArrayList<String>();
                                ececlSet.add(skuCode);
                                ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "");
                                ececlSet.add(whWarehouses.get(0).getName());
                                ececlSet.add(quantity + "");
                                ececlSet.add("\u826f\u54c1");
                                ececlSet.add((goodProductWhInvVO == null ? 0 : goodProductWhInvVO.getCanUseInv()) + quantity + "");
                                excelLines.add(ececlSet);
                                logger.info("\u4fdd\u5b58\u8bb0\u5f55 \u8fd4\u56de c={}", (Object)c);
                            } else {
                                logger.info("\u8c03\u7528scm\u76d8\u70b9\u8fd4\u56de id \u9519\u8bef ");
                            }
                        } else {
                            logger.info("\u901a\u8fc7\u7269\u7406\u4ed3\u6ca1\u6709\u67e5\u8be2\u5230 \u826f\u54c1\u4ed3");
                        }
                    }
                    if (quantity >= 0) continue;
                    if (CollectionUtils.isNotEmpty(whWarehouses)) {
                        logger.info("====\u76d8\u4e8fscm\u5f00\u59cb\u8ba1\u7b97\u5904\u7406 === ");
                        this.lossCalc(skuCode, quantity, whWarehouses.get(0).getCode(), whWarehouses.get(0).getName(), wmsId, userId, excelLines);
                        logger.info("====\u76d8\u4e8fscm\u7ed3\u675f\u8ba1\u7b97\u5904\u7406 === ");
                        continue;
                    }
                    logger.info("\u826f\u54c1\u4ed3 \u67e5\u8be2\u4e3a\u7a7a \u5c31\u6ca1\u6709\u8d70\u4e8f\u7684\u60c5\u51b5   \u5bf9\u5e94\u7684sku\u4e3a={} \u6570\u91cf\u4e3a={}", (Object)skuCode, (Object)quantity);
                }
            }
        }
    }

    public void lossCalc(String skuCode, Integer quantity, String warehouseCode, String warehouseName, Long wmsId, Long userId, List<List<String>> execlList) throws Exception {
        logger.info("\u76d8\u4e8f\u7684\u8bb0\u5f55  \u53c2\u6570 ==skuCode={},quantity={},warehouseCode={}", new Object[]{skuCode, quantity, warehouseCode});
        if (StringUtils.isNotBlank((String)skuCode)) {
            HashMap<String, Integer> quanT = new HashMap<String, Integer>();
            WhInvVO goodProductWhInvVO = this.whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode, warehouseCode);
            WhInvVO officialProductWhInvVO = this.whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode, officialChannelCode);
            if (null != goodProductWhInvVO) {
                Integer goodSproCount = goodProductWhInvVO.getCanUseInv();
                if (goodSproCount + quantity >= 0) {
                    logger.info("\u826f\u54c1\u4ed3\u6ee1\u8db3\u4e86\u8981\u6c42 skuCode={}", (Object)skuCode);
                    Long scmId = this.saveCreateTakeStock(skuCode, quantity, userId, warehouseCode);
                    if (scmId > 0L) {
                        WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                        whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                        List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                        ArrayList<String> ececlSet = new ArrayList<String>();
                        ececlSet.add(skuCode);
                        ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "");
                        ececlSet.add(warehouseName);
                        ececlSet.add(quantity + "");
                        ececlSet.add("\u826f\u54c1");
                        ececlSet.add(goodSproCount + quantity + "");
                        execlList.add(ececlSet);
                        this.saveWmsScmCheckRecord(wmsId, scmId, userId);
                    } else {
                        logger.info("\u521b\u5efa\u76d8\u70b9\u5931\u8d25\uff0cscm\u76d8\u70b9\u8fd4\u56de \u5c0f\u4e8e0");
                    }
                    return;
                }
                if (goodSproCount >= 0) {
                    quanT.put("goodsP", 0 - goodSproCount);
                    quantity = quantity + goodSproCount;
                    if (officialProductWhInvVO != null) {
                        ArrayList<String> ececlSet;
                        List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos;
                        WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond;
                        logger.info("\u5b98\u7f51\u6e20\u9053 \u6709skuCode\u7684\u6570\u91cf\u4fe1\u606f");
                        Integer guanwangQu = officialProductWhInvVO.getCanUseInv();
                        if (guanwangQu + quantity >= 0) {
                            ArrayList<String> ececlSet2;
                            List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos2;
                            WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond2;
                            Long scmId = this.saveCreateTakeStock(skuCode, (Integer)quanT.get("goodsP"), userId, warehouseCode);
                            Long scmGuanId = this.saveCreateTakeStock(skuCode, quantity, userId, officialChannelCode);
                            if (scmId > 0L) {
                                this.saveWmsScmCheckRecord(wmsId, scmId, userId);
                                whWmsShelvesSkuInfoCond2 = new WhWmsShelvesSkuInfoCond();
                                whWmsShelvesSkuInfoCond2.setSkuCode(skuCode);
                                whWmsShelvesSkuInfos2 = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond2);
                                ececlSet2 = new ArrayList<String>();
                                ececlSet2.add(skuCode);
                                ececlSet2.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos2) ? whWmsShelvesSkuInfos2.get(0).getSkuNameCN() : "");
                                ececlSet2.add(warehouseName);
                                ececlSet2.add(quanT.get("goodsP") + "");
                                ececlSet2.add("\u826f\u54c1");
                                ececlSet2.add(goodSproCount + (Integer)quanT.get("goodsP") + "");
                                execlList.add(ececlSet2);
                            } else {
                                logger.info("\u521b\u5efa\u76d8\u70b9\u5931\u8d25\uff0cscm\u76d8\u70b9\u8fd4\u56de \u5c0f\u4e8e0");
                            }
                            if (scmGuanId > 0L) {
                                this.saveWmsScmCheckRecord(wmsId, scmGuanId, userId);
                                whWmsShelvesSkuInfoCond2 = new WhWmsShelvesSkuInfoCond();
                                whWmsShelvesSkuInfoCond2.setSkuCode(skuCode);
                                whWmsShelvesSkuInfos2 = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond2);
                                ececlSet2 = new ArrayList();
                                ececlSet2.add(skuCode);
                                ececlSet2.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos2) ? whWmsShelvesSkuInfos2.get(0).getSkuNameCN() : "");
                                ececlSet2.add("\u5b98\u7f51\u4ed3");
                                ececlSet2.add(quantity + "");
                                ececlSet2.add("\u826f\u54c1");
                                ececlSet2.add(guanwangQu + quantity + "");
                                execlList.add(ececlSet2);
                            } else {
                                logger.info("\u521b\u5efa\u76d8\u70b9\u5b98\u7f51\u7684\u6e20\u9053\u5931\u8d25\uff0cscm\u76d8\u70b9\u8fd4\u56de \u5c0f\u4e8e0");
                            }
                            return;
                        }
                        logger.info("\u5b98\u7f51\u6e20\u9053\u7684 \u6570\u91cf\u4e5f\u4e0d\u591f\u51cf\u5c11\u7684 skuCode={}  \u901b\u7f51\u6e20\u9053\u6570\u91cf\u4e3a={}   ,\u73b0\u5728\u9700\u8981\u6263\u51cf\u7684\u6570\u91cf\u4e3a={}   \u73b0\u5728\u5168\u90e8\u6263\u51cf\u5230\u826f\u54c1", new Object[]{skuCode, guanwangQu, quantity});
                        quanT.put("guanwang", guanwangQu);
                        quantity = quantity + guanwangQu;
                        Integer goodG = (Integer)quanT.get("goodsP");
                        Long scmId = this.saveCreateTakeStock(skuCode, goodG + quantity, userId, warehouseCode);
                        logger.info("\u826f\u54c1\u4ed3 \u76d8\u70b9id scmId={}", (Object)scmId);
                        Long scmGuanId = this.saveCreateTakeStock(skuCode, 0 - guanwangQu, userId, officialChannelCode);
                        if (scmId > 0L) {
                            this.saveWmsScmCheckRecord(wmsId, scmId, userId);
                            whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                            whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                            whWmsShelvesSkuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                            ececlSet = new ArrayList<String>();
                            ececlSet.add(skuCode);
                            ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "");
                            ececlSet.add(warehouseName);
                            ececlSet.add(goodG + quantity + "");
                            ececlSet.add("\u826f\u54c1");
                            ececlSet.add(goodSproCount + (goodG + quantity) + "");
                            execlList.add(ececlSet);
                        } else {
                            logger.info("\u521b\u5efa\u76d8\u70b9\u5931\u8d25\uff0cscm\u76d8\u70b9\u8fd4\u56de \u5c0f\u4e8e0");
                        }
                        if (scmGuanId > 0L) {
                            this.saveWmsScmCheckRecord(wmsId, scmGuanId, userId);
                            whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                            whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                            whWmsShelvesSkuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                            ececlSet = new ArrayList();
                            ececlSet.add(skuCode);
                            ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "");
                            ececlSet.add("\u5b98\u7f51\u4ed3");
                            ececlSet.add(0 - guanwangQu + "");
                            ececlSet.add("\u826f\u54c1");
                            ececlSet.add(guanwangQu + (0 - guanwangQu) + "");
                            execlList.add(ececlSet);
                        } else {
                            logger.info("\u521b\u5efa\u76d8\u70b9\u5b98\u7f51\u7684\u6e20\u9053\u5931\u8d25\uff0cscm\u76d8\u70b9\u8fd4\u56de \u5c0f\u4e8e0");
                        }
                        return;
                    }
                    logger.info("\u5b98\u7f51\u6e20\u9053  sku  \u67e5\u8be2\u6570\u91cf\u4e3a\u7a7a skuCode={}  \u628a\u6240\u6709\u7684\u5e93\u5b58\u6263\u51cf\u5230\u4e86  \u826f\u54c1\u4e2d", (Object)skuCode);
                    Integer cTt = (Integer)quanT.get("goodsP");
                    cTt = cTt + quantity;
                    Long scmId = this.saveCreateTakeStock(skuCode, cTt, userId, warehouseCode);
                    if (scmId > 0L) {
                        this.saveWmsScmCheckRecord(wmsId, scmId, userId);
                        WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                        whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                        List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                        ArrayList<String> ececlSet = new ArrayList<String>();
                        ececlSet.add(skuCode);
                        ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "");
                        ececlSet.add(warehouseName);
                        ececlSet.add(cTt + "");
                        ececlSet.add("\u826f\u54c1");
                        ececlSet.add(goodSproCount + cTt + "");
                        execlList.add(ececlSet);
                    } else {
                        logger.info("\u521b\u5efa\u76d8\u70b9\u5931\u8d25\uff0cscm\u76d8\u70b9\u8fd4\u56de \u5c0f\u4e8e0");
                    }
                } else {
                    if (officialProductWhInvVO != null) {
                        Integer guanwangQu = officialProductWhInvVO.getCanUseInv();
                        if (guanwangQu + quantity >= 0) {
                            Long scmGuanId = this.saveCreateTakeStock(skuCode, (int)quantity, userId, officialChannelCode);
                            if (scmGuanId > 0L) {
                                this.saveWmsScmCheckRecord(wmsId, scmGuanId, userId);
                                WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                ArrayList<String> ececlSet = new ArrayList<String>();
                                ececlSet.add(skuCode);
                                ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "");
                                ececlSet.add("\u5b98\u7f51\u4ed3");
                                ececlSet.add(quantity + "");
                                ececlSet.add("\u826f\u54c1");
                                ececlSet.add(guanwangQu + quantity + "");
                                execlList.add(ececlSet);
                            } else {
                                logger.info("\u521b\u5efa\u76d8\u70b9\u5b98\u7f51\u7684\u6e20\u9053\u5931\u8d25\uff0cscm\u76d8\u70b9\u8fd4\u56de \u5c0f\u4e8e0");
                            }
                            return;
                        }
                        if (guanwangQu >= 0) {
                            ArrayList<String> ececlSet;
                            List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos;
                            WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond;
                            quantity = quantity + guanwangQu;
                            Long scmId = this.saveCreateTakeStock(skuCode, quantity, userId, warehouseCode);
                            logger.info("\u826f\u54c1\u4ed3 \u76d8\u70b9id scmId={}", (Object)scmId);
                            Long scmGuanId = this.saveCreateTakeStock(skuCode, 0 - guanwangQu, userId, officialChannelCode);
                            if (scmId > 0L) {
                                whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                whWmsShelvesSkuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                ececlSet = new ArrayList<String>();
                                ececlSet.add(skuCode);
                                ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "");
                                ececlSet.add(warehouseName);
                                ececlSet.add(quantity + "");
                                ececlSet.add("\u826f\u54c1");
                                ececlSet.add(goodSproCount + quantity + "");
                                execlList.add(ececlSet);
                                this.saveWmsScmCheckRecord(wmsId, scmId, userId);
                            } else {
                                logger.info("\u521b\u5efa\u76d8\u70b9\u5931\u8d25\uff0cscm\u76d8\u70b9\u8fd4\u56de \u5c0f\u4e8e0");
                            }
                            if (scmGuanId > 0L) {
                                whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                whWmsShelvesSkuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                ececlSet = new ArrayList();
                                ececlSet.add(skuCode);
                                ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "");
                                ececlSet.add("\u5b98\u7f51\u4ed3");
                                ececlSet.add(0 - guanwangQu + "");
                                ececlSet.add("\u826f\u54c1");
                                ececlSet.add(guanwangQu + (0 - guanwangQu) + "");
                                execlList.add(ececlSet);
                                this.saveWmsScmCheckRecord(wmsId, scmGuanId, userId);
                            } else {
                                logger.info("\u521b\u5efa\u76d8\u70b9\u5b98\u7f51\u7684\u6e20\u9053\u5931\u8d25\uff0cscm\u76d8\u70b9\u8fd4\u56de \u5c0f\u4e8e0");
                            }
                            return;
                        }
                        Long scmId = this.saveCreateTakeStock(skuCode, (int)quantity, userId, warehouseCode);
                        if (scmId > 0L) {
                            WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                            whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                            List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                            ArrayList<String> ececlSet = new ArrayList<String>();
                            ececlSet.add(skuCode);
                            ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "");
                            ececlSet.add(warehouseName);
                            ececlSet.add(quantity + "");
                            ececlSet.add("\u826f\u54c1");
                            ececlSet.add(goodSproCount + quantity + "");
                            execlList.add(ececlSet);
                            this.saveWmsScmCheckRecord(wmsId, scmId, userId);
                        } else {
                            logger.info("\u521b\u5efa\u76d8\u70b9\u5931\u8d25\uff0cscm\u76d8\u70b9\u8fd4\u56de \u5c0f\u4e8e0");
                        }
                        return;
                    }
                    logger.info("fushu \u5b98\u7f51\u6e20\u9053  sku  \u67e5\u8be2\u6570\u91cf\u4e3a\u7a7a skuCode={}  \u628a\u6240\u6709\u7684\u5e93\u5b58\u6263\u51cf\u5230\u4e86  \u826f\u54c1\u4e2d", (Object)skuCode);
                    Long scmId = this.saveCreateTakeStock(skuCode, (int)quantity, userId, warehouseCode);
                    if (scmId > 0L) {
                        WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                        whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                        List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                        ArrayList<String> ececlSet = new ArrayList<String>();
                        ececlSet.add(skuCode);
                        ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "");
                        ececlSet.add(warehouseName);
                        ececlSet.add(quantity + "");
                        ececlSet.add("\u826f\u54c1");
                        ececlSet.add(goodSproCount + quantity + "");
                        execlList.add(ececlSet);
                        this.saveWmsScmCheckRecord(wmsId, scmId, userId);
                    } else {
                        logger.info("\u521b\u5efa\u76d8\u70b9\u5931\u8d25\uff0cscm\u76d8\u70b9\u8fd4\u56de \u5c0f\u4e8e0");
                    }
                }
            } else {
                logger.error("\u76d8\u70b9\u7684\u826f\u54c1\u4ed3\u67e5\u8be2\u4e3a\u7a7a \u5bf9\u5e94\u7684wms\u7684\u76d8\u70b9\u4e3a wmsId={}, skuCode={},quantity={}", new Object[]{wmsId, skuCode, quantity});
            }
        } else {
            logger.error("\u76d8\u4e8f\u7684sku \u4e3a\u7a7a");
        }
    }

    public Long saveCreateTakeStock(String skuCode, Integer quantity, Long userId, String whwarCode) throws Exception {
        logger.info("\u8c03\u7528scm \u53c2\u6570  skuCode={},quantity={},userId={},whwarCode={}", new Object[]{skuCode, quantity, userId, whwarCode});
        WhTakeStock whTakeStock = new WhTakeStock();
        whTakeStock.setCreateUserId(userId);
        whTakeStock.setWarehouseCode(whwarCode);
        ArrayList<WhTakeStockRcd> whTakeStockRcds = new ArrayList<WhTakeStockRcd>();
        WhTakeStockRcd whTakeStockRcd = new WhTakeStockRcd();
        whTakeStockRcd.setQuantity(quantity);
        whTakeStockRcd.setSkuCode(skuCode);
        whTakeStockRcds.add(whTakeStockRcd);
        whTakeStock.setWhTakeStockRcdList(whTakeStockRcds);
        Long id = this.whTakeStockService.createTakeStock(whTakeStock);
        logger.info("\u4fdd\u5b58\u7684\u7ed3\u679c\u4e3aid={}", (Object)id);
        return id;
    }

    public Long saveCreateTakeStockPist(Map<String, Integer> skuCodeQuantity, Long userId, String whwarCode, String whwarName, List<List<String>> excelLines, int type) throws Exception {
        logger.info("\u8c03\u7528scm \u53c2\u6570 skuCodeQuantity={},userId={},whwarCode={}", new Object[]{skuCodeQuantity, userId, whwarCode});
        WhTakeStock whTakeStock = new WhTakeStock();
        whTakeStock.setCreateUserId(userId);
        whTakeStock.setWarehouseCode(whwarCode);
        ArrayList<WhTakeStockRcd> whTakeStockRcds = new ArrayList<WhTakeStockRcd>();
        for (Map.Entry<String, Integer> skusEn : skuCodeQuantity.entrySet()) {
            WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
            whWmsShelvesSkuInfoCond.setSkuCode(skusEn.getKey());
            List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
            WhInvVO goodProductWhInvVO = this.whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skusEn.getKey(), whwarCode);
            ArrayList<String> ececlSet = new ArrayList<String>();
            ececlSet.add(skusEn.getKey());
            ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "");
            ececlSet.add(whwarName);
            ececlSet.add(skusEn.getValue() + "");
            ececlSet.add(type == 0 ? "\u6b8b\u6b21\u54c1" : "\u6837\u54c1");
            ececlSet.add((goodProductWhInvVO == null ? 0 : goodProductWhInvVO.getCanUseInv()) + skusEn.getValue() + "");
            excelLines.add(ececlSet);
            WhTakeStockRcd whTakeStockRcd = new WhTakeStockRcd();
            whTakeStockRcd.setQuantity(skusEn.getValue());
            whTakeStockRcd.setSkuCode(skusEn.getKey());
            whTakeStockRcds.add(whTakeStockRcd);
        }
        whTakeStock.setWhTakeStockRcdList(whTakeStockRcds);
        Long id = this.whTakeStockService.createTakeStock(whTakeStock);
        logger.info("\u4fdd\u5b58\u7684\u7ed3\u679c\u4e3aid={}", (Object)id);
        return id;
    }

    public void hanlddefectiveProduct(Map<String, Map<String, Integer>> defectiveProduct, Long userId, Long wmsId, List<List<String>> excelLines) throws Exception {
        if (!defectiveProduct.isEmpty()) {
            for (Map.Entry<String, Map<String, Integer>> entry : defectiveProduct.entrySet()) {
                String physicWarehouseCode = entry.getKey();
                Map<String, Integer> skus = entry.getValue();
                List<WhWarehouse> whWarehouses = this.whInfoService.findWarehouseByPhysicalCodeAndStatus(physicWarehouseCode, 2);
                if (CollectionUtils.isNotEmpty(whWarehouses)) {
                    Long id = this.saveCreateTakeStockPist(skus, userId, whWarehouses.get(0).getCode(), whWarehouses.get(0).getName(), excelLines, 0);
                    logger.info("\u8c03\u7528scm\u76d8\u70b9\u8fd4\u56de id ={}", (Object)id);
                    if (id > 0L) {
                        int c = this.saveWmsScmCheckRecord(wmsId, id, userId);
                        logger.info("\u4fdd\u5b58\u8bb0\u5f55 \u8fd4\u56de c={}", (Object)c);
                        continue;
                    }
                    logger.info("\u8c03\u7528scm\u76d8\u70b9\u8fd4\u56de id \u9519\u8bef ");
                    continue;
                }
                logger.info("\u901a\u8fc7\u7269\u7406\u4ed3\u6ca1\u6709\u67e5\u8be2\u5230 \u6b8b\u54c1\u4ed3");
            }
        }
    }

    public void hanldsampleProduct(Map<String, Map<String, Integer>> sampleProduct, Long userId, Long wmsId, List<List<String>> excelLines) throws Exception {
        if (!sampleProduct.isEmpty()) {
            for (Map.Entry<String, Map<String, Integer>> entry : sampleProduct.entrySet()) {
                String physicWarehouseCode = entry.getKey();
                Map<String, Integer> skus = entry.getValue();
                List<WhWarehouse> whWarehouses = this.whInfoService.findWarehouseByPhysicalCodeAndStatus(physicWarehouseCode, 5);
                if (CollectionUtils.isNotEmpty(whWarehouses)) {
                    Long id = this.saveCreateTakeStockPist(skus, userId, whWarehouses.get(0).getCode(), whWarehouses.get(0).getName(), excelLines, 2);
                    logger.info("\u8c03\u7528scm\u76d8\u70b9\u8fd4\u56de id ={}", (Object)id);
                    if (id > 0L) {
                        int c = this.saveWmsScmCheckRecord(wmsId, id, userId);
                        logger.info("\u4fdd\u5b58\u8bb0\u5f55 \u8fd4\u56de c={}", (Object)c);
                        continue;
                    }
                    logger.info("\u8c03\u7528scm\u76d8\u70b9\u8fd4\u56de id \u9519\u8bef ");
                    continue;
                }
                logger.info("\u901a\u8fc7\u7269\u7406\u4ed3\u6ca1\u6709\u67e5\u8be2\u5230 \u6b8b\u54c1\u4ed3");
            }
        }
    }

    public int saveWmsScmCheckRecord(Long wmsId, Long scmId, Long userId) {
        logger.info("\u4fdd\u5b58\u8bb0\u5f55\u53c2\u6570  wmsId={},scmId={},userId={}", new Object[]{wmsId, scmId, userId});
        WmsScmCheckRecord wmsScmCheckRecord = new WmsScmCheckRecord();
        wmsScmCheckRecord.setScmId(scmId);
        wmsScmCheckRecord.setWmsId(wmsId);
        wmsScmCheckRecord.setUserId(userId);
        return this.whWmsScmCheckRecordService.insertWmsScmCheckRecord(wmsScmCheckRecord);
    }
}

