/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.util;

import com.thebeastshop.pegasus.util.comm.ObjectId;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.object.DateMorpher;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.JSONUtils;

public class JsonUtil {
    public static final String JSON_ATTRIBUTE = "json";
    public static final String JSON_ATTRIBUTE1 = "json1";
    public static final String JSON_ATTRIBUTE2 = "json2";
    public static final String JSON_ATTRIBUTE3 = "json3";
    public static final String JSON_ATTRIBUTE4 = "json4";

    public static Object getDTO(String jsonString, Class<?> clazz) {
        JSONObject jsonObject = null;
        try {
            JsonUtil.setDataFormat2JAVA();
            jsonObject = JSONObject.fromObject((Object)jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return JSONObject.toBean((JSONObject)jsonObject, clazz);
    }

    public static Object getDTO(String jsonString, Class<?> clazz, Map<?, ?> map) {
        JSONObject jsonObject = null;
        try {
            JsonUtil.setDataFormat2JAVA();
            jsonObject = JSONObject.fromObject((Object)jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return JSONObject.toBean((JSONObject)jsonObject, clazz, map);
    }

    public static Object[] getDTOArray(String jsonString, Class<?> clazz) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject((Object)jsonString);
        Object[] obj = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            obj[i] = JSONObject.toBean((JSONObject)jsonObject, clazz);
        }
        return obj;
    }

    public static Object[] getDTOArray(String jsonString, Class<?> clazz, Map<?, ?> map) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject((Object)jsonString);
        Object[] obj = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            obj[i] = JSONObject.toBean((JSONObject)jsonObject, clazz, map);
        }
        return obj;
    }

    public static List getDTOList(String jsonString, Class clazz) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject((Object)jsonString);
        ArrayList<Object> list = new ArrayList<Object>();
        for (JSONObject jsonObject : array) {
            list.add(JSONObject.toBean((JSONObject)jsonObject, (Class)clazz));
        }
        return list;
    }

    public static List getDTOList(String jsonString, Class clazz, Map map) {
        JsonUtil.setDataFormat2JAVA();
        JSONArray array = JSONArray.fromObject((Object)jsonString);
        ArrayList<Object> list = new ArrayList<Object>();
        for (JSONObject jsonObject : array) {
            list.add(JSONObject.toBean((JSONObject)jsonObject, (Class)clazz, (Map)map));
        }
        return list;
    }

    public static Map getMapFromJson(String jsonString) {
        JsonUtil.setDataFormat2JAVA();
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            map.put(key, jsonObject.get(key));
        }
        return map;
    }

    public static Object[] getObjectArrayFromJson(String jsonString) {
        JSONArray jsonArray = JSONArray.fromObject((Object)jsonString);
        return jsonArray.toArray();
    }

    public static String getJSONString(Object object) {
        String jsonString = null;
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new JsonDateValueProcessor());
        jsonConfig.registerJsonValueProcessor(ObjectId.class, (JsonValueProcessor)new JsonObjectIdValueProcessor());
        if (object != null) {
            jsonString = object instanceof Collection || object instanceof Object[] ? JSONArray.fromObject((Object)object, (JsonConfig)jsonConfig).toString() : JSONObject.fromObject((Object)object, (JsonConfig)jsonConfig).toString();
        }
        return jsonString == null ? "{}" : jsonString;
    }

    public static String getRetJsonString(int status, Object object) {
        String jsonString = JsonUtil.getJSONString(object);
        String ret = "{\"status\":" + status + ", \"result\":" + (jsonString == null ? "{}" : jsonString) + "}";
        System.out.println("retJsonString:" + ret);
        return ret;
    }

    public static JSONObject getJSONObject(String jsonString) {
        JSONObject jsonObject = null;
        try {
            JsonUtil.setDataFormat2JAVA();
            jsonObject = JSONObject.fromObject((Object)jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    private static void setDataFormat2JAVA() {
        JSONUtils.getMorpherRegistry().registerMorpher((Morpher)new DateMorpher(new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"}));
    }

    public static class JsonObjectIdValueProcessor
    implements JsonValueProcessor {
        public Object processArrayValue(Object arg0, JsonConfig arg1) {
            return this.process(arg0, arg1);
        }

        public Object processObjectValue(String arg0, Object arg1, JsonConfig arg2) {
            return this.process(arg1, arg2);
        }

        private Object process(Object value, JsonConfig jsonConfig) {
            if (value instanceof ObjectId) {
                String str = ((ObjectId)value).toString();
                return str;
            }
            return value == null ? null : value.toString();
        }
    }

    public static class JsonDateValueProcessor
    implements JsonValueProcessor {
        private String format = "yyyy-MM-dd HH:mm:ss";

        public JsonDateValueProcessor() {
        }

        public JsonDateValueProcessor(String format) {
            this.format = format;
        }

        public Object processArrayValue(Object value, JsonConfig jsonConfig) {
            return this.process(value, jsonConfig);
        }

        public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
            return this.process(value, jsonConfig);
        }

        private Object process(Object value, JsonConfig jsonConfig) {
            if (value instanceof Date) {
                String str = new SimpleDateFormat(this.format).format((Date)value);
                return str;
            }
            return value == null ? null : value.toString();
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }
}

