/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsWarehouseAreaMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseAreaExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="whWmsWarehouseAreaService")
public class WhWmsWarehouseAreaServiceImpl
implements WhWmsWarehouseAreaService {
    @Autowired
    private WhWmsWarehouseAreaMapper whWmsWarehouseAreaMapper;

    @Override
    public WhWmsWarehouseArea getAreaByType(String houseType, String code) {
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        WhWmsWarehouseAreaExample.Criteria criteria = example.createCriteria();
        criteria.andHouseTypeEqualTo(houseType);
        criteria.andCodeEqualTo(code);
        List<WhWmsWarehouseArea> list = this.whWmsWarehouseAreaMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<WhWmsWarehouseArea> getAllArea() {
        List<WhWmsWarehouseArea> list = this.whWmsWarehouseAreaMapper.getAll();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list;
    }

    @Override
    public WhWmsWarehouseArea getAreaByCode(String houseCode) {
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        example.createCriteria().andCodeEqualTo(houseCode);
        List<WhWmsWarehouseArea> list = this.whWmsWarehouseAreaMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public WhWmsWarehouseArea getAreaByName(String name) {
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        example.createCriteria().andHouseTypeNameEqualTo(name);
        List<WhWmsWarehouseArea> list = this.whWmsWarehouseAreaMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public WhWmsWarehouseArea getAreaByHouseType(String houseType) {
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        example.createCriteria().andHouseTypeEqualTo(houseType);
        List<WhWmsWarehouseArea> list = this.whWmsWarehouseAreaMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<String> getHouseTypesByType(String type) {
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        WhWmsWarehouseAreaExample.Criteria criteria = example.createCriteria();
        criteria.andTypeEqualTo(type);
        List<WhWmsWarehouseArea> list = this.whWmsWarehouseAreaMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<String> newList = new ArrayList<String>();
        for (WhWmsWarehouseArea whWmsWarehouseArea : list) {
            newList.add(whWmsWarehouseArea.getHouseType());
        }
        return newList;
    }

    @Override
    public List<WhWmsWarehouseArea> getAreaHouseByType(String type) {
        List<WhWmsWarehouseArea> list;
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        if (EmptyUtil.isNotEmpty((String)type)) {
            WhWmsWarehouseAreaExample.Criteria criteria = example.createCriteria();
            criteria.andTypeEqualTo(type);
        }
        if (CollectionUtils.isEmpty(list = this.whWmsWarehouseAreaMapper.selectByExample(example))) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public Map<String, WhWmsWarehouseArea> getAreaHouseMapByType(String type) {
        HashMap<String, WhWmsWarehouseArea> map = new HashMap<String, WhWmsWarehouseArea>();
        List<WhWmsWarehouseArea> list = this.getAreaHouseByType(type);
        if (EmptyUtil.isNotEmpty(list)) {
            for (WhWmsWarehouseArea area : list) {
                map.put(area.getHouseType(), area);
            }
        }
        return map;
    }
}

