/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPhysicalWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsOccupyMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsWaitPutawayTaskMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.PcsSkuVO;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWaitPutawayTask;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWaitPutawayTaskExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayTaskService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPutawayExcuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitPutawayTaskVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

@Service(value="whWmsWaitPutawayTaskService")
public class WhWmsWaitPutawayTaskServiceImpl
implements WhWmsWaitPutawayTaskService {
    private static Logger log = LoggerFactory.getLogger(WhWmsWaitPutawayTaskServiceImpl.class);
    @Autowired
    private WhWmsWaitPutawayTaskMapper mapper;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsOccupyMapper whWmsOccupyMapper;
    @Autowired
    private WhWarehouseMapper whWarehouseMapper;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhPhysicalWarehouseMapper whPhysicalWarehouseMapper;
    @Autowired
    private RedisDistributLock redisDistributLock;

    @Override
    public WhWmsWaitPutawayTaskVO create(WhWmsWaitPutawayTaskVO vo) {
        WhWmsWaitPutawayTask task = (WhWmsWaitPutawayTask)BeanUtil.buildFrom((Object)vo, WhWmsWaitPutawayTask.class);
        this.mapper.insert(task);
        vo.setId(task.getId());
        return vo;
    }

    @Override
    public Boolean update(WhWmsWaitPutawayTaskVO vo) {
        return this.mapper.updateByPrimaryKeySelective((WhWmsWaitPutawayTask)BeanUtil.buildFrom((Object)vo, WhWmsWaitPutawayTask.class)) != 0;
    }

    @Override
    public WhWmsWaitPutawayTaskVO findById(Long id) {
        WhWmsWaitPutawayTask task = this.mapper.selectByPrimaryKey(id);
        if (task != null) {
            return (WhWmsWaitPutawayTaskVO)BeanUtil.buildFrom((Object)task, WhWmsWaitPutawayTaskVO.class);
        }
        return null;
    }

    @Override
    public Pagination<WhWmsWaitPutawayTaskVO> findPutawayTaskList(WhWmsWaitPutawayTaskVO vo) {
        WhCommand whCommand;
        WhWmsWaitPutawayTaskExample example = new WhWmsWaitPutawayTaskExample();
        WhWmsWaitPutawayTaskExample.Criteria criteria = example.createCriteria();
        ArrayList<String> skuList = new ArrayList<String>();
        if (vo.getPopCode() != null && !vo.getPopCode().equals("") && (whCommand = this.whCommandService.findCommandByReferenceCode(vo.getPopCode())) != null && whCommand.getWhCommandSkuList() != null && whCommand.getWhCommandSkuList().size() > 0) {
            for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                skuList.add(whCommandSku.getSkuCode());
            }
            criteria.andSkuCodeIn(skuList);
        }
        if (vo.getPhysicalWarehouseCode() != null && !vo.getPhysicalWarehouseCode().equals("")) {
            criteria.andPhysicalWarehouseCodeEqualTo(vo.getPhysicalWarehouseCode());
        }
        if (vo.getStatus() != null && vo.getStatus() > 0) {
            criteria.andStatusEqualTo(vo.getStatus());
        }
        if (vo.getBatchNo() != null && !vo.getBatchNo().equals("")) {
            criteria.andBatchNoEqualTo(vo.getBatchNo());
        }
        if (vo.getCode() != null && !vo.getCode().equals("")) {
            criteria.andCodeEqualTo(vo.getCode());
        }
        if (vo.getSkuCode() != null && !vo.getSkuCode().equals("")) {
            criteria.andSkuCodeEqualTo(vo.getSkuCode());
        }
        if (vo.getSkuStatus() != null && vo.getSkuStatus() >= 0) {
            criteria.andSkuStatusEqualTo(vo.getSkuStatus());
        }
        if (vo.getHouseType() != null && !vo.getHouseType().equals("")) {
            criteria.andHouseTypeEqualTo(vo.getHouseType());
        }
        if (vo.getInOutType() != null) {
            criteria.andInOutTypeEqualTo(vo.getInOutType());
        }
        if (vo.getBarCode() != null && !vo.getBarCode().equals("")) {
            criteria.andBarCodeEqualTo(vo.getBarCode());
        }
        int count = this.mapper.countByExample(example);
        Pagination pagination = new Pagination();
        pagination.setCurrpage(vo.getCurrpage());
        pagination.setPagenum(vo.getPagenum());
        pagination.setRecord(Integer.valueOf(count));
        List<WhWmsWaitPutawayTaskVO> list = this.mapper.findWhWmsWaitPutawayTaskVOList(vo);
        pagination.setResultList(list);
        return pagination;
    }

    @Override
    public List<WhWmsWaitPutawayTaskVO> findWhWmsWaitPutawayTaskVOList(WhWmsWaitPutawayTaskVO vo) {
        return this.mapper.findWhWmsWaitPutawayTaskVOList(vo);
    }

    @Override
    public List<WhCountVO> countPutawayTask(String physicalWarehouseCode) {
        return this.mapper.countPutawayTask(physicalWarehouseCode);
    }

    @Override
    public boolean targetShelvesCodeCheck(String shelvesCode, String barCode, boolean focus) {
        String errorMsg;
        Set<String> tmpBarCodes;
        WhWmsHouseShelvesVO shelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(shelvesCode);
        if (NullUtil.isNull((Object)shelvesVO)) {
            throw new WarehouseException("WH0001", String.format("[%s]\u5e93\u4f4d\u4e0d\u5b58\u5728\uff01", shelvesCode));
        }
        if (WhWmsHouseShelvesVO.SHELVES_TYPE_NORMAL.equals(shelvesVO.getShelvesType())) {
            throw new WarehouseException("WH0001", String.format("[%s]\u5e93\u4f4d\u7c7b\u578b\u4e3a\u5e38\u89c4\uff01", shelvesCode));
        }
        if (focus) {
            return true;
        }
        WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
        stockCond.setShelvesCode(shelvesVO.getCode());
        stockCond.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
        stockCond.setHouseType(shelvesVO.getHouseType());
        List<WhWmsSkuStock> stockList = this.whWmsSkuStockService.getStockByCond(stockCond);
        Map<String, Set<String>> skuBarCodeMap = this.getShelveSkuBarCodeMap(stockList);
        String skuCode = barCode.split("_")[0];
        Set<String> barCodes = skuBarCodeMap.get(skuCode);
        StringBuilder buffer = new StringBuilder();
        if (EmptyUtil.isNotEmpty(barCodes) && (!barCodes.contains(barCode) || barCodes.size() > 1)) {
            buffer.append("2").append(";");
        }
        if (WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(shelvesVO.getShelvesType()) && EmptyUtil.isNotEmpty((String)shelvesVO.getSkuCode()) && !shelvesVO.getSkuCode().equals(skuCode)) {
            buffer.append("3").append(";");
        }
        if (WhWmsHouseShelvesVO.MIXED_TYPE_SINGLE.equals(shelvesVO.getMixedType())) {
            if (EmptyUtil.isNotEmpty(skuBarCodeMap)) {
                if (skuBarCodeMap.size() > 1 || !skuBarCodeMap.containsKey(skuCode)) {
                    buffer.append("4").append(";");
                } else {
                    tmpBarCodes = skuBarCodeMap.get(skuCode);
                    if (EmptyUtil.isNotEmpty(tmpBarCodes) && (!tmpBarCodes.contains(barCode) || tmpBarCodes.size() > 1)) {
                        buffer.append("4").append(";");
                    }
                }
            }
        } else if (WhWmsHouseShelvesVO.MIXED_TYPE_SINGLE.equals(shelvesVO.getMixedType()) && EmptyUtil.isNotEmpty(tmpBarCodes = skuBarCodeMap.get(skuCode)) && !tmpBarCodes.contains(barCode)) {
            buffer.append("4").append(";");
        }
        if (EmptyUtil.isNotEmpty((String)(errorMsg = buffer.toString()))) {
            throw new WarehouseException("WH0220", errorMsg);
        }
        return true;
    }

    private Map<String, Set<String>> getShelveSkuBarCodeMap(List<WhWmsSkuStock> stockList) {
        HashMap<String, Set<String>> skuBarCodeMap = new HashMap<String, Set<String>>();
        if (EmptyUtil.isNotEmpty(stockList)) {
            for (WhWmsSkuStock stock : stockList) {
                if (NullUtil.isNull((Object)stock.getAmount()) || stock.getAmount() <= 0) continue;
                HashSet<String> barCodes = (HashSet<String>)skuBarCodeMap.get(stock.getSkuCode());
                if (NullUtil.isNull((Object)barCodes)) {
                    barCodes = new HashSet<String>();
                    skuBarCodeMap.put(stock.getSkuCode(), barCodes);
                }
                barCodes.add(stock.getBarCode());
            }
        }
        return skuBarCodeMap;
    }

    public List<WhWmsWaitPutawayTask> listWhWmsWaitPutawayTaskByIds(List<Long> taskIds) {
        WhWmsWaitPutawayTaskExample taskExample = new WhWmsWaitPutawayTaskExample();
        WhWmsWaitPutawayTaskExample.Criteria criteria = taskExample.createCriteria();
        criteria.andIdIn((List)taskIds);
        return this.mapper.selectByExample(taskExample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putawayTaskExcu(WhWmsPutawayExcuVO vo, Long operationId) throws Exception {
        ArrayList<String> lockKeyList = new ArrayList<String>();
        try {
            if (EmptyUtil.isNotEmpty(vo.getTaskId())) {
                for (Long taskId : vo.getTaskId()) {
                    lockKeyList.add("lock:wms:putawayTask:" + taskId);
                }
                Boolean getLock = this.redisDistributLock.tryLock(lockKeyList, 3L, TimeUnit.MINUTES);
                if (!getLock.booleanValue()) {
                    log.info("\u83b7\u53d6\u9501\u5931\u8d25 putawayTaskExcu");
                    throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
                }
            }
            if (EmptyUtil.isNotEmpty((Object)vo) && CollectionUtils.isNotEmpty(vo.getTaskId())) {
                ArrayList<Long> taskIds = new ArrayList<Long>();
                for (int i = 0; i < vo.getTaskId().size(); ++i) {
                    taskIds.add(vo.getTaskId().get(i));
                }
                List<WhWmsWaitPutawayTask> waitPutawayTasks = this.listWhWmsWaitPutawayTaskByIds(taskIds);
                HashMap<Long, WhWmsWaitPutawayTask> waitPutawayTaskMap = new HashMap<Long, WhWmsWaitPutawayTask>();
                HashSet<String> skuCodeSet = new HashSet<String>();
                for (WhWmsWaitPutawayTask waitPutawayTask : waitPutawayTasks) {
                    waitPutawayTaskMap.put(waitPutawayTask.getId(), waitPutawayTask);
                    skuCodeSet.add(waitPutawayTask.getSkuCode());
                }
                List<PcsSkuVO> pcsSkuVOs = this.mapper.listPcsSkuInfoBySkuCodes(Arrays.asList(skuCodeSet.toArray(new String[skuCodeSet.size()])));
                HashMap<String, Integer> shelfLifeMap = new HashMap<String, Integer>();
                if (CollectionUtils.isNotEmpty(pcsSkuVOs)) {
                    for (PcsSkuVO pcsSkuVO : pcsSkuVOs) {
                        shelfLifeMap.put(pcsSkuVO.getCode(), pcsSkuVO.getShelfLife());
                    }
                }
                this.checkSampleShelvesByShelfLife(vo, taskIds, waitPutawayTaskMap, shelfLifeMap);
                for (int i = 0; i < vo.getTaskId().size(); ++i) {
                    int shortRealAmount;
                    WhWmsWaitPutawayTask lastTask;
                    Long taskId = vo.getTaskId().get(i);
                    Integer putawayAmount = vo.getPutawayAmount().get(i);
                    Integer shortAmount = vo.getShortAmount().get(i);
                    String shelvesCode = vo.getShelvesCode().get(i);
                    WhWmsWaitPutawayTask task = (WhWmsWaitPutawayTask)waitPutawayTaskMap.get(taskId);
                    if (shelvesCode == null || shelvesCode.equals("")) {
                        throw new RuntimeException("\u8bf7\u9009\u62e9\u5e93\u4f4d");
                    }
                    WhWmsHouseShelvesCond tarcond = new WhWmsHouseShelvesCond();
                    tarcond.setCode(shelvesCode);
                    List<WhWmsHouseShelvesVO> tarShelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(tarcond);
                    WhWmsHouseShelvesVO tarVo = null;
                    if (tarShelvesList != null && tarShelvesList.size() > 0) {
                        tarVo = tarShelvesList.get(0);
                        if (WhCommand.TYPE_PURCHASE_IN.equals(task.getInOutType()) && WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING.equals(task.getSkuStatus()) && !"HOUSE_TYPE_HOLD_PENDING".equals(tarVo.getHouseType())) {
                            throw new RuntimeException(shelvesCode + ",\u91c7\u8d2d\u5165\u5e93[\u5f85\u5b9a\u72b6\u6001\u5546\u54c1]\uff0c\u4e0a\u67b6\u5e93\u4f4d\u53ea\u80fd\u662f\u5f85\u5b9a\u533a\u7684\u5e93\u4f4d");
                        }
                    } else {
                        throw new RuntimeException(shelvesCode + "\u8bbe\u7f6e\u7684\u76ee\u6807\u5e93\u4f4d\u4e0d\u5b58\u5728");
                    }
                    if (!task.getShelvesCode().equals(shelvesCode)) {
                        if (!task.getAmount().equals(putawayAmount + shortAmount)) {
                            task.setAmount(task.getAmount() - putawayAmount - shortAmount);
                            WhWmsWaitPutawayTask newTask = new WhWmsWaitPutawayTask();
                            newTask.setAmount(putawayAmount + shortAmount);
                            newTask.setPutawayUserId(Integer.parseInt(operationId.toString()));
                            newTask.setPutawayTime(Calendar.getInstance().getTime());
                            newTask.setStatus(2);
                            newTask.setBarCode(task.getBarCode());
                            newTask.setBatchNo(task.getBatchNo());
                            newTask.setHouseType(tarVo.getHouseType());
                            newTask.setPhysicalWarehouseCode(tarVo.getPhysicalWarehouseCode());
                            newTask.setSkuStatus(task.getSkuStatus());
                            newTask.setSkuCode(task.getSkuCode());
                            newTask.setPutawayAmount(putawayAmount);
                            newTask.setShelvesCode(tarVo.getCode());
                            newTask.setShortAmount(shortAmount);
                            Integer id = this.mapper.insert(newTask);
                            WhWmsWaitPutawayTask whWmsWaitPutawayTask = this.mapper.selectByPrimaryKey(Long.parseLong(id.toString()));
                            whWmsWaitPutawayTask.setCode("SJ" + id);
                            this.mapper.updateByPrimaryKey(whWmsWaitPutawayTask);
                            if (task.getAmount().equals(task.getShortAmount() + task.getPutawayAmount())) {
                                task.setStatus(2);
                            }
                            this.mapper.updateByPrimaryKey(task);
                        } else {
                            task.setShelvesCode(shelvesCode);
                            task.setHouseType(tarVo.getHouseType());
                            task.setPutawayAmount(putawayAmount);
                            task.setShortAmount(shortAmount);
                            task.setStatus(2);
                            task.setPutawayTime(Calendar.getInstance().getTime());
                            task.setPutawayUserId(Integer.parseInt(operationId.toString()));
                            this.mapper.updateByPrimaryKey(task);
                        }
                    } else {
                        task.setPutawayAmount((task.getPutawayAmount() == null ? 0 : task.getPutawayAmount()) + putawayAmount);
                        task.setShortAmount((task.getShortAmount() == null ? 0 : task.getShortAmount()) + shortAmount);
                        if (task.getAmount().equals(task.getShortAmount() + task.getPutawayAmount())) {
                            task.setStatus(2);
                        }
                        task.setPutawayTime(Calendar.getInstance().getTime());
                        task.setPutawayUserId(Integer.parseInt(operationId.toString()));
                        this.mapper.updateByPrimaryKey(task);
                    }
                    WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
                    cond.setHouseType("HOUSE_TYPE_RECEIVE");
                    cond.setPhysicalWarehouseCode(task.getPhysicalWarehouseCode());
                    List<WhWmsHouseShelvesVO> shelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
                    WhWmsHouseShelvesVO shelves = null;
                    if (shelvesList == null || shelvesList.size() <= 0) {
                        throw new RuntimeException("\u8bf7\u5148\u8bbe\u7f6e\u6536\u8d27\u6682\u5b58\u533a\u5e93\u4f4d");
                    }
                    shelves = shelvesList.get(0);
                    this.whWmsSkuStockService.updateStockByCond(-(putawayAmount + shortAmount), shelves.getPhysicalWarehouseCode(), shelves.getHouseType(), task.getBarCode(), shelves.getCode(), task.getSkuCode(), task.getSkuStatus(), WhCommand.TYPE_MOVE_OUT, task.getCode(), operationId, null, 2);
                    if (putawayAmount > 0) {
                        this.whWmsSkuStockService.updateStockByCond(putawayAmount, tarVo.getPhysicalWarehouseCode(), tarVo.getHouseType(), task.getBarCode(), tarVo.getCode(), task.getSkuCode(), task.getSkuStatus(), WhCommand.TYPE_MOVE_IN, task.getCode(), operationId, null, 2);
                    }
                    if (shortAmount > 0) {
                        WhWmsHouseShelvesCond diffCond = new WhWmsHouseShelvesCond();
                        diffCond.setHouseType("HOUSE_TYPE_DIFF");
                        diffCond.setPhysicalWarehouseCode(task.getPhysicalWarehouseCode());
                        List<WhWmsHouseShelvesVO> diffShelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(diffCond);
                        WhWmsHouseShelvesVO diffShelves = null;
                        if (diffShelvesList == null || diffShelvesList.size() <= 0) {
                            throw new RuntimeException("\u8bf7\u5148\u8bbe\u7f6e\u5dee\u5f02\u533a\u5e93\u4f4d");
                        }
                        diffShelves = diffShelvesList.get(0);
                        this.whWmsSkuStockService.updateStockByCond(shortAmount, diffShelves.getPhysicalWarehouseCode(), diffShelves.getHouseType(), task.getBarCode(), diffShelves.getCode(), task.getSkuCode(), task.getSkuStatus(), WhCommand.TYPE_MOVE_IN, task.getCode(), operationId);
                    }
                    int targetAmount = (lastTask = this.mapper.selectByPrimaryKey(taskId)).getAmount() == null ? 0 : lastTask.getAmount();
                    int realAmount = lastTask.getPutawayAmount() == null ? 0 : lastTask.getPutawayAmount();
                    int n = shortRealAmount = lastTask.getShortAmount() == null ? 0 : lastTask.getShortAmount();
                    if (realAmount + shortRealAmount <= targetAmount) continue;
                    throw new RuntimeException("\u4e0a\u67b6\u6570\u91cf\u5927\u4e8e\u5f85\u4e0a\u67b6\u6570\u91cf\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u5f55\u5165");
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (EmptyUtil.isNotEmpty(lockKeyList)) {
                this.redisDistributLock.unLock(lockKeyList);
            }
        }
    }

    private void checkSampleShelvesByShelfLife(WhWmsPutawayExcuVO vo, List<Long> taskIds, Map<Long, WhWmsWaitPutawayTask> waitPutawayTaskMap, Map<String, Integer> shelfLifeMap) {
        HashMap<String, HashSet<String>> barCodeShelvesCodeMap = new HashMap<String, HashSet<String>>();
        String shelvesCode = "";
        StringBuilder sbMsg = new StringBuilder();
        for (int i = 0; i < vo.getTaskId().size(); ++i) {
            taskIds.add(vo.getTaskId().get(i));
            shelvesCode = vo.getShelvesCode().get(i);
            WhWmsWaitPutawayTask taskTmp = waitPutawayTaskMap.get(vo.getTaskId().get(i));
            Integer shelfLife = shelfLifeMap.get(taskTmp.getSkuCode());
            String key = "[" + taskTmp.getSkuCode() + "][" + shelvesCode + "]";
            if (shelfLife == null || shelfLife <= 0) continue;
            HashSet<String> barCodes = (HashSet<String>)barCodeShelvesCodeMap.get(key);
            if (CollectionUtils.isEmpty((Collection)barCodes)) {
                barCodes = new HashSet<String>();
                barCodeShelvesCodeMap.put(key, barCodes);
            }
            barCodes.add(taskTmp.getBarCode());
        }
        barCodeShelvesCodeMap.entrySet().forEach(entry -> {
            if (((Set)entry.getValue()).size() > 1) {
                for (String barCode : (Set)entry.getValue()) {
                    sbMsg.append("\u6548\u671f\u5546\u54c1\uff0c\u4e0d\u540c\u6279\u6b21\u7684\u5546\u54c1\u4e0d\u80fd\u653e\u5728\u540c\u4e00\u5e93\u4f4d!" + (String)entry.getKey() + ",\u6279\u6b21[" + barCode + "]</br>");
                }
            }
        });
        if (sbMsg.length() > 0) {
            throw new WarehouseException("WH0001", sbMsg.toString());
        }
    }
}

