/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuPickShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuBarcodeMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsWaitPutawayMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsWarehouseAreaMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSkuExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsShelvesSkuInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcodeExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuPickShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStockExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWaitPutaway;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWaitPutawayExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWaitPutawayTask;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseAreaExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsShelvesSkuInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayTaskService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhQualityControlVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReceiveShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOccupyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPutawaySearchVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsStartPutawayVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitPutawayTaskVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitPutawayVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

@Service(value="whWmsWaitPutawayService")
public class WhWmsWaitPutawayServiceImpl
implements WhWmsWaitPutawayService {
    private final Logger log = LoggerFactory.getLogger(WhWmsWaitPutawayServiceImpl.class);
    @Autowired
    private WhWmsWaitPutawayMapper mapper;
    @Autowired
    private WhWmsOccupyService whWmsOccupyService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsShelvesSkuInfoService whWmsShelvesSkuInfoService;
    @Autowired
    private WhWmsWaitPutawayTaskService whWmsWaitPutawayTaskService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsWarehouseAreaMapper whWmsWarehouseAreaMapper;
    @Autowired
    private WhCommandMapper whCommandMapper;
    @Autowired
    private WhCommandSkuMapper whCommandSkuMapper;
    @Autowired
    private WhWmsSkuBarcodeMapper whWmsSkuBarcodeMapper;
    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;

    @Override
    public WhWmsWaitPutawayVO create(WhWmsWaitPutawayVO waitPutawayVO) {
        WhWmsWaitPutaway waitPutaway = (WhWmsWaitPutaway)BeanUtil.buildFrom((Object)waitPutawayVO, WhWmsWaitPutaway.class);
        this.mapper.insert(waitPutaway);
        waitPutawayVO.setId(waitPutaway.getId());
        return waitPutawayVO;
    }

    @Override
    public Boolean update(WhWmsWaitPutawayVO waitPutawayVO) {
        return this.mapper.updateByPrimaryKeySelective((WhWmsWaitPutaway)BeanUtil.buildFrom((Object)waitPutawayVO, WhWmsWaitPutaway.class)) != 0;
    }

    @Override
    public WhWmsWaitPutawayVO findById(Long id) {
        WhWmsWaitPutaway waitPutaway = this.mapper.selectByPrimaryKey(id);
        if (waitPutaway != null) {
            return (WhWmsWaitPutawayVO)BeanUtil.buildFrom((Object)waitPutaway, WhWmsWaitPutawayVO.class);
        }
        return null;
    }

    @Override
    public List<WhWmsWaitPutawayVO> findWmsWaitPutawayByReceiptsNo(String receiptsNo) {
        return this.mapper.findWmsWaitPutawayByReceiptsNo(receiptsNo);
    }

    @Override
    public Pagination<WhWmsWaitPutawayVO> findPutawayList(WhWmsWaitPutawayVO vo) {
        Pagination pagination = new Pagination(vo.getCurrpage(), vo.getPagenum());
        pagination.setRecord(Integer.valueOf(this.mapper.findWaitPutawayCountByCond(vo)));
        pagination.setResultList(this.mapper.findWaitPutawayListByCond(vo));
        return pagination;
    }

    @Override
    public Pagination<WhWmsWaitPutawayVO> getPutawayListBySkuCode(WhWmsWaitPutawayVO vo) {
        Pagination pagination = new Pagination(vo.getCurrpage(), vo.getPagenum());
        pagination.setRecord(Integer.valueOf(this.mapper.findSKUWaitPutawayCountByCond(vo)));
        pagination.setResultList(this.mapper.findSKUWaitPutawayListByCond(vo));
        return pagination;
    }

    @Override
    public List<WhWmsWaitPutawayVO> listPutawayListBySkuCode(WhWmsWaitPutawayVO waitPutawayVO) {
        return this.mapper.findSKUWaitPutawayListByCond(waitPutawayVO);
    }

    @Override
    public Pagination<WhWmsWaitPutawayVO> findPutawayTaskList(WhWmsWaitPutawayVO vo) {
        Pagination pagination = new Pagination(vo.getCurrpage(), vo.getPagenum());
        pagination.setRecord(Integer.valueOf(this.mapper.findPutawayTaskCountByCond(vo)));
        pagination.setResultList(this.mapper.findPutawayTaskListByCond(vo));
        return pagination;
    }

    @Override
    public boolean isReceiveOver(String cmdCode) {
        List<String> list = this.mapper.isReceiveOver(cmdCode);
        return list == null || list.size() <= 0;
    }

    @Override
    public List<WhWmsWaitPutawayVO> findPrintPutawayOrder(WhWmsPutawaySearchVO vo) {
        return this.mapper.findPrintPutawayOrderList(vo);
    }

    @Override
    public String startPutaway(WhWmsWaitPutawayVO waitPutawayVO) {
        Object key;
        List<WhWmsStartPutawayVO> pvoList = waitPutawayVO.getStartPutList();
        String batchNo = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss") + StringUtil.getRandomString((int)3, (String)"0123456789");
        HashMap<Object, Integer> amountMap = new HashMap<Object, Integer>();
        HashMap<Object, WhWmsStartPutawayVO> taskVoMap = new HashMap<Object, WhWmsStartPutawayVO>();
        String warnMessage = null;
        ArrayList<WhWmsStartPutawayVO> newList = new ArrayList<WhWmsStartPutawayVO>();
        for (WhWmsStartPutawayVO vo : pvoList) {
            WhWmsWaitPutaway whWmsWaitPutaway = this.mapper.selectByPrimaryKey(vo.getId());
            if (whWmsWaitPutaway.getBatchNo() != null) continue;
            vo.setInOutType(whWmsWaitPutaway.getInOutType());
            newList.add(vo);
        }
        pvoList = newList;
        this.prepareStartPutawayVO(pvoList);
        for (WhWmsStartPutawayVO pvo : pvoList) {
            pvo.setPhysicalWarehouseCode(waitPutawayVO.getPhysicalWarehouseCode());
            key = pvo.getBarCode() + pvo.getSkuStatus() + pvo.getInOutType();
            if (amountMap.containsKey(key)) {
                Integer countVal = this.parseInteger((Integer)amountMap.get(key) + pvo.getReceiveAmount());
                amountMap.put(key, countVal);
                continue;
            }
            amountMap.put(key, pvo.getReceiveAmount());
        }
        for (WhWmsStartPutawayVO pvo : pvoList) {
            key = pvo.getBarCode() + pvo.getSkuStatus() + pvo.getInOutType();
            if (!amountMap.containsKey(key)) continue;
            pvo.setReceiveAmount((Integer)amountMap.get(key));
            taskVoMap.put(key, pvo);
        }
        Set entrySet = taskVoMap.entrySet();
        HashMap<WhWmsStartPutawayVO, List<WhWmsHouseShelves>> map = new HashMap<WhWmsStartPutawayVO, List<WhWmsHouseShelves>>();
        for (Map.Entry entry : entrySet) {
            WhWmsHouseShelves whWmsHouseShelves;
            WhWmsStartPutawayVO pvo = (WhWmsStartPutawayVO)entry.getValue();
            List<WhWmsHouseShelves> shelvesList = this.recommendWmsHouseShelves(pvo, map);
            if (shelvesList != null && shelvesList.size() > 0 && (whWmsHouseShelves = shelvesList.get(shelvesList.size() - 1)).getWarnMessage() != null && !whWmsHouseShelves.getWarnMessage().equals("")) {
                warnMessage = whWmsHouseShelves.getWarnMessage();
                shelvesList.remove(shelvesList.size() - 1);
            }
            map.put(pvo, shelvesList);
            this.savePutawayTask(pvo, shelvesList, batchNo);
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        for (WhWmsStartPutawayVO pvo : pvoList) {
            idList.add(pvo.getId());
        }
        this.putawayInfoStatusInPutaway(idList, batchNo);
        if (warnMessage != null && !warnMessage.equals("")) {
            batchNo = batchNo + "," + warnMessage;
        }
        return batchNo;
    }

    private void putawayInfoStatusInPutaway(List<Long> ids, String batchNo) {
        if (EmptyUtil.isEmpty(ids)) {
            throw new WarehouseException("WH0001", "\u4e0a\u67b6\u53c2\u6570\u5f02\u5e38");
        }
        int size = ids.size();
        int count = this.mapper.putawayInfoUpdate(batchNo, WhWmsWaitPutaway.STATUS_IN_PUTAWAY, WhWmsWaitPutaway.STATUS_WAIT_PUTAWAY, ids);
        if (count != size) {
            throw new WarehouseException("WH0001", "\u4e0a\u67b6\u72b6\u6001\u5f02\u5e38");
        }
    }

    private List<WhWmsHouseShelves> recommendCustomizationSkuHouseShelves(WhWmsStartPutawayVO pvo, Map<WhWmsStartPutawayVO, List<WhWmsHouseShelves>> map) {
        ArrayList<WhWmsHouseShelves> retList = new ArrayList<WhWmsHouseShelves>();
        if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(pvo.getSkuStatus())) {
            WhWmsHouseShelvesCond shelvesCond = new WhWmsHouseShelvesCond();
            shelvesCond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            shelvesCond.setHouseType("HOUSE_TYPE_CUSTOMIZATION");
            List<WhWmsHouseShelves> hsList = this.whWmsHouseShelvesService.getHouseShelvesByCondNoPage(shelvesCond);
            if (EmptyUtil.isEmpty(hsList)) {
                throw new WarehouseException("WH0001", "\u65e0\u5b9a\u5236\u5e93\u4f4d");
            }
            WhWmsHouseShelves shelves = hsList.get(0);
            this.distributShelves(999999999, shelves.getPhysicalWarehouseCode(), shelves.getHouseType(), shelves.getCode(), pvo.getReceiveAmount(), retList, map);
        }
        return retList;
    }

    private List<WhWmsHouseShelves> recommendWmsHouseShelves(WhWmsStartPutawayVO pvo, Map<WhWmsStartPutawayVO, List<WhWmsHouseShelves>> map) {
        WhWmsHouseShelvesCond shelvesCond;
        StringBuffer warnMessage = new StringBuffer();
        Integer putAmount = pvo.getReceiveAmount();
        ArrayList<WhWmsHouseShelves> retList = new ArrayList<WhWmsHouseShelves>();
        WhWmsShelvesSkuInfo whWmsShelvesSkuInfo = this.whWmsShelvesSkuInfoService.getSkuInfoByCode(pvo.getSkuCode());
        List<WhWmsSkuPickShelves> skuPickShelves = null;
        if (EmptyUtil.isNotEmpty((Object)whWmsShelvesSkuInfo)) {
            WhWmsSkuPickShelvesCond skuPickCond = new WhWmsSkuPickShelvesCond();
            skuPickCond.setSkuCode(whWmsShelvesSkuInfo.getSkuCode());
            skuPickCond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            skuPickShelves = this.whWmsShelvesSkuInfoService.listSkuPickShelvesByCond(skuPickCond);
        }
        Map<String, WhWmsWarehouseArea> areaMap = this.whWmsWarehouseAreaService.getAreaHouseMapByType("NORMAL");
        Integer skuMaxAmount = null;
        if (CollectionUtils.isNotEmpty(skuPickShelves)) {
            skuMaxAmount = ((WhWmsSkuPickShelves)skuPickShelves.get(0)).getMaxAmount();
        }
        if (EmptyUtil.isEmpty(skuMaxAmount)) {
            skuMaxAmount = 99999999;
        }
        if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(pvo.getSkuStatus())) {
            if (pvo.isCustomization()) {
                return this.recommendCustomizationSkuHouseShelves(pvo, map);
            }
            List<WhWmsHouseShelves> hsList = this.checkIsRelatedToSku(pvo.getPhysicalWarehouseCode(), pvo.getSkuCode(), "NORMAL", warnMessage, pvo.getStorageType());
            this.houseShelvesSort(hsList, areaMap, pvo.getSkuCode(), pvo.getSkuStatus());
            if (hsList != null) {
                for (WhWmsHouseShelves hs : hsList) {
                    putAmount = this.distributShelves(skuMaxAmount, hs.getPhysicalWarehouseCode(), hs.getHouseType(), hs.getCode(), putAmount, retList, map);
                    if (putAmount > 0) continue;
                    break;
                }
            }
            if (putAmount > 0) {
                WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
                example.createCriteria().andTypeEqualTo("NORMAL");
                List<WhWmsWarehouseArea> whWmsWarehouseAreaList = this.whWmsWarehouseAreaMapper.selectByExample(example);
                ArrayList<String> houseTypeList = new ArrayList<String>();
                for (WhWmsWarehouseArea whWmsWarehouseArea : whWmsWarehouseAreaList) {
                    houseTypeList.add(whWmsWarehouseArea.getHouseType());
                }
                List<WhWmsSkuStock> smHs = this.findSameBatch(pvo, houseTypeList);
                if (smHs != null && smHs.size() > 0) {
                    WhWmsSkuStock putawayVO;
                    WhWmsHouseShelvesVO whWmsHouseShelvesVO;
                    Iterator<WhWmsSkuStock> iterator = smHs.iterator();
                    while (!(!iterator.hasNext() || (whWmsHouseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode((putawayVO = iterator.next()).getShelvesCode())).getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING) && whWmsHouseShelvesVO.getStorageType().equals(pvo.getStorageType()) && whWmsHouseShelvesVO.getSkuStatus().equals(pvo.getSkuStatus()) && (putAmount = Integer.valueOf(this.distributShelves(skuMaxAmount, putawayVO.getPhysicalWarehouseCode(), putawayVO.getHouseType(), putawayVO.getShelvesCode(), putAmount, retList, map))) <= 0)) {
                    }
                }
            }
            if (putAmount > 0) {
                this.distributeByRule(pvo, skuMaxAmount, putAmount, retList, "NORMAL", WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING, pvo.getStorageType(), pvo.getSkuStatus(), map);
            }
        } else if (WhWarehouseVO.isDamagedCommodity(pvo.getSkuStatus()) || WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE.equals(pvo.getSkuStatus()) || WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED.equals(pvo.getSkuStatus())) {
            this.distributeByRule(pvo, skuMaxAmount, putAmount, retList, "NORMAL", WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING, pvo.getStorageType(), pvo.getSkuStatus(), map);
        } else if (WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY.equals(pvo.getSkuStatus()) || WhWarehouseVO.COMMODITY_STATUS_FOR_PROP.equals(pvo.getSkuStatus())) {
            shelvesCond = new WhWmsHouseShelvesCond();
            shelvesCond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            shelvesCond.setHouseType("HOUSE_TYPE_EXHIBITS");
            List<WhWmsHouseShelves> hsList = this.whWmsHouseShelvesService.getHouseShelvesByCondNoPage(shelvesCond);
            if (EmptyUtil.isEmpty(hsList)) {
                throw new WarehouseException("WH0001", "\u65e0\u9648\u5217\u5e93\u4f4d");
            }
            WhWmsHouseShelves shelves = hsList.get(0);
            this.distributShelves(Integer.MAX_VALUE, shelves.getPhysicalWarehouseCode(), shelves.getHouseType(), shelves.getCode(), pvo.getReceiveAmount(), retList, map);
        } else if (WhWmsCommandInfoVO.TYPE_PURCHASE_IN.equals(pvo.getInOutType()) && WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING.equals(pvo.getSkuStatus())) {
            shelvesCond = new WhWmsHouseShelvesCond();
            shelvesCond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            shelvesCond.setHouseType("HOUSE_TYPE_HOLD_PENDING");
            List<WhWmsHouseShelves> hsList = this.whWmsHouseShelvesService.getHouseShelvesByCondNoPage(shelvesCond);
            if (EmptyUtil.isEmpty(hsList)) {
                throw new WarehouseException("WH0001", "\u65e0\u5f85\u5b9a\u5546\u54c1\u533a\u5e93\u4f4d");
            }
            WhWmsHouseShelves shelves = hsList.get(0);
            this.distributShelves(Integer.MAX_VALUE, shelves.getPhysicalWarehouseCode(), shelves.getHouseType(), shelves.getCode(), pvo.getReceiveAmount(), retList, map);
        }
        if (warnMessage.length() > 0) {
            WhWmsHouseShelves myShelves = new WhWmsHouseShelves();
            myShelves.setWarnMessage(warnMessage.toString());
            retList.add(myShelves);
        }
        return retList;
    }

    private void houseShelvesSort(List<WhWmsHouseShelves> hsList, final Map<String, WhWmsWarehouseArea> areaMap, String skuCode, Integer skuStatus) {
        if (EmptyUtil.isNotEmpty(hsList)) {
            WhWmsHouseShelves oneShelves = hsList.get(0);
            ArrayList<String> shelvesCodes = new ArrayList<String>();
            for (WhWmsHouseShelves houseShelves : hsList) {
                shelvesCodes.add(houseShelves.getCode());
            }
            final Map<String, Integer> shelvesStockMap = this.shelvesStockGroupBySku(oneShelves.getPhysicalWarehouseCode(), skuCode, skuStatus, shelvesCodes);
            Collections.sort(hsList, new Comparator<WhWmsHouseShelves>(){

                @Override
                public int compare(WhWmsHouseShelves o1, WhWmsHouseShelves o2) {
                    int result;
                    WhWmsWarehouseArea a1 = (WhWmsWarehouseArea)areaMap.get(o1.getHouseType());
                    WhWmsWarehouseArea a2 = (WhWmsWarehouseArea)areaMap.get(o2.getHouseType());
                    Integer sortOrder1 = a1.getSortOrder();
                    Integer sortOrder2 = a2.getSortOrder();
                    if (NullUtil.isNull((Object)sortOrder1)) {
                        sortOrder1 = Integer.MAX_VALUE;
                    }
                    if (NullUtil.isNull((Object)sortOrder2)) {
                        sortOrder2 = Integer.MAX_VALUE;
                    }
                    if ((result = sortOrder1.compareTo(sortOrder2)) == 0) {
                        Integer stock1 = (Integer)shelvesStockMap.get(o1.getCode());
                        Integer stock2 = (Integer)shelvesStockMap.get(o2.getCode());
                        if (NullUtil.isNull((Object)stock1)) {
                            stock1 = 0;
                        }
                        if (NullUtil.isNull((Object)stock2)) {
                            stock2 = 0;
                        }
                        result = -stock1.compareTo(stock2);
                    }
                    return result;
                }
            });
        }
    }

    private Map<String, Integer> shelvesStockGroupBySku(String physicalWarehouseCode, String skuCode, Integer skuStatus, List<String> shelvesCodes) {
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        cond.setSkuCode(skuCode);
        cond.setShelvesCodeList(shelvesCodes);
        List<WhWmsSkuStockVO> stockList = this.whWmsSkuStockService.getWmsSkuStocksByShelvesCond(cond);
        HashMap<String, Integer> shelvesStockMap = new HashMap<String, Integer>();
        if (EmptyUtil.isNotEmpty(stockList)) {
            for (WhWmsSkuStockVO skuStock : stockList) {
                Integer total = (Integer)shelvesStockMap.get(skuStock.getShelvesCode());
                if (NullUtil.isNull((Object)total)) {
                    total = 0;
                }
                shelvesStockMap.put(skuStock.getShelvesCode(), total + skuStock.getTotalAmount());
            }
        }
        return shelvesStockMap;
    }

    @Override
    public List<WhWmsMoveSkuVO> recommendWmsHouseShelves(List<WhWmsStartPutawayVO> pvoList) {
        List shelvesList;
        String key;
        HashMap<String, Object> amountMap = new HashMap<String, Object>();
        HashMap<String, WhWmsStartPutawayVO> taskVoMap = new HashMap<String, WhWmsStartPutawayVO>();
        ArrayList<String> skuCodes = new ArrayList<String>();
        for (WhWmsStartPutawayVO pvo : pvoList) {
            key = pvo.getBarCode() + pvo.getSkuStatus() + pvo.getSourceShelvesVO().getCode();
            skuCodes.add(pvo.getSkuCode());
            if (amountMap.containsKey(key)) {
                Integer tmp = (Integer)amountMap.get(key) + pvo.getReceiveAmount();
                Object countVal = 0;
                if (tmp != null) {
                    countVal = tmp;
                }
                amountMap.put(key, countVal);
                continue;
            }
            amountMap.put(key, pvo.getReceiveAmount());
        }
        this.prepareStartPutawayVO(pvoList);
        for (WhWmsStartPutawayVO pvo : pvoList) {
            key = pvo.getBarCode() + pvo.getSkuStatus() + pvo.getSourceShelvesVO().getCode();
            if (!amountMap.containsKey(key)) continue;
            pvo.setReceiveAmount((Integer)amountMap.get(key));
            taskVoMap.put(key, pvo);
        }
        String warnMessage = null;
        Set entrySet = taskVoMap.entrySet();
        HashMap<WhWmsStartPutawayVO, List<WhWmsHouseShelves>> map = new HashMap<WhWmsStartPutawayVO, List<WhWmsHouseShelves>>();
        for (Map.Entry entry : entrySet) {
            WhWmsHouseShelves whWmsHouseShelves;
            WhWmsStartPutawayVO pvo = (WhWmsStartPutawayVO)entry.getValue();
            shelvesList = this.recommendWmsHouseShelves(pvo, map);
            if (shelvesList != null && shelvesList.size() > 0 && (whWmsHouseShelves = (WhWmsHouseShelves)shelvesList.get(shelvesList.size() - 1)).getWarnMessage() != null && !whWmsHouseShelves.getWarnMessage().equals("")) {
                warnMessage = whWmsHouseShelves.getWarnMessage();
                shelvesList.remove(shelvesList.size() - 1);
            }
            map.put(pvo, shelvesList);
        }
        ArrayList<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<WhWmsMoveSkuVO>();
        if (EmptyUtil.isEmpty(map)) {
            return moveStockSkuList;
        }
        for (WhWmsStartPutawayVO pvo : map.keySet()) {
            shelvesList = (List)map.get(pvo);
            WhWmsHouseShelvesVO sourceShelvesVO = pvo.getSourceShelvesVO();
            for (WhWmsHouseShelves hs : shelvesList) {
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
                moveSkuVO.setSkuCode(pvo.getSkuCode());
                moveSkuVO.setSkuStatus(pvo.getSkuStatus());
                moveSkuVO.setBarCode(pvo.getBarCode());
                moveSkuVO.setOriginalHouseType(sourceShelvesVO.getHouseType());
                moveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
                moveSkuVO.setTargetHouseType(hs.getHouseType());
                moveSkuVO.setTargetShelvesCode(hs.getCode());
                moveSkuVO.setAmount(hs.getMaxAmount());
                moveStockSkuList.add(moveSkuVO);
            }
        }
        return moveStockSkuList;
    }

    private void prepareStartPutawayVO(List<WhWmsStartPutawayVO> pvoList) {
        if (EmptyUtil.isEmpty(pvoList)) {
            return;
        }
        ArrayList<String> skuCodes = new ArrayList<String>();
        for (WhWmsStartPutawayVO putawayVO : pvoList) {
            skuCodes.add(putawayVO.getSkuCode());
        }
        HashMap<String, WhWmsSkuInfoVO> skuInfoMap = new HashMap<String, WhWmsSkuInfoVO>();
        List<WhWmsSkuInfoVO> skuList = this.mapper.findWmsSkuInfoBySkuCodes(skuCodes);
        if (EmptyUtil.isNotEmpty(skuList)) {
            for (WhWmsSkuInfoVO skuInfo : skuList) {
                skuInfoMap.put(skuInfo.getCode(), skuInfo);
            }
        }
        for (WhWmsStartPutawayVO pvo : pvoList) {
            boolean customization = false;
            WhWmsSkuInfoVO skuInfo = (WhWmsSkuInfoVO)skuInfoMap.get(pvo.getSkuCode());
            if (NullUtil.isNotNull((Object)skuInfo) && NullUtil.isNotNull((Object)skuInfo.getCanCustomize()) && skuInfo.getCanCustomize() == 1) {
                customization = true;
            }
            pvo.setCustomization(customization);
        }
    }

    private void distributeByRule(WhWmsStartPutawayVO pvo, int skuMaxAmount, int putAmount, List<WhWmsHouseShelves> retList, String type, Integer shelvesType, Integer storageType, Integer skuStatus, Map<WhWmsStartPutawayVO, List<WhWmsHouseShelves>> map) {
        List<WhWmsHouseShelves> hsList2;
        Object whWmsHouseShelvesVOs;
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        example.createCriteria().andTypeEqualTo(type);
        List<WhWmsWarehouseArea> whWmsWarehouseAreaList = this.whWmsWarehouseAreaMapper.selectByExample(example);
        ArrayList<String> houseTypeList = new ArrayList<String>();
        for (WhWmsWarehouseArea whWmsWarehouseArea : whWmsWarehouseAreaList) {
            houseTypeList.add(whWmsWarehouseArea.getHouseType());
        }
        List<WhWmsSkuStock> smHs = this.findSameBatch(pvo, houseTypeList);
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        if (smHs != null && smHs.size() > 0) {
            cond.setShelvesType(shelvesType);
            cond.setStorageType(storageType);
            cond.setSkuStatus(skuStatus);
            for (WhWmsSkuStock putawayVO : smHs) {
                boolean isDistribute;
                cond.setCode(putawayVO.getShelvesCode());
                whWmsHouseShelvesVOs = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
                if (!CollectionUtils.isNotEmpty(whWmsHouseShelvesVOs) || (isDistribute = this.isDistribut(map, putawayVO.getShelvesCode())) || (putAmount = this.distributShelves(skuMaxAmount, putawayVO.getPhysicalWarehouseCode(), putawayVO.getHouseType(), putawayVO.getShelvesCode(), putAmount, retList, map)) > 0) continue;
                break;
            }
        }
        Map<String, WhWmsWarehouseArea> areaMap = this.whWmsWarehouseAreaService.getAreaHouseMapByType("NORMAL");
        if (putAmount > 0) {
            WhWmsHouseShelves hs;
            boolean isDistribute;
            cond = new WhWmsHouseShelvesCond();
            cond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            cond.setType(type);
            cond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
            cond.setShelvesStatus(WhWmsHouseShelvesVO.SHELVES_STATUS_UNOCCUPY);
            cond.setShelvesType(shelvesType);
            cond.setStorageType(storageType);
            cond.setSkuStatus(skuStatus);
            hsList2 = this.findHouseShelvesByCondNoPage(cond);
            this.houseShelvesSort(hsList2, areaMap, pvo.getSkuCode(), skuStatus);
            whWmsHouseShelvesVOs = hsList2.iterator();
            while (whWmsHouseShelvesVOs.hasNext() && ((isDistribute = this.isDistribut(map, (hs = whWmsHouseShelvesVOs.next()).getCode())) || (putAmount = this.distributShelves(skuMaxAmount, hs.getPhysicalWarehouseCode(), hs.getHouseType(), hs.getCode(), putAmount, retList, map)) > 0)) {
            }
        }
        if (putAmount > 0) {
            cond = new WhWmsHouseShelvesCond();
            cond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            cond.setType(type);
            cond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
            cond.setShelvesStatus(WhWmsHouseShelvesVO.SHELVES_STATUS_OCCUPY);
            cond.setMixedType(WhWmsHouseShelvesVO.MIXED_TYPE_MULTI);
            hsList2 = this.findHouseShelvesByCondNoPage(cond);
            this.houseShelvesSort(hsList2, areaMap, pvo.getSkuCode(), skuStatus);
            for (WhWmsHouseShelves hs : hsList2) {
                boolean isDistribute;
                WhWmsHouseShelvesVO whWmsHouseShelvesVO;
                WhWmsSkuStockVO whWmsSkuStockVO = new WhWmsSkuStockVO();
                whWmsSkuStockVO.setSkuCode(pvo.getSkuCode());
                whWmsSkuStockVO.setShelvesCode(hs.getCode());
                whWmsSkuStockVO.setPhysicalWarehouseCode(hs.getPhysicalWarehouseCode());
                whWmsSkuStockVO.setHouseType(hs.getHouseType());
                List<WhWmsSkuStockVO> list = this.whWmsSkuStockService.getWmsSkuStockByCond(whWmsSkuStockVO);
                boolean isHasSameBarcode = false;
                if (list != null && list.size() > 0) {
                    for (WhWmsSkuStockVO whWmsSkuStockVO1 : list) {
                        if (whWmsSkuStockVO1.getAmount() <= 0 || whWmsSkuStockVO1.getBarCode().equals(pvo.getBarCode())) continue;
                        isHasSameBarcode = true;
                    }
                }
                if (isHasSameBarcode || !(whWmsHouseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(hs.getCode())).getShelvesType().equals(shelvesType) || !whWmsHouseShelvesVO.getStorageType().equals(storageType) || !whWmsHouseShelvesVO.getSkuStatus().equals(skuStatus) || (isDistribute = this.isDistribut(map, hs.getCode())) || (putAmount = this.distributShelves(skuMaxAmount, hs.getPhysicalWarehouseCode(), hs.getHouseType(), hs.getCode(), putAmount, retList, map)) > 0) continue;
                break;
            }
        }
        if (putAmount > 0) {
            for (List<WhWmsHouseShelves> shelvesList : map.values()) {
                WhWmsHouseShelves whWmsHouseShelves;
                WhWmsHouseShelvesVO whWmsHouseShelvesVO;
                Iterator<WhWmsHouseShelves> iterator = shelvesList.iterator();
                while (!(!iterator.hasNext() || (whWmsHouseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode((whWmsHouseShelves = iterator.next()).getCode())) != null && whWmsHouseShelvesVO.getMixedType().equals(WhWmsHouseShelvesVO.MIXED_TYPE_MULTI) && whWmsHouseShelvesVO.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING) && whWmsHouseShelvesVO.getStorageType().equals(storageType) && whWmsHouseShelvesVO.getSkuStatus().equals(skuStatus) && (putAmount = this.distributShelves(skuMaxAmount, whWmsHouseShelvesVO.getPhysicalWarehouseCode(), whWmsHouseShelvesVO.getHouseType(), whWmsHouseShelvesVO.getCode(), putAmount, retList, map)) <= 0)) {
                }
            }
        }
        if (putAmount > 0) {
            throw new RuntimeException("\u6761\u5f62\u7801[" + pvo.getBarCode() + "],\u7269\u7406\u4ed3[" + pvo.getPhysicalWarehouseCode() + "],shelvesType[" + WhWmsHouseShelvesVO.getShelvesTypeNameStr(shelvesType) + "],storageType[" + WhWmsHouseShelvesVO.getStorageTypeStr(storageType) + "],skuStatus[" + skuStatus + "]\u627e\u4e0d\u5230\u53ef\u4f7f\u7528\u7684\u5e93\u4f4d");
        }
    }

    private boolean isDistribut(Map<WhWmsStartPutawayVO, List<WhWmsHouseShelves>> map, String shelvesCode) {
        for (List<WhWmsHouseShelves> shelvesList : map.values()) {
            for (WhWmsHouseShelves whWmsHouseShelves : shelvesList) {
                if (!whWmsHouseShelves.getCode().equals(shelvesCode)) continue;
                return true;
            }
        }
        return false;
    }

    private int distributShelves(int skuMaxAmount, String physicalWarehouseCode, String houseType, String shelvesCode, int putAmount, List<WhWmsHouseShelves> retList, Map<WhWmsStartPutawayVO, List<WhWmsHouseShelves>> map) {
        int max = skuMaxAmount;
        Integer shelvesMax = this.getMaxAmountByShelvesCode(physicalWarehouseCode, houseType, shelvesCode);
        if (shelvesMax != null) {
            max = shelvesMax;
        }
        WhWmsSkuStockVO whWmsSkuStockVO = new WhWmsSkuStockVO();
        whWmsSkuStockVO.setPhysicalWarehouseCode(physicalWarehouseCode);
        whWmsSkuStockVO.setShelvesCode(shelvesCode);
        whWmsSkuStockVO.setHouseType(houseType);
        List<WhWmsSkuStockVO> stockVOList = this.whWmsSkuStockService.findWmsSkuAvailableAccount(whWmsSkuStockVO);
        if (stockVOList != null && stockVOList.size() > 0) {
            for (WhWmsSkuStockVO whWmsSkuStockVO2 : stockVOList) {
                max -= whWmsSkuStockVO2.getAvailableAccount();
            }
        }
        for (List list : map.values()) {
            for (WhWmsHouseShelves whWmsHouseShelves : list) {
                if (!whWmsHouseShelves.getCode().equals(shelvesCode)) continue;
                max -= whWmsHouseShelves.getMaxAmount().intValue();
            }
        }
        if (max > 0 && putAmount > 0) {
            int changeAmount = 0;
            changeAmount = max > putAmount ? putAmount : max;
            putAmount -= changeAmount;
            WhWmsHouseShelves whWmsHouseShelves = new WhWmsHouseShelves();
            whWmsHouseShelves.setHouseType(houseType);
            whWmsHouseShelves.setPhysicalWarehouseCode(physicalWarehouseCode);
            whWmsHouseShelves.setCode(shelvesCode);
            whWmsHouseShelves.setMaxAmount(changeAmount);
            retList.add(whWmsHouseShelves);
            return putAmount;
        }
        return putAmount;
    }

    private Integer getMaxAmountByShelvesCode(String physicalWarehouseCode, String houseType, String shelvesCode) {
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setHouseType(houseType);
        cond.setCode(shelvesCode);
        List<WhWmsHouseShelves> shelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCondNoPage(cond);
        if (shelvesList != null && shelvesList.size() > 0 && shelvesList.get(0).getMaxAmount() != null) {
            return shelvesList.get(0).getMaxAmount();
        }
        return null;
    }

    private void savePutawayTask(WhWmsStartPutawayVO pvo, List<WhWmsHouseShelves> shelvesList, String batchNo) {
        if (shelvesList != null && shelvesList.size() > 0) {
            for (WhWmsHouseShelves whWmsHouseShelves : shelvesList) {
                WhWmsWaitPutawayTaskVO vo = new WhWmsWaitPutawayTaskVO();
                vo.setPhysicalWarehouseCode(whWmsHouseShelves.getPhysicalWarehouseCode());
                vo.setBarCode(pvo.getBarCode());
                vo.setSkuStatus(pvo.getSkuStatus());
                vo.setAmount(whWmsHouseShelves.getMaxAmount());
                vo.setShelvesCode(whWmsHouseShelves.getCode());
                vo.setBatchNo(batchNo);
                vo.setStatus(WhWmsWaitPutawayTask.STATUS_IN_PUTAWAY);
                vo.setSkuCode(pvo.getSkuCode());
                vo.setHouseType(whWmsHouseShelves.getHouseType());
                vo.setPutawayAmount(0);
                vo.setShortAmount(0);
                vo.setInOutType(pvo.getInOutType());
                vo = this.whWmsWaitPutawayTaskService.create(vo);
                WhWmsWaitPutawayTaskVO vo2 = new WhWmsWaitPutawayTaskVO();
                vo2.setId(vo.getId());
                String code = "SJ0000" + vo.getId();
                vo2.setCode(code);
                vo.setCode(code);
                this.whWmsWaitPutawayTaskService.update(vo2);
            }
        }
    }

    private void putawayInfoUpdate(WhWmsStartPutawayVO vo, String batchNo) {
        WhWmsWaitPutaway waitPutaway = this.mapper.selectByPrimaryKey(vo.getId());
        waitPutaway.setBatchNo(batchNo);
        waitPutaway.setPutawayStatus(WhWmsWaitPutaway.STATUS_IN_PUTAWAY);
        int count = this.mapper.updateByPrimaryKeySelective(waitPutaway);
        if (count != 1) {
            throw new WarehouseException("WH0001", String.format("[%s]\u72b6\u6001\u5f02\u5e38", vo.getId()));
        }
    }

    private void putawayOccupy(WhWmsWaitPutawayTaskVO whWmsWaitPutawayTaskVO) {
        WhWmsOccupyVO ocpy = new WhWmsOccupyVO();
        ocpy.setSkuCode(whWmsWaitPutawayTaskVO.getSkuCode());
        ocpy.setBarCode(whWmsWaitPutawayTaskVO.getBarCode());
        ocpy.setSkuStatus(whWmsWaitPutawayTaskVO.getSkuStatus());
        ocpy.setAmount(whWmsWaitPutawayTaskVO.getAmount());
        ocpy.setHouseType(whWmsWaitPutawayTaskVO.getHouseType());
        ocpy.setPhysicalWarehouseCode(whWmsWaitPutawayTaskVO.getPhysicalWarehouseCode());
        ocpy.setOriShelvesCode(whWmsWaitPutawayTaskVO.getShelvesCode());
        ocpy.setReceiptsNo(whWmsWaitPutawayTaskVO.getCode());
        ocpy.setStatus(WhWmsOccupyVO.OCCUPIED);
        this.whWmsOccupyService.wmsOccupy(ocpy);
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setHouseType("HOUSE_TYPE_RECEIVE");
        cond.setPhysicalWarehouseCode(whWmsWaitPutawayTaskVO.getPhysicalWarehouseCode());
        List<WhWmsHouseShelvesVO> shelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        String receiveShelves = "";
        if (shelvesList == null || shelvesList.size() <= 0) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u6536\u8d27\u533a\u5e93\u4f4d");
        }
        receiveShelves = shelvesList.get(0).getCode();
        WhWmsOccupyVO ocpyRe = new WhWmsOccupyVO();
        ocpyRe.setSkuCode(whWmsWaitPutawayTaskVO.getSkuCode());
        ocpyRe.setBarCode(whWmsWaitPutawayTaskVO.getBarCode());
        ocpyRe.setSkuStatus(whWmsWaitPutawayTaskVO.getSkuStatus());
        ocpyRe.setAmount(-whWmsWaitPutawayTaskVO.getAmount().intValue());
        ocpyRe.setHouseType("HOUSE_TYPE_RECEIVE");
        ocpyRe.setPhysicalWarehouseCode(whWmsWaitPutawayTaskVO.getPhysicalWarehouseCode());
        ocpyRe.setOriShelvesCode(receiveShelves);
        ocpyRe.setReceiptsNo(whWmsWaitPutawayTaskVO.getCode());
        ocpyRe.setStatus(WhWmsOccupyVO.OCCUPIED);
        this.whWmsOccupyService.wmsOccupy(ocpyRe);
    }

    private List<WhWmsHouseShelves> checkIsRelatedToSku(String physicalWarehouseCode, String skuCode, String type, StringBuffer warnMessage, Integer storageType) {
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setType(type);
        cond.setSkuCode(skuCode);
        cond.setStorageType(storageType);
        cond.setShelvesType(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);
        cond.setSkuStatus(1);
        List<WhWmsHouseShelves> hsList = this.whWmsHouseShelvesService.getHouseShelvesByCondNoPage(cond);
        if (hsList != null && hsList.size() > 0) {
            return hsList;
        }
        warnMessage.append("[" + skuCode + "]\u672a\u5173\u8054\u62e3\u8d27\u5e93\u4f4d \n");
        return null;
    }

    private int findSkuMaxAmount(String code) {
        WhWmsShelvesSkuInfo skuInfo = this.whWmsShelvesSkuInfoService.getSkuInfoByCode(code);
        return skuInfo != null ? skuInfo.getMaxAmount() : 0;
    }

    private List<WhWmsSkuStock> findSameBatch(WhWmsStartPutawayVO vo, List<String> houseTypeList) {
        WhWmsSkuStockExample example = new WhWmsSkuStockExample();
        WhWmsSkuStockExample.Criteria criteria = example.createCriteria();
        criteria.andPhysicalWarehouseCodeEqualTo(vo.getPhysicalWarehouseCode());
        criteria.andHouseTypeIn((List)houseTypeList);
        criteria.andBarCodeEqualTo(vo.getBarCode());
        criteria.andSkuStatusEqualTo(vo.getSkuStatus());
        criteria.andAmountGreaterThan(0);
        List<WhWmsSkuStock> stockList = this.whWmsSkuStockService.selectByExample(example);
        if (EmptyUtil.isNotEmpty(stockList)) {
            Map<String, WhWmsWarehouseArea> areaMap = this.whWmsWarehouseAreaService.getAreaHouseMapByType("NORMAL");
            ArrayList<String> shelvesCodes = new ArrayList<String>();
            for (WhWmsSkuStock stock : stockList) {
                shelvesCodes.add(stock.getShelvesCode());
            }
            List<WhWmsHouseShelves> shelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCode(shelvesCodes);
            if (EmptyUtil.isNotEmpty(shelvesList)) {
                this.houseShelvesSort(shelvesList, areaMap, vo.getSkuCode(), vo.getSkuStatus());
                final HashMap<String, Integer> shelvesSortedMap = new HashMap<String, Integer>();
                int i = 0;
                for (WhWmsHouseShelves shelves : shelvesList) {
                    shelvesSortedMap.put(shelves.getCode(), i++);
                }
                Collections.sort(stockList, new Comparator<WhWmsSkuStock>(){

                    @Override
                    public int compare(WhWmsSkuStock o1, WhWmsSkuStock o2) {
                        Integer s1 = (Integer)shelvesSortedMap.get(o1.getShelvesCode());
                        Integer s2 = (Integer)shelvesSortedMap.get(o2.getShelvesCode());
                        return s1.compareTo(s2);
                    }
                });
            }
        }
        return stockList;
    }

    private List<WhWmsHouseShelves> findHouseShelves(String physicalWarehouseCode, String type, Integer usableStatus, Integer shelvesStatus, Integer mixedType) {
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setType(type);
        cond.setShelvesUsableStatus(usableStatus);
        cond.setShelvesStatus(shelvesStatus);
        cond.setMixedType(mixedType);
        return this.whWmsHouseShelvesService.getHouseShelvesByCondNoPage(cond);
    }

    private List<WhWmsHouseShelves> findHouseShelvesByCondNoPage(WhWmsHouseShelvesCond cond) {
        return this.whWmsHouseShelvesService.getHouseShelvesByCondNoPage(cond);
    }

    private Integer parseInteger(Integer i) {
        return i == null ? 0 : i;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkQuInfo(WhReceiveShelvesVO vo) {
        WhCommand whCommand = this.whCommandMapper.selectByPrimaryKey(Long.parseLong(vo.getWhCommandId().toString()));
        if (whCommand == null) throw new RuntimeException("\u5355\u53f7" + vo.getReferenceCode() + "\u4e0d\u5b58\u5728");
        if (!whCommand.getCommandStatus().equals(WhCommand.STATUS_QUALITY_PROCESSING) && !whCommand.getCommandStatus().equals(WhCommand.STATUS_WAITING_QUALITY_CONTROL)) throw new RuntimeException("\u5355\u53f7" + vo.getReferenceCode() + "\u7684\u72b6\u6001\u5fc5\u987b\u662f\u5f85\u8d28\u68c0\u6216\u8d28\u68c0\u4e2d\u624d\u53ef\u4ee5\u8d28\u68c0");
        WhCommandSkuExample example = new WhCommandSkuExample();
        example.createCriteria().andCommandIdEqualTo(whCommand.getId());
        List<WhCommandSku> whCommandSkuList = this.whCommandSkuMapper.selectByExample(example);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (WhCommandSku whCommandSku : whCommandSkuList) {
            Integer amount = (Integer)map.get(whCommandSku.getSkuCode());
            if (amount == null) {
                map.put(whCommandSku.getSkuCode(), whCommandSku.getPlanedQuantity());
                continue;
            }
            map.put(whCommandSku.getSkuCode(), amount + whCommandSku.getPlanedQuantity());
        }
        WhWmsWaitPutawayExample whWmsWaitPutawayExample = new WhWmsWaitPutawayExample();
        whWmsWaitPutawayExample.createCriteria().andCommandCodeEqualTo(whCommand.getCode());
        List<WhWmsWaitPutaway> whWmsWaitPutawayList = this.mapper.selectByExample(whWmsWaitPutawayExample);
        for (WhWmsWaitPutaway whWmsWaitPutaway : whWmsWaitPutawayList) {
            Integer waitAmount;
            WhWmsSkuBarcodeExample whWmsSkuBarcodeExample = new WhWmsSkuBarcodeExample();
            whWmsSkuBarcodeExample.createCriteria().andBarCodeEqualTo(whWmsWaitPutaway.getBarCode());
            List<WhWmsSkuBarcode> barcodeList = this.whWmsSkuBarcodeMapper.selectByExample(whWmsSkuBarcodeExample);
            if (barcodeList == null || barcodeList.size() <= 0 || (waitAmount = (Integer)map.get(barcodeList.get(0).getSkuCode())) == null) continue;
            map.put(barcodeList.get(0).getSkuCode(), waitAmount - whWmsWaitPutaway.getReceiveAmount());
        }
        if (WhCommand.TYPE_PURCHASE_IN.equals(vo.getWhInType())) return true;
        for (WhQualityControlVO whQualityControlVO : vo.getQcList()) {
            Integer remainAmount = (Integer)map.get(whQualityControlVO.getQcSku());
            if (remainAmount == null) continue;
            remainAmount = remainAmount - (whQualityControlVO.getDefectiveQuantity() == null ? 0 : whQualityControlVO.getDefectiveQuantity());
            remainAmount = remainAmount - (whQualityControlVO.getNondefectiveQuantity() == null ? 0 : whQualityControlVO.getNondefectiveQuantity());
            remainAmount = remainAmount - (whQualityControlVO.getSampleQuantity() == null ? 0 : whQualityControlVO.getSampleQuantity());
            remainAmount = remainAmount - (whQualityControlVO.getWasteQuantity() == null ? 0 : whQualityControlVO.getWasteQuantity());
            remainAmount = remainAmount - (whQualityControlVO.getDisplayQuantity() == null ? 0 : whQualityControlVO.getDisplayQuantity());
            if ((remainAmount = Integer.valueOf(remainAmount - (whQualityControlVO.getPropQuantity() == null ? 0 : whQualityControlVO.getPropQuantity()))) < 0) {
                throw new RuntimeException(whQualityControlVO.getQcSku() + "\u7684\u6536\u8d27\u6570\u91cf\u5927\u4e8e\u8ba1\u5212\u6536\u8d27\u6570\u91cf");
            }
            map.put(whQualityControlVO.getQcSku(), remainAmount);
        }
        return true;
    }

    @Override
    public List<WhWmsWaitPutaway> getAllRemearkByReceiptsNo(String receiptsNo) {
        return this.mapper.getAllRemearkByReceiptsNo(receiptsNo);
    }

    @Override
    public List<WhWmsWaitPutawayVO> countQcQuantityByCond(List<String> receiptsNos, Integer inOutType) {
        return this.mapper.countQcQuantityByCond(receiptsNos, inOutType);
    }

    @Override
    public List<WhWmsWaitPutaway> getAllRemearkByCond(WhWmsWaitPutawayVO cond) {
        return this.mapper.getAllRemearkByCond(cond);
    }

    @Override
    public List<WhWmsWaitPutawayVO> findWaitPutawayWasteByCond(WhWmsWaitPutawayVO vo) {
        return this.mapper.findWaitPutawayWasteByCond(vo);
    }

    @Override
    public List<WhWmsWaitPutaway> listWaitPutawayByCond(WhWmsWaitPutawayVO vo) {
        WhWmsWaitPutawayExample example = new WhWmsWaitPutawayExample();
        WhWmsWaitPutawayExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(vo.getReceiptsNos())) {
            criteria.andReceiptsNoIn((List)vo.getReceiptsNos());
        }
        if (EmptyUtil.isNotEmpty((String)vo.getReceiptsNo())) {
            criteria.andReceiptsNoEqualTo(vo.getReceiptsNo());
        }
        if (CollectionUtils.isNotEmpty(vo.getIds())) {
            criteria.andIdIn((List)vo.getIds());
        }
        if (EmptyUtil.isNotEmpty((Object)vo.getSkuStatus())) {
            criteria.andSkuStatusEqualTo(vo.getSkuStatus());
        }
        if (EmptyUtil.isNotEmpty((String)vo.getOrderByClause())) {
            example.setOrderByClause(vo.getOrderByClause());
        }
        return this.mapper.selectByExample(example);
    }
}

