/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsTaskAssignCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsTaskAssignMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsInventoryService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsTaskAssignService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTakeStockPlanVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTaskAssignReqVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTaskAssignVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsTaskAssignService")
public class WhWmsTaskAssignServiceImpl
implements WhWmsTaskAssignService {
    @Autowired
    private WhWmsTaskAssignMapper whWmsTaskAssignMapper;
    @Autowired
    private WhWmsInventoryService whWmsInventoryService;
    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

    @Override
    public List<WhWmsTaskAssignVO> findWhWmsTaskAssignByCond(WhWmsTaskAssignCond cond) {
        return this.whWmsTaskAssignMapper.findWhWmsTaskAssignByCond(cond);
    }

    @Override
    public WhWmsTaskAssignVO findNotFinishedTaskAssign(String referenceCode, Integer type) {
        WhWmsTaskAssignCond cond = new WhWmsTaskAssignCond();
        cond.setReferenceCode(referenceCode);
        cond.setStatus(WhWmsTaskAssignVO.TASK_STATUS_PENDING);
        cond.setType(type);
        List<WhWmsTaskAssignVO> list = this.findWhWmsTaskAssignByCond(cond);
        if (EmptyUtil.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public WhWmsTaskAssignVO taskAssignAuto(WhWmsTaskAssignReqVO reqVO) {
        if (NullUtil.isNull((Object)reqVO) || NullUtil.isNull((Object)reqVO.getTaskType()) || EmptyUtil.isEmpty((String)reqVO.getPhysicalWarehouseCode())) {
            throw new WarehouseException("WH0001", "\u53c2\u6570\u5f02\u5e38");
        }
        WhWmsTaskAssignCond cond = new WhWmsTaskAssignCond();
        cond.setReferenceCode(reqVO.getReferenceCode());
        cond.setOperatorId(reqVO.getOperatorId());
        cond.setStatus(WhWmsTaskAssignVO.TASK_STATUS_PENDING);
        cond.setType(reqVO.getTaskType());
        cond.setInOutType(reqVO.getInOutType());
        cond.setConnectType(reqVO.getConnectType());
        cond.setConnectTypeList(reqVO.getConnectTypeList());
        cond.setMoveType(reqVO.getMoveType());
        cond.setHouseType(reqVO.getHouseType());
        cond.setInventoryStatus(reqVO.getInventoryStatus());
        cond.setShelvesColumn(reqVO.getShelvesColumn());
        List<WhWmsTaskAssignVO> taskList = this.whWmsTaskAssignMapper.findWhWmsTaskAssignUnFinishByCond(cond);
        if (EmptyUtil.isNotEmpty(taskList)) {
            return taskList.get(0);
        }
        WhWmsTaskAssignVO vo = null;
        if (WhWmsTaskAssignVO.TASK_TYPE_CONNPICKSKU.equals(reqVO.getTaskType())) {
            vo = this.taskAssignConnPickSku(reqVO);
        } else if (WhWmsTaskAssignVO.TASK_TYPE_MOVESHELVES.equals(reqVO.getTaskType())) {
            vo = this.taskAssignMoveShelves(reqVO);
        } else if (WhWmsTaskAssignVO.TASK_TYPE_INVENTORY.equals(reqVO.getTaskType())) {
            vo = this.taskAssignInventory(reqVO);
        }
        this.afterTaskAssign(vo);
        if (NullUtil.isNotNull((Object)vo)) {
            vo.setFirstGetTask(true);
        }
        return vo;
    }

    @Override
    @Transactional
    public WhWmsTaskAssignVO taskAssignAsked(WhWmsTaskAssignReqVO reqVO) {
        WhWmsTaskAssignVO vo;
        if (NullUtil.isNull((Object)reqVO) || NullUtil.isNull((Object)reqVO.getTaskType()) || EmptyUtil.isEmpty((String)reqVO.getPhysicalWarehouseCode())) {
            throw new WarehouseException("WH0001", "\u53c2\u6570\u5f02\u5e38");
        }
        this.checkTaskAsked(reqVO);
        WhWmsTaskAssignCond cond = new WhWmsTaskAssignCond();
        cond.setReferenceCode(reqVO.getReferenceCode());
        cond.setType(reqVO.getTaskType());
        List<WhWmsTaskAssignVO> assignedList = this.findWhWmsTaskAssignByCond(cond);
        if (EmptyUtil.isNotEmpty(assignedList)) {
            WhWmsTaskAssignVO taskAssignVO = assignedList.get(0);
            if (taskAssignVO.getOperatorId().equals(reqVO.getOperatorId())) {
                return taskAssignVO;
            }
            if (!reqVO.isForce()) {
                throw new WarehouseException("WH0110", "\u4efb\u52a1\u5df2\u88ab\u9886\u53d6");
            }
        }
        if (EmptyUtil.isNotEmpty(assignedList)) {
            vo = assignedList.get(0);
            vo.setOperatorId(reqVO.getOperatorId());
            vo.setCreateTime(DateUtil.getNow());
            this.whWmsTaskAssignMapper.updateByPrimaryKeySelective(vo);
            return vo;
        }
        vo = this.buildAndInsertTaskAssignVo(reqVO);
        this.afterTaskAssign(vo);
        return vo;
    }

    private void checkInventoryStatus(Long planId, Integer inventoryStatus) {
    }

    @Override
    @Transactional
    public void finishTaskAssigned(Long id, Long operatorId) {
        WhWmsTaskAssignVO update = new WhWmsTaskAssignVO();
        update.setOperatorId(operatorId);
        update.setId(id);
        update.setStatus(WhWmsTaskAssignVO.TASK_STATUS_FINISHED);
        update.setFinishTime(DateUtil.getNow());
        this.whWmsTaskAssignMapper.updateByPrimaryKeySelective(update);
    }

    @Override
    @Transactional
    public void finishTaskAssigned(String referenceCode, Integer type, Long operatorId) {
        WhWmsTaskAssignVO taskAssign;
        if (NullUtil.isNull((Object)operatorId)) {
            operatorId = 1L;
        }
        if (NullUtil.isNotNull((Object)(taskAssign = this.findNotFinishedTaskAssign(referenceCode, type)))) {
            this.finishTaskAssigned(taskAssign.getId(), operatorId);
        }
    }

    @Override
    public Integer checkIfAnyMoveStockAssignEd(List<String> codeList) {
        return this.whWmsTaskAssignMapper.checkIfAnyMoveStockAssignEd(codeList);
    }

    private WhWmsTaskAssignVO taskAssignConnPickSku(WhWmsTaskAssignReqVO reqVO) {
        if (NullUtil.isNull((Object)reqVO.getInOutType())) {
            throw new WarehouseException("WH0001", "\u53c2\u6570\u5f02\u5e38,inOutType\u5fc5\u586b");
        }
        while (true) {
            try {
                Long connectId = this.whWmsTaskAssignMapper.tryFindAssignConnectPickSku(reqVO);
                if (NullUtil.isNull((Object)connectId)) {
                    return null;
                }
                reqVO.setReferenceCode(connectId.toString());
                WhWmsTaskAssignVO vo = this.buildAndInsertTaskAssignVo(reqVO);
                return vo;
            }
            catch (DuplicateKeyException duplicateKeyException) {
                continue;
            }
            break;
        }
    }

    private WhWmsTaskAssignVO taskAssignMoveShelves(WhWmsTaskAssignReqVO reqVO) {
        while (true) {
            try {
                String moveCode = this.whWmsTaskAssignMapper.tryFindAssignMoveShelves(reqVO);
                if (NullUtil.isNull((Object)moveCode)) {
                    return null;
                }
                reqVO.setReferenceCode(moveCode);
                WhWmsTaskAssignVO vo = this.buildAndInsertTaskAssignVo(reqVO);
                return vo;
            }
            catch (DuplicateKeyException duplicateKeyException) {
                continue;
            }
            break;
        }
    }

    private WhWmsTaskAssignVO taskAssignInventory(WhWmsTaskAssignReqVO reqVO) {
        while (true) {
            try {
                Long planId = this.whWmsTaskAssignMapper.tryFindAssignInventory(reqVO);
                if (NullUtil.isNull((Object)planId)) {
                    return null;
                }
                reqVO.setReferenceCode(planId.toString());
                WhWmsTaskAssignVO vo = this.buildAndInsertTaskAssignVo(reqVO);
                return vo;
            }
            catch (DuplicateKeyException duplicateKeyException) {
                continue;
            }
            break;
        }
    }

    private void cancelTaskAssigned(String referenceCode, Integer type) {
        this.whWmsTaskAssignMapper.cancelTaskAssigned(referenceCode, type);
    }

    private void checkTaskAsked(WhWmsTaskAssignReqVO reqVO) {
        if (WhWmsTaskAssignVO.TASK_TYPE_CONNPICKSKU.equals(reqVO.getTaskType())) {
            this.checkConnectPickSku(reqVO);
        } else if (WhWmsTaskAssignVO.TASK_TYPE_MOVESHELVES.equals(reqVO.getTaskType())) {
            this.checkMoveShelves(reqVO);
        } else if (WhWmsTaskAssignVO.TASK_TYPE_INVENTORY.equals(reqVO.getTaskType())) {
            this.checkInventory(reqVO);
        }
    }

    private void checkConnectPickSku(WhWmsTaskAssignReqVO reqVO) {
        if (EmptyUtil.isEmpty((String)reqVO.getReferenceCode())) {
            throw new WarehouseException("WH0001", "\u4efb\u52a1\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        }
        WhWmsConnectInfoVO connectInfo = this.whWmsConnectInfoService.findById(Long.valueOf(reqVO.getReferenceCode()));
        if (NullUtil.isNull((Object)connectInfo)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u4e0d\u5b58\u5728[" + reqVO.getReferenceCode() + "]");
        }
        if (!WMSConstants.ConnectStatus.WAITING_PROCESS.equals(connectInfo.getConnectStatus()) && !WMSConstants.ConnectStatus.PROCESSING.equals(connectInfo.getConnectStatus())) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u72b6\u6001[" + WhWmsConnectInfoVO.getConnectStatusStr(connectInfo.getConnectStatus()) + "]");
        }
        if ((WhCommand.TYPE_SALES_OUT.equals(connectInfo.getInOutType()) || WhCommand.TYPE_CHANGE_OUT.equals(connectInfo.getInOutType())) && NullUtil.isNotNull((Object)connectInfo.getDistributeStatus()) && 1 != connectInfo.getDistributeStatus()) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u72b6\u6001[" + connectInfo.getDistributeStatusName() + "]");
        }
        if (NullUtil.isNull((Object)reqVO.getInOutType()) || NullUtil.isNull((Object)connectInfo.getInOutType()) || !reqVO.getInOutType().equals(connectInfo.getInOutType()) || WhCommand.TYPE_SALES_OUT.equals(reqVO.getInOutType()) && EmptyUtil.isEmpty((String)reqVO.getConnectType()) && "receive_waste".equals(connectInfo.getConnectType()) || WhCommand.TYPE_SALES_OUT.equals(reqVO.getInOutType()) && EmptyUtil.isNotEmpty((String)reqVO.getConnectType()) && !"receive_waste".equals(connectInfo.getConnectType())) {
            throw new WarehouseException("WH0001", "\u51fa\u5e93\u7c7b\u578b\u4e0d\u6b63\u786e[" + reqVO.getReferenceCode() + "]");
        }
    }

    private void checkMoveShelves(WhWmsTaskAssignReqVO reqVO) {
        if (EmptyUtil.isEmpty((String)reqVO.getReferenceCode())) {
            throw new WarehouseException("WH0001", "\u4efb\u52a1\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        }
        WhWmsMoveStockVO moveStock = this.whWmsMoveStockService.getMoveStockByCode(reqVO.getReferenceCode());
        if (NullUtil.isNull((Object)moveStock)) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u4e0d\u5b58\u5728[" + reqVO.getReferenceCode() + "]");
        }
        if (!WhWmsMoveStockVO.STATUS_WAITTINT_OUT.equals(moveStock.getStatus()) && !WhWmsMoveStockVO.STATUS_PROCESSING.equals(moveStock.getStatus())) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u72b6\u6001[" + WhWmsMoveStockVO.getStatusName(moveStock.getStatus()) + "]");
        }
        if (NullUtil.isNotNull((Object)reqVO.getMoveType()) && !reqVO.getMoveType().equals(moveStock.getMoveType())) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u7c7b\u578b\u4e0d\u6b63\u786e[" + reqVO.getReferenceCode() + "]");
        }
    }

    private void checkInventory(WhWmsTaskAssignReqVO reqVO) {
        block10: {
            if (EmptyUtil.isNotEmpty((String)reqVO.getShelvesCode()) && EmptyUtil.isEmpty((String)reqVO.getReferenceCode()) && NullUtil.isNotNull((Object)reqVO.getInventoryStatus())) {
                ArrayList<Integer> statusList = new ArrayList<Integer>();
                if (WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(reqVO.getInventoryStatus())) {
                    statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_PENDING);
                    statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING);
                } else if (WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING.equals(reqVO.getInventoryStatus())) {
                    statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING);
                }
                WhWmsInventoryPlanShelvesCond planShelvesCond = new WhWmsInventoryPlanShelvesCond();
                planShelvesCond.setShelvesCode(reqVO.getShelvesCode());
                planShelvesCond.setStatusList(statusList);
                List<WhWmsInventoryPlanShelvesVO> planVOList = this.whWmsInventoryService.findInventoryPlanShelvesByCond(planShelvesCond);
                if (EmptyUtil.isEmpty(planVOList)) {
                    throw new WarehouseException("WH0001", "\u5e93\u4f4d\u65e0[" + WhWmsTakeStockPlanVO.getStatusStr(reqVO.getInventoryStatus()) + "]\u4efb\u52a1[" + reqVO.getShelvesCode() + "]");
                }
                reqVO.setReferenceCode(planVOList.get(0).getId().toString());
            } else {
                if (EmptyUtil.isNotEmpty((String)reqVO.getReferenceCode()) && NullUtil.isNotNull((Object)reqVO.getInventoryStatus())) {
                    try {
                        Long planShelvesId = Long.parseLong(reqVO.getReferenceCode());
                        WhWmsInventoryPlanShelvesVO planShelves = this.whWmsInventoryService.findInventoryPlanShelves(planShelvesId, false);
                        if (!(WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(planShelves.getStatus()) || WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(planShelves.getStatus()) || WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING.equals(reqVO.getInventoryStatus()))) {
                            throw new WarehouseException("WH0001", "\u76d8\u70b9\u8ba1\u5212\u72b6\u6001[" + WhWmsInventoryPlanShelvesVO.getStatusName(planShelves.getStatus()) + "]");
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        throw new WarehouseException("WH0001", "\u76d8\u70b9\u4efb\u52a1\u4e0d\u5b58\u5728[" + reqVO.getReferenceCode() + "]");
                    }
                }
                throw new WarehouseException("WH0002", "\u53c2\u6570\u5f02\u5e38");
            }
        }
    }

    private WhWmsTaskAssignVO buildAndInsertTaskAssignVo(WhWmsTaskAssignReqVO reqVO) {
        WhWmsTaskAssignVO vo = new WhWmsTaskAssignVO();
        vo.setReferenceCode(reqVO.getReferenceCode());
        vo.setType(reqVO.getTaskType());
        vo.setStatus(WhWmsTaskAssignVO.TASK_STATUS_PENDING);
        vo.setOperatorId(reqVO.getOperatorId());
        vo.setCreateTime(DateUtil.getNow());
        this.whWmsTaskAssignMapper.insert(vo);
        vo.setCode("TA" + vo.getId());
        this.whWmsTaskAssignMapper.updateByPrimaryKeySelective(vo);
        return vo;
    }

    private void afterTaskAssign(WhWmsTaskAssignVO vo) {
        Long planShelvesId;
        WhWmsInventoryPlanShelvesVO planShelves;
        if (NullUtil.isNull((Object)vo)) {
            return;
        }
        if (WhWmsTaskAssignVO.TASK_TYPE_CONNPICKSKU.equals(vo.getType())) {
            Long connectId = Long.parseLong(vo.getReferenceCode());
            this.whWmsConnectInfoService.connectStatusTransform(connectId, WMSConstants.ConnectStatus.WAITING_PROCESS, WMSConstants.ConnectStatus.PROCESSING);
        } else if (WhWmsTaskAssignVO.TASK_TYPE_INVENTORY.equals(vo.getType()) && WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals((planShelves = this.whWmsInventoryService.findInventoryPlanShelves(planShelvesId = Long.valueOf(Long.parseLong(vo.getReferenceCode())), false)).getStatus())) {
            planShelves.setStatus(WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING);
            this.whWmsInventoryService.updateInventoryPlanShelves(planShelves);
        }
    }
}

