/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuTranslateService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuTranslateItemVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuTranslateVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsStartPutawayVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTakeStockPlanVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTakeStockRcdVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsSkuTranslateService")
public class WhWmsSkuTranslateServiceImpl
implements WhWmsSkuTranslateService {
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsWaitPutawayService whWmsWaitPutawayService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

    @Override
    @Transactional
    public boolean skuTranslate(WhWmsSkuTranslateVO vo) {
        return false;
    }

    private boolean checkStock(WhWmsSkuTranslateVO vo) {
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        for (WhWmsSkuTranslateItemVO item : vo.getItems()) {
            cond.setSkuCode(item.getSkuCode());
            cond.setSkuStatus(item.getSkuStatus());
            cond.setBarCode(item.getBarCode());
            cond.setShelvesCode(item.getShelvesCode());
            List<WhWmsSkuStockVO> shelvesStockList = this.whWmsSkuStockService.getWmsSkuStocksByShelvesCond(cond);
            if (EmptyUtil.isEmpty(shelvesStockList) || shelvesStockList.size() > 1) {
                String msg = String.format("[%s][%s][%s]\u5e93\u5b58\u4e0d\u8db3", item.getShelvesCode(), item.getBarCode(), WhCommand.getSkuStatusName(item.getSkuStatus()));
                throw new WarehouseException("WH0001", msg);
            }
            WhWmsSkuStockVO stock = shelvesStockList.get(0);
            if (item.getChangeAmount() > stock.getTotalAmount()) {
                String msg = String.format("[%s][%s][%s][%d]<[%d]\u5e93\u5b58\u4e0d\u8db3", item.getShelvesCode(), item.getBarCode(), WhCommand.getSkuStatusName(item.getSkuStatus()), stock.getTotalAmount(), item.getChangeAmount());
                throw new WarehouseException("WH0001", msg);
            }
            if (item.getChangeAmount() <= stock.getAvailableAmount()) continue;
            String msg = String.format("[%s][%s][%s][%d]<[%d]\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3", item.getShelvesCode(), item.getBarCode(), WhCommand.getSkuStatusName(item.getSkuStatus()), stock.getAvailableAmount(), item.getChangeAmount());
            throw new WarehouseException("WH0001", msg);
        }
        return true;
    }

    private List<WhWmsTakeStockPlanVO> buildTakeStockPlan(WhWmsSkuTranslateVO vo) {
        WhWmsHouseShelvesVO shelvesVO;
        if (EmptyUtil.isEmpty(vo.getItems())) {
            return null;
        }
        ArrayList<String> shelvesCodes = new ArrayList<String>();
        for (WhWmsSkuTranslateItemVO item : vo.getItems()) {
            shelvesCodes.add(item.getShelvesCode());
        }
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setShelvesCodeList(shelvesCodes);
        List<WhWmsHouseShelvesVO> shelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        HashMap<String, WhWmsHouseShelvesVO> shelvesMap = new HashMap<String, WhWmsHouseShelvesVO>();
        if (EmptyUtil.isNotEmpty(shelvesList)) {
            for (WhWmsHouseShelvesVO whWmsHouseShelvesVO : shelvesList) {
                shelvesMap.put(whWmsHouseShelvesVO.getCode(), whWmsHouseShelvesVO);
            }
        }
        HashMap shelvesItemMap = new HashMap();
        for (WhWmsSkuTranslateItemVO item : vo.getItems()) {
            String key = item.getShelvesCode();
            ArrayList<WhWmsSkuTranslateItemVO> itemList = (ArrayList<WhWmsSkuTranslateItemVO>)shelvesItemMap.get(key);
            if (NullUtil.isNull((Object)itemList)) {
                itemList = new ArrayList<WhWmsSkuTranslateItemVO>();
                shelvesItemMap.put(key, itemList);
            }
            shelvesVO = (WhWmsHouseShelvesVO)shelvesMap.get(key.toUpperCase());
            item.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
            item.setHouseType(shelvesVO.getHouseType());
            itemList.add(item);
            if (!EmptyUtil.isEmpty((String)vo.getPhysicalWarehouseCode())) continue;
            vo.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
        }
        ArrayList<WhWmsTakeStockPlanVO> arrayList = new ArrayList<WhWmsTakeStockPlanVO>();
        Date submitTime = DateUtil.getNow();
        for (String shelvesCode : shelvesItemMap.keySet()) {
            shelvesVO = (WhWmsHouseShelvesVO)shelvesMap.get(shelvesCode);
            if (NullUtil.isNull((Object)shelvesVO)) {
                throw new WarehouseException("WH0001", String.format("[%s]\u5e93\u4f4d\u4e0d\u5b58\u5728", shelvesCode));
            }
            WhWmsTakeStockPlanVO plan = new WhWmsTakeStockPlanVO();
            plan.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
            plan.setHouseType(shelvesVO.getHouseType());
            plan.setShelvesCode(shelvesVO.getCode());
            plan.setSubmitUserId(vo.getOperatorId());
            plan.setSubmitTime(submitTime);
            plan.setStatus(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY);
            plan.setDiff(1);
            plan.setTakeStockRcdList(this.buildTakeStockRcds((List)shelvesItemMap.get(shelvesCode), vo));
            arrayList.add(plan);
        }
        return arrayList;
    }

    private String moveStock(WhWmsSkuTranslateVO vo) {
        List<WhWmsMoveSkuVO> moveskuList = null;
        List<WhWmsStartPutawayVO> pvoList = this.buildPutawayVOs(vo);
        if (EmptyUtil.isNotEmpty(pvoList)) {
            moveskuList = this.whWmsWaitPutawayService.recommendWmsHouseShelves(pvoList);
        }
        if (EmptyUtil.isNotEmpty(moveskuList)) {
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(vo.getOperatorId());
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SKU_TRANSLATE);
            moveStockVO.setMoveSkuList(moveskuList);
            this.whWmsMoveStockService.newMoveStock(moveStockVO);
            return moveStockVO.getCode();
        }
        return null;
    }

    private List<WhWmsStartPutawayVO> buildPutawayVOs(WhWmsSkuTranslateVO vo) {
        ArrayList<WhWmsStartPutawayVO> pvoList = new ArrayList<WhWmsStartPutawayVO>();
        if (EmptyUtil.isNotEmpty((Object)vo) && EmptyUtil.isNotEmpty(vo.getItems())) {
            for (WhWmsSkuTranslateItemVO item : vo.getItems()) {
                WhWmsStartPutawayVO pt = new WhWmsStartPutawayVO();
                WhWmsHouseShelvesVO shelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(item.getShelvesCode());
                pt.setSourceShelvesVO(shelvesVO);
                pt.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
                pt.setPutawayAmount(item.getChangeAmount());
                pt.setSkuCode(item.getSkuCode());
                pt.setBarCode(item.getBarCode());
                pt.setSkuStatus(vo.getTargetSkuStatus());
                pt.setReceiveAmount(item.getChangeAmount());
                pt.setStorageType(item.getSkuStorageType());
                pvoList.add(pt);
            }
        }
        return pvoList;
    }

    private List<WhWmsTakeStockRcdVO> buildTakeStockRcds(List<WhWmsSkuTranslateItemVO> itemList, WhWmsSkuTranslateVO vo) {
        if (EmptyUtil.isEmpty(itemList)) {
            throw new WarehouseException("WH0001", String.format("\u65e0\u53ef\u7528\u6570\u636e", new Object[0]));
        }
        ArrayList<WhWmsTakeStockRcdVO> whTakeStockRcdList = new ArrayList<WhWmsTakeStockRcdVO>();
        for (WhWmsSkuTranslateItemVO item : itemList) {
            WhWmsTakeStockRcdVO whWmsTakeStockRcd = new WhWmsTakeStockRcdVO();
            whWmsTakeStockRcd.setPhysicalWarehouseCode(item.getPhysicalWarehouseCode());
            whWmsTakeStockRcd.setHouseType(item.getHouseType());
            whWmsTakeStockRcd.setSkuStatus(item.getSkuStatus());
            whWmsTakeStockRcd.setSkuCode(item.getSkuCode());
            whWmsTakeStockRcd.setBarCode(item.getBarCode());
            whWmsTakeStockRcd.setShelvesCode(item.getShelvesCode());
            whWmsTakeStockRcd.setOriAmount(item.getAmount());
            whWmsTakeStockRcd.setRealAmount(item.getAmount() - item.getChangeAmount());
            whWmsTakeStockRcd.setDiffAmount(-item.getChangeAmount().intValue());
            whWmsTakeStockRcd.setCreateUserId(vo.getOperatorId());
            whWmsTakeStockRcd.setTakeStockeStatus(WhWmsTakeStockRcdVO.STATUS_PEDDING_AUDIT);
            whWmsTakeStockRcd.setMemo(vo.getMemo());
            whWmsTakeStockRcd.setAuditUserId(vo.getOperatorId());
            whTakeStockRcdList.add(whWmsTakeStockRcd);
            whWmsTakeStockRcd = new WhWmsTakeStockRcdVO();
            whWmsTakeStockRcd.setPhysicalWarehouseCode(item.getPhysicalWarehouseCode());
            whWmsTakeStockRcd.setHouseType(item.getHouseType());
            whWmsTakeStockRcd.setSkuStatus(vo.getTargetSkuStatus());
            whWmsTakeStockRcd.setSkuCode(item.getSkuCode());
            whWmsTakeStockRcd.setBarCode(item.getBarCode());
            whWmsTakeStockRcd.setShelvesCode(item.getShelvesCode());
            whWmsTakeStockRcd.setOriAmount(0);
            whWmsTakeStockRcd.setRealAmount(item.getChangeAmount());
            whWmsTakeStockRcd.setDiffAmount(item.getChangeAmount());
            whWmsTakeStockRcd.setCreateUserId(vo.getOperatorId());
            whWmsTakeStockRcd.setTakeStockeStatus(WhWmsTakeStockRcdVO.STATUS_PEDDING_AUDIT);
            whWmsTakeStockRcd.setMemo(vo.getMemo());
            whWmsTakeStockRcd.setAuditUserId(vo.getOperatorId());
            whTakeStockRcdList.add(whWmsTakeStockRcd);
        }
        return whTakeStockRcdList;
    }
}

