/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.PhyWhSkuStockRcdCond;
import com.thebeastshop.pegasus.service.warehouse.cond.PhyWhStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuStockRecordCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsHouseShelvesMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuStockMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuStockRecordMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStockExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStockRecord;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.PhyWhSkuStockRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.PhyWhStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhDistrictPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGjStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockDiffVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockRecordVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whWmsSkuStockService")
public class WhWmsSkuStockServiceImpl
implements WhWmsSkuStockService {
    @Autowired
    private WhWmsSkuStockMapper mapper;
    @Autowired
    private WhWmsSkuStockRecordMapper whWmsSkuStockRecordMapper;
    @Autowired
    private WhWmsHouseShelvesMapper whWmsHouseShelvesMapper;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Override
    public WhWmsSkuStockVO create(WhWmsSkuStockVO skuStockVO) {
        WhWmsSkuStock skuStock = (WhWmsSkuStock)BeanUtil.buildFrom((Object)skuStockVO, WhWmsSkuStock.class);
        skuStock.setLastUpdateTime(new Date());
        this.mapper.insert(skuStock);
        skuStockVO.setId(skuStock.getId());
        return skuStockVO;
    }

    @Override
    public Boolean update(WhWmsSkuStockVO skuStockVO) {
        skuStockVO.setLastUpdateTime(new Date());
        return this.mapper.updateByPrimaryKeySelective((WhWmsSkuStock)BeanUtil.buildFrom((Object)skuStockVO, WhWmsSkuStock.class)) != 0;
    }

    @Override
    public WhWmsSkuStockVO findById(Long id) {
        WhWmsSkuStock skuStock = this.mapper.selectByPrimaryKey(id);
        if (skuStock != null) {
            return (WhWmsSkuStockVO)BeanUtil.buildFrom((Object)skuStock, WhWmsSkuStockVO.class);
        }
        return null;
    }

    @Override
    public boolean updateStockById(Integer id, Integer amount) {
        if (null != id) {
            WhWmsSkuStock skuStock = this.mapper.selectByPrimaryKey(id.longValue());
            skuStock.setLastUpdateTime(new Date());
            return this.mapper.updateStockById(id, amount, skuStock.getVersion()) != 0;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateStockByCond(Integer amount, String physicalWarehouseCode, String houseType, String barcode, String shelvesCode, String skuCode, Integer skuStatus, Integer inoutType, String receiptNo, Long userId, String memo, Integer isUpdateScm) {
        return this.updateStockByCond(amount, physicalWarehouseCode, houseType, barcode, shelvesCode, skuCode, skuStatus, inoutType, receiptNo, userId, memo, isUpdateScm, true);
    }

    @Override
    @Transactional
    public boolean outSkuStockByCond(Integer amount, String physicalWarehouseCode, String houseType, String barcode, String shelvesCode, String skuCode, Integer skuStatus) {
        if (amount == null || physicalWarehouseCode == null || houseType == null || barcode == null || shelvesCode == null || skuCode == null || skuStatus == null) {
            throw new WarehouseException("WH0002", "NullPointerException");
        }
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setHouseType(houseType);
        cond.setBarCode(barcode);
        cond.setShelvesCode(shelvesCode);
        cond.setSkuCode(skuCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsSkuStock> list = this.mapper.getByCond(cond);
        WhWmsSkuStock sk = null;
        if (null != list && list.size() == 1) {
            sk = list.get(0);
            if (sk.getAmount() + amount < 0) {
                throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + physicalWarehouseCode + "][" + shelvesCode + "][" + barcode + "][" + WhCommand.getSkuStatusName(skuStatus) + "][" + sk.getAmount() + "<" + -amount.intValue() + "]\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u53ef\u4ee5\u51fa\u5e93");
            }
            int i = 0;
            boolean isTurn = true;
            do {
                int updateCount = this.mapper.updateStockByPrimaryKey(amount, sk.getVersion(), sk.getId());
                if (i >= 3 || updateCount > 0) {
                    isTurn = false;
                } else {
                    List<WhWmsSkuStock> newList = this.mapper.getByCond(cond);
                    if (newList != null && newList.size() > 0) {
                        sk = newList.get(0);
                    }
                }
                ++i;
            } while (isTurn);
            if (i > 3) {
                throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + physicalWarehouseCode + "][" + shelvesCode + "][" + barcode + "][" + WhCommand.getSkuStatusName(skuStatus) + "][" + amount + "]\u5e93\u5b58\u4fee\u6539\u5931\u8d25");
            }
        } else {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + physicalWarehouseCode + "][" + shelvesCode + "][" + barcode + "][" + WhCommand.getSkuStatusName(skuStatus) + "][" + -amount.intValue() + "]\u8fd8\u6ca1\u6709\u5e93\u5b58\u8bb0\u5f55\u4e0d\u53ef\u4ee5\u51fa\u5e93");
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updatePhyWhSkuStock(String physicalWarehouseCode, String skuCode, Integer skuStatus, Integer quantity, Integer inOutType, String referenceCode, Long operatorId, String memo) {
        if (quantity == null || physicalWarehouseCode == null || skuCode == null || skuStatus == null || inOutType == null || referenceCode == null) {
            throw new WarehouseException("WH0002", "\u53c2\u6570\u5f02\u5e38");
        }
        if (quantity < 0) {
            this.updatePhyWhSkuStockOut(physicalWarehouseCode, skuCode, skuStatus, quantity, inOutType, referenceCode, operatorId, memo);
        } else if (quantity > 0) {
            this.updatePhyWhSkuStockIn(physicalWarehouseCode, skuCode, skuStatus, quantity, inOutType, referenceCode, operatorId, memo);
        }
        return true;
    }

    private boolean updatePhyWhSkuStockIn(String physicalWarehouseCode, String skuCode, Integer skuStatus, Integer quantity, Integer inOutType, String referenceCode, Long operatorId, String memo) {
        WhWmsHouseShelvesVO houseShelves = this.findPhyWhShelves(physicalWarehouseCode, skuStatus);
        this.updateStockByCond(quantity, physicalWarehouseCode, houseShelves.getHouseType(), skuCode + "_0000", houseShelves.getCode(), skuCode, skuStatus, inOutType, referenceCode, operatorId, memo, 2);
        return true;
    }

    private WhWmsHouseShelvesVO findPhyWhShelves(String physicalWarehouseCode, Integer skuStatus) {
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsHouseShelvesVO> whWmsHouseShelvesVOs = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(whWmsHouseShelvesVOs)) {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u5e93\u4f4d\u4e0d\u5b58\u5728!");
        }
        if (whWmsHouseShelvesVOs.size() > 1) {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u67e5\u8be2\u6709\u591a\u4e2a\u5e93\u4f4d!");
        }
        return whWmsHouseShelvesVOs.get(0);
    }

    private boolean updatePhyWhSkuStockOut(String physicalWarehouseCode, String skuCode, Integer skuStatus, Integer quantity, Integer inOutType, String referenceCode, Long operatorId, String memo) {
        List<WhWmsSkuStock> skuStockList;
        if (NullUtil.isNull((Object)operatorId)) {
            operatorId = 1L;
        }
        int needQuantity = -quantity.intValue();
        int errorCount = 0;
        block2: while (errorCount < 3 && needQuantity != 0 && !EmptyUtil.isEmpty(skuStockList = this.findPhyWhSkuStock(physicalWarehouseCode, skuCode, skuStatus))) {
            this.sortPhyWhSkuStock(skuStockList);
            for (WhWmsSkuStock skuStock : skuStockList) {
                int canUse = Math.min(needQuantity, skuStock.getAmount());
                try {
                    this.updateStockByCond(-canUse, skuStock.getPhysicalWarehouseCode(), skuStock.getHouseType(), skuStock.getBarCode(), skuStock.getShelvesCode(), skuStock.getSkuCode(), skuStock.getSkuStatus(), inOutType, referenceCode, operatorId, memo, 2);
                    skuStock.setAmount(skuStock.getAmount() - (needQuantity -= canUse));
                    if (needQuantity != 0) continue;
                }
                catch (WarehouseException whEx) {
                    ++errorCount;
                }
                continue block2;
            }
        }
        if (needQuantity != 0) {
            throw new WarehouseException("WH0001", String.format("\u7269\u7406\u4ed3[%s][%s][%s]\u5e93\u5b58\u4e0d\u8db3[%s]", physicalWarehouseCode, skuCode, WhCommand.getSkuStatusName(skuStatus), -quantity.intValue()));
        }
        return true;
    }

    private List<WhWmsSkuStock> findPhyWhSkuStock(String physicalWarehouseCode, String skuCode, Integer skuStatus) {
        WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
        stockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        stockCond.setSkuCode(skuCode);
        stockCond.setSkuStatus(skuStatus);
        List<WhWmsSkuStock> skuStockList = this.getStockByCond(stockCond);
        if (EmptyUtil.isNotEmpty(skuStockList)) {
            Iterator<WhWmsSkuStock> iterator = skuStockList.iterator();
            while (iterator.hasNext()) {
                WhWmsSkuStock skuStock = iterator.next();
                if (skuStock.getAmount() > 0) continue;
                iterator.remove();
            }
        }
        return skuStockList;
    }

    private void sortPhyWhSkuStock(List<WhWmsSkuStock> skuStockList) {
        if (EmptyUtil.isEmpty(skuStockList)) {
            return;
        }
        ArrayList<String> barcodes = new ArrayList<String>();
        for (WhWmsSkuStock skuStock : skuStockList) {
            barcodes.add(skuStock.getBarCode());
        }
        final Map<String, WhWmsSkuBarcodeVO> barcodeMap = this.whWmsSkuBarcodeService.getBarcodeMap(barcodes);
        Collections.sort(skuStockList, new Comparator<WhWmsSkuStock>(){

            @Override
            public int compare(WhWmsSkuStock o1, WhWmsSkuStock o2) {
                if (o1.getBarCode().endsWith("_0000") && o2.getBarCode().endsWith("_0000")) {
                    return 0;
                }
                if (o1.getBarCode().endsWith("_0000")) {
                    return -1;
                }
                if (o2.getBarCode().endsWith("_0000")) {
                    return 1;
                }
                if (o1.getBarCode().endsWith("_0001") && o2.getBarCode().endsWith("_0001")) {
                    return 0;
                }
                if (o1.getBarCode().endsWith("_0001")) {
                    return -1;
                }
                if (o2.getBarCode().endsWith("_0001")) {
                    return 1;
                }
                WhWmsSkuBarcodeVO bc1 = (WhWmsSkuBarcodeVO)barcodeMap.get(o1.getBarCode());
                WhWmsSkuBarcodeVO bc2 = (WhWmsSkuBarcodeVO)barcodeMap.get(o2.getBarCode());
                return WhWmsSkuStockServiceImpl.this.whWmsSkuBarcodeService.compareBarCode(bc1, bc2);
            }
        });
    }

    @Override
    public boolean updateStockByCond(Integer amount, String physicalWarehouseCode, String houseType, String barcode, String shelvesCode, String skuCode, Integer skuStatus, Integer inoutType, String receiptNo, Long userId) {
        int isUpdateScm = 2;
        return this.updateStockByCond(amount, physicalWarehouseCode, houseType, barcode, shelvesCode, skuCode, skuStatus, inoutType, receiptNo, userId, null, isUpdateScm);
    }

    @Override
    @Transactional
    public void batchUpdateWhSkuStock(List<WhWmsSkuStockRecord> skuStockRecordList) {
        if (EmptyUtil.isEmpty(skuStockRecordList)) {
            return;
        }
        for (WhWmsSkuStockRecord skuStockRecord : skuStockRecordList) {
            if (NullUtil.isNull((Object)skuStockRecord.getCreateUserId())) {
                skuStockRecord.setCreateUserId(1L);
            }
            this.updateStockByCond(skuStockRecord.getQuantity(), skuStockRecord.getPhysicalWarehouseCode(), skuStockRecord.getHouseType(), skuStockRecord.getBarCode(), skuStockRecord.getShelvesCode(), skuStockRecord.getSkuCode(), skuStockRecord.getSkuStatus(), skuStockRecord.getInOutType(), skuStockRecord.getReceiptNo(), skuStockRecord.getCreateUserId(), skuStockRecord.getMemo(), skuStockRecord.getIsUpdateScm(), false);
        }
        for (List partList : ListUtils.partition(skuStockRecordList, (int)1000)) {
            this.whWmsSkuStockRecordMapper.batchInsert(partList);
        }
    }

    private boolean updateStockByCond(Integer amount, String physicalWarehouseCode, String houseType, String barcode, String shelvesCode, String skuCode, Integer skuStatus, Integer inoutType, String receiptNo, Long userId, String memo, Integer isUpdateScm, boolean recordLog) {
        if (amount == null || physicalWarehouseCode == null || houseType == null || barcode == null || shelvesCode == null || skuCode == null || skuStatus == null || inoutType == null || receiptNo == null || userId == null) {
            throw new WarehouseException("WH0002", "NullPointerException");
        }
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setHouseType(houseType);
        cond.setBarCode(barcode);
        cond.setShelvesCode(shelvesCode);
        cond.setSkuCode(skuCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsSkuStock> list = this.mapper.getByCond(cond);
        WhWmsSkuStock sk = null;
        if (null != list && list.size() == 1) {
            sk = list.get(0);
            if (sk.getAmount() + amount < 0) {
                throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + physicalWarehouseCode + "][" + shelvesCode + "][" + barcode + "][" + WhCommand.getSkuStatusName(skuStatus) + "][" + sk.getAmount() + "<" + -amount.intValue() + "]\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u53ef\u4ee5\u51fa\u5e93");
            }
            int i = 0;
            boolean isTurn = true;
            do {
                int updateCount = this.mapper.updateStockByPrimaryKey(amount, sk.getVersion(), sk.getId());
                if (i >= 3 || updateCount > 0) {
                    isTurn = false;
                } else {
                    List<WhWmsSkuStock> newList = this.mapper.getByCond(cond);
                    if (newList != null && newList.size() > 0) {
                        sk = newList.get(0);
                    }
                }
                ++i;
            } while (isTurn);
            if (i > 3) {
                throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + physicalWarehouseCode + "][" + shelvesCode + "][" + barcode + "][" + WhCommand.getSkuStatusName(skuStatus) + "][" + amount + "]\u5e93\u5b58\u4fee\u6539\u5931\u8d25");
            }
        } else {
            if (amount < 0) {
                throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + physicalWarehouseCode + "][" + shelvesCode + "][" + barcode + "][" + WhCommand.getSkuStatusName(skuStatus) + "][" + -amount.intValue() + "]\u8fd8\u6ca1\u6709\u5e93\u5b58\u8bb0\u5f55\u4e0d\u53ef\u4ee5\u51fa\u5e93");
            }
            WhWmsSkuStockVO stockVO = new WhWmsSkuStockVO();
            stockVO.setBarCode(barcode);
            stockVO.setSkuCode(skuCode);
            stockVO.setVersion(1);
            stockVO.setAmount(amount);
            stockVO.setSkuStatus(skuStatus);
            stockVO.setPhysicalWarehouseCode(physicalWarehouseCode);
            stockVO.setHouseType(houseType);
            stockVO.setShelvesCode(shelvesCode.toUpperCase());
            this.mapper.insert(stockVO);
        }
        if (recordLog) {
            WhWmsSkuStockRecord whWmsSkuStockRecord = new WhWmsSkuStockRecord();
            whWmsSkuStockRecord.setPhysicalWarehouseCode(physicalWarehouseCode);
            whWmsSkuStockRecord.setHouseType(houseType);
            whWmsSkuStockRecord.setSkuCode(skuCode);
            whWmsSkuStockRecord.setBarCode(barcode);
            whWmsSkuStockRecord.setCreateTime(Calendar.getInstance().getTime());
            whWmsSkuStockRecord.setCreateUserId(userId);
            whWmsSkuStockRecord.setInOutType(inoutType);
            whWmsSkuStockRecord.setQuantity(amount);
            whWmsSkuStockRecord.setReceiptNo(receiptNo);
            whWmsSkuStockRecord.setSkuStatus(skuStatus);
            whWmsSkuStockRecord.setShelvesCode(shelvesCode);
            whWmsSkuStockRecord.setMemo(memo);
            whWmsSkuStockRecord.setIsUpdateScm(isUpdateScm);
            if (sk != null) {
                whWmsSkuStockRecord.setOldQuantity(sk.getAmount());
            } else {
                whWmsSkuStockRecord.setOldQuantity(0);
            }
            this.whWmsSkuStockRecordMapper.insert(whWmsSkuStockRecord);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean convertBarcodeUpdateSkuStock(WhWmsSkuStockVO vo) {
        boolean result = this.updateStockByCond(-vo.getAmount().intValue(), vo.getPhysicalWarehouseCode(), vo.getHouseType(), vo.getBarCode(), vo.getShelvesCode(), vo.getSkuCode(), vo.getSkuStatus(), WhInvRcd.TYPE_BARCODE_CONVERT_OUT, vo.getBarCode() + "_" + vo.getAmount() + "_" + DateUtil.format((Date)DateUtil.getNow(), (String)"yyyyMMddHHmmss"), vo.getCreateOperatorId(), "", 2);
        if (result) {
            result = this.updateStockByCond(vo.getAmount(), vo.getPhysicalWarehouseCode(), vo.getHouseType(), vo.getTargetBarcode(), vo.getShelvesCode(), vo.getSkuCode(), vo.getSkuStatus(), WhInvRcd.TYPE_BARCODE_CONVERT_IN, vo.getTargetBarcode() + "_" + vo.getAmount() + "_" + DateUtil.format((Date)DateUtil.getNow(), (String)"yyyyMMddHHmmss"), vo.getCreateOperatorId(), "", 2);
        }
        return result;
    }

    @Override
    public List<WhWmsSkuStockVO> getWmsSkuStockByCond(WhWmsSkuStockVO cond) {
        List<WhWmsSkuStock> list = this.mapper.getByCond(cond);
        List voList = BeanUtil.buildListFrom(list, WhWmsSkuStockVO.class);
        return voList;
    }

    @Override
    public List<WhWmsSkuStockVO> getWmsSkuStockByVO(WhWmsSkuStockVO cond) {
        List<WhWmsSkuStock> list = this.mapper.getByVO(cond);
        List voList = BeanUtil.buildListFrom(list, WhWmsSkuStockVO.class);
        return voList;
    }

    @Override
    public List<WhWmsSkuStockVO> findWmsSkuStockByPhysicalWarehouseCodeAndStatus(String physicalWarehouseCode, Integer skuStatus, String skuCode) {
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        cond.setSkuCode(skuCode);
        return this.getWmsSkuStockByCond(cond);
    }

    @Override
    public int sumSkuQuantity(List<WhWmsSkuStockVO> vos) {
        int result = 0;
        for (WhWmsSkuStockVO vo : vos) {
            result += vo.getAmount().intValue();
        }
        return result;
    }

    @Override
    public List<WhWmsSkuStockVO> findWmsSkuAvailableAccount(WhWmsSkuStockVO vo) {
        return this.findWmsSkuAvailableAccount(vo, false);
    }

    @Override
    public List<WhWmsSkuStockVO> findWmsSkuAvailableAccount(WhWmsSkuStockVO vo, boolean gtZero) {
        return this.mapper.findWmsSkuAvailableAccount(vo, gtZero);
    }

    @Override
    public List<WhWmsSkuStockVO> findWmsSkuAvailableAccountWithPreOccupy(WhWmsSkuStockVO vos, boolean gtZero) {
        return this.mapper.findWmsSkuAvailableAccountWithPreOccupy(vos, gtZero);
    }

    @Override
    public List<WhWmsSkuStock> selectByExample(WhWmsSkuStockExample example) {
        return this.mapper.selectByExample(example);
    }

    @Override
    public List<WhWmsSkuStock> getGroupByShelvesByCond(WhWmsSkuStockVO vo) {
        return this.mapper.getGroupByShelvesByCond(vo);
    }

    @Override
    public List<WhWmsSkuStock> getStockByCond(WhWmsSkuStockVO vo) {
        return this.mapper.getStockByCond(vo);
    }

    @Override
    public List<WhWmsSkuStockVO> getWmsSkuStocksByCond(WhWmsSkuStockVO cond) {
        List<WhWmsSkuStockVO> voList = this.mapper.getSkuStocksByCond(cond);
        return voList;
    }

    @Override
    public List<WhWmsSkuStockVO> getWmsSkuStocksByShelvesCond(WhWmsSkuStockVO cond) {
        List<WhWmsSkuStockVO> voList = this.mapper.getSkuStocksByShelvesCond(cond);
        return voList;
    }

    @Override
    public List<WhWmsSkuStockVO> getWmsSkuStocksByCondForReport(WhWmsSkuStockVO cond) {
        List<WhWmsSkuStockVO> voList = this.mapper.getSkuStocksByCondForReport(cond);
        return voList;
    }

    @Override
    public Pagination<WhWmsSkuStockVO> getWmsSkuStocksByShelvesCondForReport(WhWmsSkuStockVO cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        List<WhWmsSkuStockVO> voList = this.listSkuStocksByCond(cond);
        Integer counts = this.mapper.countSkuStocksByShelvesCondForReport(cond);
        page.setRecord(counts);
        page.setResultList(voList);
        return page;
    }

    @Override
    public List<WhWmsSkuStockVO> getSkuStocksByShelvesCondForReport(WhWmsSkuStockVO cond) {
        return this.mapper.getSkuStocksByShelvesCondForReport(cond);
    }

    @Override
    public List<WhWmsSkuStockVO> listSkuStocksByCond(WhWmsSkuStockVO cond) {
        return this.mapper.getSkuStocksByShelvesCondForReport(cond);
    }

    @Override
    public WhWmsSkuStockVO countSkuAmountBySkuStatus(WhWmsSkuStockVO cond) {
        return this.mapper.countSkuAmountBySkuStatus(cond);
    }

    @Override
    public List<WhWmsSkuStockRecordVO> findWhWmsStockRecord(WhWmsSkuStockRecordCond cond) {
        return this.whWmsSkuStockRecordMapper.findWhWmsStockRecordByCond(cond);
    }

    @Override
    public Pagination<PhyWhSkuStockRcdVO> findPhyWhSkuStockRcdByCond(PhyWhSkuStockRcdCond cond) {
        Pagination pagination = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int total = this.whWmsSkuStockRecordMapper.countPhyWhSkuStockRcdByCond(cond);
        pagination.setRecord(Integer.valueOf(total));
        if (!NumberUtil.isNullOrZero((Number)total)) {
            List<PhyWhSkuStockRcdVO> rcdList = this.whWmsSkuStockRecordMapper.findPhyWhSkuStockRcdByCond(cond);
            if (EmptyUtil.isNotEmpty(rcdList)) {
                ArrayList<String> commandCodes = new ArrayList<String>();
                for (PhyWhSkuStockRcdVO rcd : rcdList) {
                    if (!this.isCommandCode(rcd.getReceiptNo())) continue;
                    commandCodes.add(rcd.getReceiptNo());
                }
                Map<String, String> referenceCodeMap = this.whCommandService.findReferenceCodesByCommdCodes(commandCodes);
                for (PhyWhSkuStockRcdVO rcd : rcdList) {
                    if (this.isCommandCode(rcd.getReceiptNo())) {
                        rcd.setReferenceCode(referenceCodeMap.get(rcd.getReceiptNo()));
                        continue;
                    }
                    rcd.setReferenceCode(rcd.getReceiptNo());
                }
            }
            pagination.setResultList(rcdList);
        }
        return pagination;
    }

    private boolean isCommandCode(String commandLike) {
        return EmptyUtil.isNotEmpty((String)commandLike) && commandLike.startsWith("CMD");
    }

    @Override
    public int findWhWmsStockRecordCount(WhWmsSkuStockRecordCond whWmsSkuStockRecordCond) {
        return this.whWmsSkuStockRecordMapper.countWhWmsStockRecord(whWmsSkuStockRecordCond);
    }

    @Override
    public WhPhysicalWarehouse computeDispatchPhysicalWarehouse(String dispatchWhCode, Map<String, Integer> skuQuantityMap, Long targetDistrict) {
        WhWarehouse warehouse = this.whInfoService.findWarehouseByCode(dispatchWhCode);
        if (NullUtil.isNull((Object)warehouse)) {
            throw new WarehouseException("WH0001", String.format("[%s]\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", dispatchWhCode));
        }
        if (NullUtil.isNull((Object)warehouse.getCommodityStatus())) {
            throw new WarehouseException("WH0001", String.format("[%s]\u903b\u8f91\u4ed3\u5546\u54c1\u72b6\u6001\u672a\u8bbe\u7f6e", dispatchWhCode));
        }
        List<WhPhysicalWarehouseVO> phyWhList = this.whInfoService.findPhysicalWarehouseByWarehouseCode(dispatchWhCode);
        if (EmptyUtil.isNotEmpty(phyWhList)) {
            ArrayList<String> phyWhCodeList = new ArrayList<String>();
            HashMap<String, WhPhysicalWarehouseVO> phyWhMap = new HashMap<String, WhPhysicalWarehouseVO>();
            for (WhPhysicalWarehouseVO phyWh : phyWhList) {
                phyWhCodeList.add(phyWh.getCode());
                phyWhMap.put(phyWh.getCode(), phyWh);
            }
            List<WhDistrictPhysicalWarehouseVO> sortPhyWhList = this.whInfoService.findDistrictPyWarehouseByCodeAndDistrictId(phyWhCodeList, targetDistrict);
            List<String> skuCodes = Arrays.asList(skuQuantityMap.keySet().toArray(new String[skuQuantityMap.size()]));
            PhyWhStockCond cond = new PhyWhStockCond();
            cond.setSkuCodes(skuCodes);
            cond.setSkuStatus(warehouse.getCommodityStatus());
            for (WhDistrictPhysicalWarehouseVO phyWh : sortPhyWhList) {
                cond.setPhysicalWarehouseCode(phyWh.getPhysicalWarehouseCode());
                List<PhyWhStockVO> stockList = this.findPhyWhStockByCond(cond);
                if (!this.isStockEnough(stockList, skuQuantityMap)) continue;
                return (WhPhysicalWarehouse)phyWhMap.get(phyWh.getPhysicalWarehouseCode());
            }
        }
        return null;
    }

    private boolean isStockEnough(List<PhyWhStockVO> stockList, Map<String, Integer> skuQuantityMap) {
        Map<String, Integer> phyWhSkuStockMap = this.singlePhyWhSingleSkuStatusStockToMap(stockList);
        boolean enough = true;
        for (Map.Entry<String, Integer> needEntry : skuQuantityMap.entrySet()) {
            Integer phyWhCanUseQuantity = phyWhSkuStockMap.get(needEntry.getKey());
            if (NullUtil.isNull((Object)phyWhCanUseQuantity)) {
                phyWhCanUseQuantity = 0;
            }
            if (phyWhCanUseQuantity >= needEntry.getValue()) continue;
            enough = false;
            break;
        }
        return enough;
    }

    private Map<String, Integer> singlePhyWhSingleSkuStatusStockToMap(List<PhyWhStockVO> stockList) {
        HashMap<String, Integer> phyWhSkuStockMap = new HashMap<String, Integer>();
        if (EmptyUtil.isNotEmpty(stockList)) {
            for (PhyWhStockVO stock : stockList) {
                phyWhSkuStockMap.put(stock.getSkuCode(), stock.getCanUseQuantity());
            }
        }
        return phyWhSkuStockMap;
    }

    @Override
    public List<WhWmsSkuStockVO> listExpiryDateSku(WhWmsSkuStockVO cond) {
        return this.mapper.listExpiryDateSku(cond);
    }

    @Override
    public List<WhWmsSkuStockVO> listExpiryDateSkuForCheckRule(WhWmsSkuStockVO cond) {
        return this.mapper.listExpiryDateSkuForCheckRule(cond);
    }

    @Override
    public List<WhWmsSkuStockDiffVO> findWhWmsSkuStockDiffList() {
        return this.mapper.findWhWmsSkuStockDiffList();
    }

    @Override
    public List<PhyWhStockVO> findPhyWhStockByCond(PhyWhStockCond cond) {
        return this.mapper.findPhyWhStockByCond(cond);
    }

    @Override
    public List<PhyWhStockVO> findPhyWhSkuTotalQuantityByCond(PhyWhStockCond cond) {
        return this.mapper.findPhyWhSkuTotalQuantityByCond(cond);
    }

    @Override
    public List<WhGjStockVO> findWhGjStock() {
        return this.mapper.findWhGjStock();
    }

    @Override
    public List<WhGjStockVO> findWhGjStockByLimit(int pageSize, int pageNum) {
        return this.mapper.findWhGjStockByLimit(pageSize, pageNum);
    }
}

