/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuBarcodeCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuBarcodeMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcodeExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuBarcodeVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

@Service(value="whWmsSkuBarcodeService")
public class WhWmsSkuBarcodeServiceImpl
implements WhWmsSkuBarcodeService {
    @Autowired
    private WhWmsSkuBarcodeMapper mapper;

    @Override
    public WhWmsSkuBarcodeVO create(WhWmsSkuBarcodeVO vo) {
        WhWmsSkuBarcode barcode = (WhWmsSkuBarcode)BeanUtil.buildFrom((Object)vo, WhWmsSkuBarcode.class);
        this.mapper.insert(barcode);
        vo.setId(barcode.getId());
        return vo;
    }

    @Override
    public Boolean update(WhWmsSkuBarcodeVO vo) {
        return this.mapper.updateByPrimaryKeySelective((WhWmsSkuBarcode)BeanUtil.buildFrom((Object)vo, WhWmsSkuBarcode.class)) != 0;
    }

    @Override
    public WhWmsSkuBarcodeVO findById(Long id) {
        WhWmsSkuBarcode barcode = this.mapper.selectByPrimaryKey(id);
        if (barcode != null) {
            return (WhWmsSkuBarcodeVO)BeanUtil.buildFrom((Object)barcode, WhWmsSkuBarcodeVO.class);
        }
        return null;
    }

    @Override
    public WhWmsSkuBarcode findMaxBatchNo(String skuCode, String date, String prodDate) {
        return this.mapper.findMaxBatchNo(skuCode, date, prodDate);
    }

    @Override
    public WhWmsSkuBarcode findMaxBatchNoByCond(WhWmsSkuBarcodeCond cond) {
        return this.mapper.findMaxBatchNoByCond(cond);
    }

    @Override
    public WhWmsSkuBarcodeVO findSkuInfoBySkuCode(String skuCode) {
        WhWmsSkuBarcodeCond cond = new WhWmsSkuBarcodeCond();
        cond.setSkuCode(skuCode);
        List<WhWmsSkuBarcodeVO> wmsSkuBarcodeVOs = this.mapper.findSkuInfoBySkuCode(cond);
        if (CollectionUtils.isNotEmpty(wmsSkuBarcodeVOs)) {
            return wmsSkuBarcodeVOs.get(0);
        }
        return null;
    }

    @Override
    public Integer countBatchBySkuCode(String skuCode) {
        WhWmsSkuBarcodeExample example = new WhWmsSkuBarcodeExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        return this.mapper.countByExample(example);
    }

    @Override
    public Integer countBatchByReferenceCode(String whCmdCode, String skuCode, String referenceCode) {
        return this.mapper.countBatchByReferenceCode(whCmdCode, skuCode, referenceCode);
    }

    @Override
    public List<WhWmsSkuBarcodeVO> getWmsSkuBarcodeByCond(WhWmsSkuBarcodeVO vo) {
        List<WhWmsSkuBarcode> list = this.mapper.getByCond(vo);
        List voList = BeanUtil.buildListFrom(list, WhWmsSkuBarcodeVO.class);
        return voList;
    }

    @Override
    public Map<String, WhWmsSkuBarcodeVO> getBarcodeMap(List<String> barcodes) {
        HashMap<String, WhWmsSkuBarcodeVO> barcodeMap = new HashMap<String, WhWmsSkuBarcodeVO>();
        if (EmptyUtil.isNotEmpty(barcodes)) {
            WhWmsSkuBarcodeVO barcodeCond = new WhWmsSkuBarcodeVO();
            barcodeCond.setBarCodeList(barcodes);
            List<WhWmsSkuBarcodeVO> barcodeList = this.getWmsSkuBarcodeByCond(barcodeCond);
            if (EmptyUtil.isNotEmpty(barcodeList)) {
                for (WhWmsSkuBarcodeVO barcodeVO : barcodeList) {
                    barcodeMap.put(barcodeVO.getBarCode(), barcodeVO);
                }
            }
        }
        return barcodeMap;
    }

    @Override
    public List<String> findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(String skuCode) {
        ArrayList r = new ArrayList();
        for (WhWmsSkuBarcode whWmsSkuBarcode : this.findBarCodesEntityConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode)) {
            r.add(whWmsSkuBarcode.getBarCode());
        }
        return CollectionUtils.isEmpty(r) ? Collections.emptyList() : r;
    }

    @Override
    public List<String> findBarCodesConditionBySkuCodeAndSortByExpiredAsc(String skuCode) {
        ArrayList r = new ArrayList();
        for (WhWmsSkuBarcode whWmsSkuBarcode : this.findBarCodesEntityConditionBySkuCodeAndSortByExpiredAsc(skuCode)) {
            r.add(whWmsSkuBarcode.getBarCode());
        }
        return CollectionUtils.isEmpty(r) ? Collections.emptyList() : r;
    }

    @Override
    public List<String> findBarCodesConditionBySkuCodeAndNullExpired(String skuCode) {
        ArrayList r = new ArrayList();
        for (WhWmsSkuBarcode whWmsSkuBarcode : this.findBarCodesEntityConditionBySkuCodeAndNullExpired(skuCode)) {
            r.add(whWmsSkuBarcode.getBarCode());
        }
        return CollectionUtils.isEmpty(r) ? Collections.emptyList() : r;
    }

    @Override
    public List<WhWmsSkuBarcode> findBarCodesForPickSkuStock(String skuCode) {
        return this.findBarCodesForPickSkuStock(Collections.singletonList(skuCode));
    }

    @Override
    public List<WhWmsSkuBarcode> findBarCodesForPickSkuStock(List<String> skuCodes) {
        return this.mapper.findBarCodesForPickSkuStock(skuCodes);
    }

    @Override
    public List<WhWmsSkuBarcode> findBarcodesForAltOrPcsRtnConnect(List<String> skuCodes, boolean allowExpire) {
        return this.mapper.findBarcodesForAltOrPcsRtnConnect(skuCodes, allowExpire);
    }

    @Override
    public List<WhWmsSkuBarcode> findBarCodesEntityConditionBySkuCodeAndUnexpiredSortByExpiredAsc(String skuCode) {
        ArrayList r = new ArrayList();
        WhWmsSkuBarcodeExample example = new WhWmsSkuBarcodeExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode).andExpirationDateGreaterThanOrEqualTo(DateUtil.getNow());
        example.setOrderByClause(" EXPIRATION_DATE ASC,PROD_DATE ASC");
        List<WhWmsSkuBarcode> list = this.mapper.selectByExample(example);
        return CollectionUtils.isEmpty(list) ? Collections.emptyList() : list;
    }

    @Override
    public WhWmsSkuBarcode findMinProdOrExpiryDateByBarCodes(List<String> barCodes) {
        return this.mapper.findMinProdOrExpiryDateByBarCodes(barCodes);
    }

    @Override
    public List<WhWmsSkuBarcode> findBarCodesEntityConditionBySkuCodeAndSortByExpiredAsc(String skuCode) {
        ArrayList r = new ArrayList();
        WhWmsSkuBarcodeExample example = new WhWmsSkuBarcodeExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        example.setOrderByClause(" EXPIRATION_DATE ASC,PROD_DATE ASC");
        List<WhWmsSkuBarcode> list = this.mapper.selectByExample(example);
        return CollectionUtils.isEmpty(list) ? Collections.emptyList() : list;
    }

    @Override
    public List<WhWmsSkuBarcode> findBarCodesEntityConditionBySkuCodeAndNullExpired(String skuCode) {
        ArrayList r = new ArrayList();
        WhWmsSkuBarcodeExample example = new WhWmsSkuBarcodeExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode).andExpirationDateIsNull();
        List<WhWmsSkuBarcode> list = this.mapper.selectByExample(example);
        return CollectionUtils.isEmpty(list) ? Collections.emptyList() : list;
    }

    @Override
    public Integer findSkuShelfLifeBySkuCode(String skuCode) {
        return this.mapper.findSkuShelfLifeBySkuCode(skuCode);
    }

    @Override
    public List<WhWmsSkuBarcodeVO> findExpiryDateSkuInfo(WhWmsSkuBarcodeCond cond) {
        return this.mapper.findExpiryDateSkuInfo(cond);
    }

    @Override
    public Pagination<WhWmsSkuBarcodeVO> findExpiryDateSkuInfoByCondPage(WhWmsSkuBarcodeCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.findExpiryDateSkuInfoCount(cond);
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return page;
        }
        List<WhWmsSkuBarcodeVO> expiryDateSkuInfos = this.mapper.findExpiryDateSkuInfo(cond);
        page.setResultList(expiryDateSkuInfos);
        return page;
    }

    @Override
    public int compareBarCode(WhWmsSkuBarcode barcode1, WhWmsSkuBarcode barcode2) {
        int result = this.compareBarcodeDate(barcode1.getExpirationDate(), barcode2.getExpirationDate());
        if (result == 0 && (result = this.compareBarcodeDate(barcode1.getProdDate(), barcode2.getProdDate())) == 0) {
            result = this.compareBarcodeDate(barcode1.getFirstInDate(), barcode2.getFirstInDate());
        }
        return result;
    }

    private int compareBarcodeDate(Date o1, Date o2) {
        Date today = DateUtil.dayStart((Date)DateUtil.getNow());
        if (NullUtil.isNull((Object)o1)) {
            o1 = today;
        }
        if (NullUtil.isNull((Object)o2)) {
            o2 = today;
        }
        return o1.compareTo(o2);
    }

    public int findExpiryDateSkuInfoCount(WhWmsSkuBarcodeCond cond) {
        return this.mapper.findExpiryDateSkuInfoCount(cond);
    }

    @Override
    public boolean modifyExpiryDate(WhWmsSkuBarcode cond) {
        return this.mapper.updateExpiryDateByPrimaryKey(cond) > 0;
    }
}

