/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsShelvesSkuInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuPickShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsShelvesSkuInfoMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuPickShelvesMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsShelvesSkuInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsShelvesSkuInfoExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuPickShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuPickShelvesExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsShelvesSkuInfoService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsShelvesSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuPickShelvesVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsShelvesSkuInfoService")
public class WhWmsShelvesSkuInfoServiceImpl
implements WhWmsShelvesSkuInfoService {
    @Autowired
    private WhWmsShelvesSkuInfoMapper whShelvesSkuInfoMapper;
    @Autowired
    private WhWmsSkuPickShelvesMapper whWmsSkuPickShelvesMapper;

    @Override
    public List<WhWmsShelvesSkuInfoVO> getSkuInfoByCond(WhWmsShelvesSkuInfoCond cond) {
        List<WhWmsShelvesSkuInfoVO> shelvesSkuInfoVOs = this.whShelvesSkuInfoMapper.getSkuInfoByCond(cond);
        if (CollectionUtils.isNotEmpty(shelvesSkuInfoVOs) && cond.isFetchSkuPickShelvesFlag()) {
            for (WhWmsShelvesSkuInfoVO skuInfoVO : shelvesSkuInfoVOs) {
                skuInfoVO.setWhWmsSkuPickShelves(this.listSkuPickShelvesBySkuAndPhyCode(skuInfoVO.getSkuCode(), cond.getPhysicalWarehouseCode()));
            }
        }
        return shelvesSkuInfoVOs;
    }

    private List<WhWmsSkuPickShelves> listSkuPickShelvesBySkuAndPhyCode(String skuCode, String physicalWarehouseCode) {
        WhWmsSkuPickShelvesCond cond = new WhWmsSkuPickShelvesCond();
        cond.setSkuCode(skuCode);
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        return this.listSkuPickShelvesByCond(cond);
    }

    @Override
    public List<WhWmsSkuPickShelves> listSkuPickShelvesByCond(WhWmsSkuPickShelvesCond cond) {
        WhWmsSkuPickShelvesExample example = this.buildWhWmsSkuPickShelvesExample(cond);
        return this.whWmsSkuPickShelvesMapper.selectByExample(example);
    }

    @Override
    public List<WhWmsSkuPickShelves> listSkuPickShelvesBySkuCode(String skuCode) {
        WhWmsSkuPickShelvesCond cond = new WhWmsSkuPickShelvesCond();
        Validation.paramNotNull((Object)skuCode, (String)"skuCode\u4e3a\u7a7a!");
        cond.setSkuCode(skuCode);
        return this.listSkuPickShelvesByCond(cond);
    }

    @Override
    public List<WhWmsSkuPickShelvesVO> listSkuPickShelvesVOBySkuCode(String skuCode) {
        WhWmsSkuPickShelvesCond cond = new WhWmsSkuPickShelvesCond();
        cond.setSkuCode(skuCode);
        return this.listSkuPickShelvesVOByCond(cond);
    }

    @Override
    public List<WhWmsSkuPickShelvesVO> listSkuPickShelvesVOByCond(WhWmsSkuPickShelvesCond cond) {
        return this.whWmsSkuPickShelvesMapper.listSkuPickShelvesVOByCond(cond);
    }

    private WhWmsSkuPickShelvesExample buildWhWmsSkuPickShelvesExample(WhWmsSkuPickShelvesCond cond) {
        WhWmsSkuPickShelvesExample example = new WhWmsSkuPickShelvesExample();
        WhWmsSkuPickShelvesExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        } else if (CollectionUtils.isNotEmpty(cond.getSkuCodes())) {
            criteria.andSkuCodeIn((List)cond.getSkuCodes());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getPhysicalWarehouseCode())) {
            criteria.andPhysicalWarehouseCodeEqualTo(cond.getPhysicalWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getShelvesCode())) {
            criteria.andShelvesCodeEqualTo(cond.getShelvesCode());
        } else if (EmptyUtil.isNotEmpty((String)cond.getShelvesCodeLike())) {
            criteria.andShelvesCodeLike(SQLUtils.allLike((String)cond.getShelvesCodeLike()));
        } else if (CollectionUtils.isNotEmpty(cond.getShelvesCodes())) {
            criteria.andShelvesCodeIn((List)cond.getShelvesCodes());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateTimeStart())) {
            criteria.andCreateTimeGreaterThanOrEqualTo(cond.getCreateTimeStart());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateTimeEnd())) {
            criteria.andCreateTimeLessThanOrEqualTo(cond.getCreateTimeEnd());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getOrderBy())) {
            example.setOrderByClause(cond.getOrderBy());
        }
        return example;
    }

    @Override
    @Transactional
    public Boolean newSkuInfo(WhWmsShelvesSkuInfo skuInfo) {
        WhWmsShelvesSkuInfo sku = this.getSkuInfoByCode(skuInfo.getSkuCode());
        if (EmptyUtil.isNotEmpty((Object)sku)) {
            throw new WarehouseException("", "[" + skuInfo.getSkuCode() + "]the sku is already exist");
        }
        int result = this.whShelvesSkuInfoMapper.insert(skuInfo);
        if (result <= 0) {
            throw new WarehouseException("", "insert data error!");
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean newWhShelvesSkuInfoVO(WhWmsShelvesSkuInfoVO skuInfoVO) {
        WhWmsShelvesSkuInfo skuInfo = (WhWmsShelvesSkuInfo)BeanUtil.buildFrom((Object)skuInfoVO, WhWmsShelvesSkuInfo.class);
        boolean result = this.newSkuInfo(skuInfo);
        if (result) {
            skuInfoVO.setId(skuInfo.getId());
            if (CollectionUtils.isNotEmpty(skuInfoVO.getWhWmsSkuPickShelves())) {
                this.batchCreateSkuPickShelves(skuInfoVO.getWhWmsSkuPickShelves(), skuInfo.getSkuCode());
            }
        }
        return result;
    }

    @Override
    public Boolean delSkuPickShelvesBySkuCode(String skuCode) {
        WhWmsSkuPickShelvesCond cond = new WhWmsSkuPickShelvesCond();
        cond.setSkuCode(skuCode);
        return this.delSkuPickShelvesByCond(cond);
    }

    @Override
    @Transactional
    public Boolean delSkuPickShelvesByCond(WhWmsSkuPickShelvesCond cond) {
        WhWmsSkuPickShelvesExample example = this.buildWhWmsSkuPickShelvesExample(cond);
        return this.whWmsSkuPickShelvesMapper.deleteByExample(example) >= 0;
    }

    @Override
    @Transactional
    public Boolean createSkuPickShelves(WhWmsSkuPickShelves skuPickShelves) {
        return this.whWmsSkuPickShelvesMapper.insert(skuPickShelves) > 0;
    }

    @Override
    @Transactional
    public Boolean batchCreateSkuPickShelves(List<WhWmsSkuPickShelves> skuPickShelvesList, String skuCode) {
        for (WhWmsSkuPickShelves skuPickShelve : skuPickShelvesList) {
            skuPickShelve.setSkuCode(skuCode);
            skuPickShelve.setCreateTime(DateUtil.getNow());
            if (EmptyUtil.isEmpty((Object)skuPickShelve.getSort())) {
                skuPickShelve.setSort(1);
            }
            this.createSkuPickShelves(skuPickShelve);
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateSkuInfo(WhWmsShelvesSkuInfo skuInfo) {
        int result;
        if (NumberUtil.isNullOrZero((Number)skuInfo.getId()) || EmptyUtil.isEmpty((String)skuInfo.getSkuCode())) {
            throw new WarehouseException("", "null param!");
        }
        if (skuInfo.getSkuCode() == "") {
            skuInfo.setSkuCode(null);
        }
        if ((result = this.whShelvesSkuInfoMapper.updateByPrimaryKey(skuInfo)) <= 0) {
            throw new WarehouseException("", "[" + skuInfo.getSkuCode() + "]update data error!");
        }
        return true;
    }

    @Override
    public Boolean updateWhShelvesSkuInfoVO(WhWmsShelvesSkuInfoVO skuInfoVO) {
        boolean result = this.updateSkuInfo((WhWmsShelvesSkuInfo)BeanUtil.buildFrom((Object)skuInfoVO, WhWmsShelvesSkuInfo.class));
        if (result && CollectionUtils.isNotEmpty(skuInfoVO.getWhWmsSkuPickShelves()) && this.delSkuPickShelvesBySkuCode(skuInfoVO.getSkuCode()).booleanValue()) {
            this.batchCreateSkuPickShelves(skuInfoVO.getWhWmsSkuPickShelves(), skuInfoVO.getSkuCode());
        }
        return true;
    }

    @Override
    public Boolean saveOrUpdateWhWmsSkuPickShelves(List<WhWmsSkuPickShelves> whWmsSkuPickShelves) {
        String skuCode = whWmsSkuPickShelves.get(0).getSkuCode();
        if (this.delSkuPickShelvesBySkuCode(skuCode).booleanValue()) {
            this.batchCreateSkuPickShelves(whWmsSkuPickShelves, skuCode);
        }
        return true;
    }

    @Override
    public WhWmsShelvesSkuInfo getSkuInfoByCode(String code) {
        WhWmsShelvesSkuInfoExample example = new WhWmsShelvesSkuInfoExample();
        example.createCriteria().andSkuCodeEqualTo(code);
        List<WhWmsShelvesSkuInfo> list = this.whShelvesSkuInfoMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public WhWmsShelvesSkuInfoVO getSkuInfoVOBySkuCode(String skuCode, boolean fetchPickShelve) {
        List<WhWmsShelvesSkuInfoVO> shelvesSkuInfoVOs = this.whShelvesSkuInfoMapper.getSkuInfoVOBySkuCode(skuCode);
        if (CollectionUtils.isEmpty(shelvesSkuInfoVOs)) {
            return null;
        }
        WhWmsShelvesSkuInfoVO shelvesSkuInfoVO = shelvesSkuInfoVOs.get(0);
        if (fetchPickShelve) {
            shelvesSkuInfoVO.setWhWmsSkuPickShelvesVO(this.listSkuPickShelvesVOBySkuCode(shelvesSkuInfoVO.getSkuCode()));
        }
        return shelvesSkuInfoVO;
    }

    @Override
    public List<WhWmsShelvesSkuInfo> getSkuInfoLikeCode(String codeLike) {
        return this.whShelvesSkuInfoMapper.getSkuInfoLikeCode(codeLike);
    }
}

