/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuStockMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsWarehouseAreaMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReportService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="whWmsReportService")
public class WhWmsReportServiceImpl
implements WhWmsReportService {
    @Autowired
    private WhWmsSkuStockMapper skuStockMapper;
    @Autowired
    private WhWmsWarehouseAreaMapper whWmsWarehouseAreaMapper;

    @Override
    public List<WhWmsSkuStockVO> getStockByWarehouseCode(String warehouseCode) {
        List<WhWmsSkuStockVO> whWmsSkuStockVOList = this.skuStockMapper.getStockByWarehouseCode(warehouseCode);
        List<WhWmsWarehouseArea> whWmsWarehouseAreaList = this.whWmsWarehouseAreaMapper.getAll();
        HashMap<String, String> map = new HashMap<String, String>();
        if (whWmsWarehouseAreaList != null && whWmsWarehouseAreaList.size() > 0) {
            for (WhWmsWarehouseArea whWmsWarehouseArea : whWmsWarehouseAreaList) {
                map.put(whWmsWarehouseArea.getHouseType(), whWmsWarehouseArea.getHouseTypeName());
            }
        }
        if (whWmsSkuStockVOList != null && whWmsSkuStockVOList.size() > 0) {
            for (WhWmsSkuStockVO vo : whWmsSkuStockVOList) {
                vo.setHouseTypeName((String)map.get(vo.getHouseType()));
            }
        }
        return whWmsSkuStockVOList;
    }

    @Override
    public Map<String, Object> getStockCountByWarehouseCode(String warehouseCode) {
        return this.skuStockMapper.getStockCountByWarehouseCode(warehouseCode);
    }

    @Override
    public List<WhWmsSkuStockVO> getShelvesStockByWarehouseCode(String warehouseCode) {
        List<WhWmsSkuStockVO> whWmsSkuStockVOList = this.skuStockMapper.getShelvesStockByWarehouseCode(warehouseCode);
        List<WhWmsWarehouseArea> whWmsWarehouseAreaList = this.whWmsWarehouseAreaMapper.getAll();
        HashMap<String, String> map = new HashMap<String, String>();
        if (whWmsWarehouseAreaList != null && whWmsWarehouseAreaList.size() > 0) {
            for (WhWmsWarehouseArea whWmsWarehouseArea : whWmsWarehouseAreaList) {
                map.put(whWmsWarehouseArea.getHouseType(), whWmsWarehouseArea.getHouseTypeName());
            }
        }
        if (whWmsSkuStockVOList != null && whWmsSkuStockVOList.size() > 0) {
            for (WhWmsSkuStockVO vo : whWmsSkuStockVOList) {
                vo.setHouseTypeName((String)map.get(vo.getHouseType()));
            }
        }
        return whWmsSkuStockVOList;
    }
}

