/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReplenishService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="whWmsReplenishService")
public class WhWmsReplenishServiceImpl
implements WhWmsReplenishService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

    @Override
    public List<WhWmsHouseShelvesVO> findNeedToReplenishShelves(String type, Integer shelvesType) {
        return this.findNeedToReplenishShelves(new ReplenishCond(type, shelvesType));
    }

    @Override
    public void processReplenish(WhWmsHouseShelvesVO shelvesVO) {
        if (shelvesVO.getShelvesType() == null || !shelvesVO.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)) {
            throw new WarehouseException("WH0002", "\u6682\u65f6\u53ea\u652f\u6301\u62e3\u8d27\u5e93\u4f4d\u8fd9\u4e2a\u7c7b\u578b\u7684\u5e93\u4f4d");
        }
        if (shelvesVO.getSafeAmount() == null || shelvesVO.getSafeAmount() <= 0 || shelvesVO.getMaxAmount() == null || shelvesVO.getMaxAmount() <= 0 || shelvesVO.getMaxAmount() <= shelvesVO.getSafeAmount()) {
            throw new WarehouseException("WH0002", "\u62e3\u8d27\u5e93\u4f4d\u6700\u5927\u5e93\u5b58\u5fc5\u987b\u5927\u4e8e\u5b89\u5168\u5e93\u5b58");
        }
        int need = this.sumAvailableAccountIncludeShelf(shelvesVO) - shelvesVO.getSafeAmount();
        if (need >= 0) {
            return;
        }
        List<WhWmsSkuStockVO> stocks = this.whWmsSkuStockService.findWmsSkuAvailableAccount(new StockCond(shelvesVO).toExternalStockCond());
        if (this.sumAvailableAccountExclusiveShelfAndIncludeType(stocks, shelvesVO) > 0) {
            ArrayList<String> barCodesBySku = new ArrayList<String>(this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(shelvesVO.getSkuCode()));
            ArrayList<String> _barCodesBySku = new ArrayList<String>(this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(shelvesVO.getSkuCode()));
            barCodesBySku.addAll(_barCodesBySku);
            for (String barcode : barCodesBySku) {
                boolean bl;
                if (this.sumAvailableAccountIncludeShelf(shelvesVO) - shelvesVO.getMaxAmount() >= 0) break;
                WhWmsSkuStockVO cond = new StockCond(shelvesVO).toExternalStockCond();
                cond.setBarCode(barcode);
                stocks = this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                ArrayList<WhWmsSkuStockVO> stocksWithOutSelf = new ArrayList<WhWmsSkuStockVO>();
                for (WhWmsSkuStockVO whWmsSkuStockVO : stocks) {
                    if (whWmsSkuStockVO.getShelvesCode().equals(shelvesVO.getCode())) continue;
                    stocksWithOutSelf.add(whWmsSkuStockVO);
                }
                ArrayList<WhWmsSkuStockVO> stocksTypeisHolding = new ArrayList<WhWmsSkuStockVO>();
                for (WhWmsSkuStockVO stock3 : stocksWithOutSelf) {
                    WhWmsHouseShelvesVO hs = this.whWmsHouseShelvesService.getHouseShelvesByCode(stock3.getShelvesCode());
                    if (!hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING) || stock3.getAvailableAccount() <= 0) continue;
                    stocksTypeisHolding.add(stock3);
                }
                boolean bl2 = false;
                for (WhWmsSkuStockVO stockHolding : stocksTypeisHolding) {
                    int needToMoveNum = this.sumAvailableAccountIncludeShelf(shelvesVO) - shelvesVO.getMaxAmount();
                    if (needToMoveNum < 0) {
                        int quantity = (needToMoveNum = 0 - needToMoveNum) <= stockHolding.getAvailableAccount() ? needToMoveNum : stockHolding.getAvailableAccount();
                        WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
                        moveStockVO.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
                        moveStockVO.setCreateUserId(1L);
                        moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SUPPLEMENT);
                        ArrayList<WhWmsMoveSkuVO> moveStockList = new ArrayList<WhWmsMoveSkuVO>();
                        WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                        moveSkuVO.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
                        moveSkuVO.setSkuCode(shelvesVO.getSkuCode());
                        moveSkuVO.setSkuStatus(shelvesVO.getSkuStatus());
                        moveSkuVO.setBarCode(stockHolding.getBarCode());
                        moveSkuVO.setOriginalHouseType(stockHolding.getHouseType());
                        moveSkuVO.setOriginalShelvesCode(stockHolding.getShelvesCode());
                        moveSkuVO.setTargetHouseType(shelvesVO.getHouseType());
                        moveSkuVO.setTargetShelvesCode(shelvesVO.getCode());
                        moveSkuVO.setAmount(quantity);
                        moveStockList.add(moveSkuVO);
                        moveStockVO.setMoveSkuList(moveStockList);
                        this.whWmsMoveStockService.newMoveStock(moveStockVO);
                        continue;
                    }
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
        }
    }

    private List<WhWmsHouseShelvesVO> findNeedToReplenishShelves(ReplenishCond cond) {
        ArrayList<WhWmsHouseShelvesVO> shelves = new ArrayList<WhWmsHouseShelvesVO>();
        List<WhWmsHouseShelvesVO> allMatches = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond.toShelvesCond());
        for (WhWmsHouseShelvesVO curr : allMatches) {
            if (curr.getSafeAmount() == null || curr.getSafeAmount() <= 0 || curr.getMaxAmount() == null || curr.getMaxAmount() <= 0 || curr.getMaxAmount() <= curr.getSafeAmount()) continue;
            shelves.add(curr);
        }
        return shelves;
    }

    private int sumAvailableAccountExclusiveShelfAndIncludeType(List<WhWmsSkuStockVO> rcds, WhWmsHouseShelvesVO currShelf) {
        int sum = 0;
        if (CollectionUtils.isNotEmpty(rcds)) {
            for (WhWmsSkuStockVO rcd : rcds) {
                WhWmsHouseShelvesVO hs = this.whWmsHouseShelvesService.getHouseShelvesByCode(rcd.getShelvesCode());
                if (hs.getCode().equals(currShelf.getCode()) || !hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)) continue;
                sum += rcd.getAvailableAccount();
            }
        }
        return sum;
    }

    private int sumAvailableAccountIncludeShelf(WhWmsHouseShelvesVO shelvesVO) {
        int sum = 0;
        WhWmsSkuStockVO cond = new StockCond(shelvesVO).toExternalStockCond();
        cond.setShelvesCode(shelvesVO.getCode());
        List<WhWmsSkuStockVO> rcds = this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
        if (CollectionUtils.isNotEmpty(rcds)) {
            for (WhWmsSkuStockVO rcd : rcds) {
                sum += rcd.getAvailableAccount();
            }
        }
        return sum;
    }

    private static class StockCond {
        private WhWmsHouseShelvesVO vo;

        StockCond(WhWmsHouseShelvesVO vo) {
            this.vo = vo;
        }

        public WhWmsSkuStockVO toExternalStockCond() {
            if (this.vo == null) {
                throw new WarehouseException("WH0002", "\u5e93\u4f4d\u5c5e\u6027\u4e3a\u7a7a");
            }
            WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
            cond.setPhysicalWarehouseCode(this.vo.getPhysicalWarehouseCode());
            cond.setHouseType(this.vo.getHouseType());
            cond.setSkuCode(this.vo.getSkuCode());
            cond.setSkuStatus(this.vo.getSkuStatus());
            return cond;
        }
    }

    private static class ReplenishCond {
        private String type;
        private Integer shelvesType;

        public ReplenishCond(String type, Integer shelvesType) {
            this.type = type;
            this.shelvesType = shelvesType;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getShelvesType() {
            return this.shelvesType;
        }

        public void setShelvesType(Integer shelvesType) {
            this.shelvesType = shelvesType;
        }

        public WhWmsHouseShelvesCond toShelvesCond() {
            if (this.getType() == null || !this.getType().equals("NORMAL")) {
                throw new WarehouseException("WH0002", "\u6682\u65f6\u53ea\u652f\u6301\u666e\u901a\u533a\u8fd9\u4e2a\u7c7b\u578b\u7684\u533a\u57df");
            }
            if (this.getShelvesType() == null || !this.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)) {
                throw new WarehouseException("WH0002", "\u6682\u65f6\u53ea\u652f\u6301\u62e3\u8d27\u5e93\u4f4d\u8fd9\u4e2a\u7c7b\u578b\u7684\u5e93\u4f4d");
            }
            WhWmsHouseShelvesCond c = new WhWmsHouseShelvesCond();
            c.setType(this.getType());
            c.setShelvesType(this.getShelvesType());
            c.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            c.setStorageType(WhWmsHouseShelvesVO.STORAGE_TYPE_NORMAL_TEMPERATURE);
            c.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
            c.setCurrpage(null);
            c.setPagenum(null);
            return c;
        }
    }
}

