/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishRuleCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsShelvesSkuInfoCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsReplenishRuleBlacklistMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsReplenishRuleHousetypeMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsReplenishRuleMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhWmsReplenishRuleCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishRule;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishRuleBlacklist;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishRuleBlacklistExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishRuleExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishRuleHousetype;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishRuleHousetypeExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuPickShelves;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReplenishInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReplenishRuleService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsShelvesSkuInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsBatchReplenishInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleBlacklistVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleHousetypeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsShelvesSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

@Service(value="whWmsReplenishRuleService")
public class WhWmsReplenishRuleServiceImpl
implements WhWmsReplenishRuleService {
    @Autowired
    private WhWmsReplenishRuleMapper whWmsReplenishRuleMapper;
    @Autowired
    private WhWmsReplenishRuleHousetypeMapper whWmsReplenishRuleHousetypeMapper;
    @Autowired
    private WhWmsReplenishRuleBlacklistMapper whWmsReplenishRuleBlacklistMapper;
    @Autowired
    private WhWmsReplenishRuleCustomMapper whWmsReplenishRuleCustomMapper;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsReplenishInfoService whWmsReplenishInfoService;
    @Autowired
    private WhWmsShelvesSkuInfoService whWmsShelvesSkuInfoService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Override
    public Pagination<WhWmsReplenishRuleVO> pageWhWmsReplenishRuleVOByCond(WhWmsReplenishRuleCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.countWhWmsReplenishRule(cond);
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return page;
        }
        List<WhWmsReplenishRuleVO> replenishRuleVOs = this.whWmsReplenishRuleCustomMapper.listWhWmsReplenishRuleVOByCond(cond);
        page.setResultList(replenishRuleVOs);
        return page;
    }

    @Override
    public List<WhWmsReplenishRuleVO> listWhWmsReplenishRuleVOByCond(WhWmsReplenishRuleCond cond) {
        cond.setCurrpage(null);
        return this.whWmsReplenishRuleCustomMapper.listWhWmsReplenishRuleVOByCond(cond);
    }

    @Override
    public List<WhWmsReplenishRule> listWhWmsReplenishRuleByCond(WhWmsReplenishRuleCond cond) {
        WhWmsReplenishRuleExample example = this.buildWhWmsReplenishRuleExampleByCond(cond);
        return this.whWmsReplenishRuleMapper.selectByExample(example);
    }

    @Override
    public WhWmsReplenishRule findWhWmsReplenishRuleById(Long id) {
        return this.whWmsReplenishRuleMapper.selectByPrimaryKey(id);
    }

    @Override
    public WhWmsReplenishRule findWhWmsReplenishRuleByPhyCode(String phyCode) {
        WhWmsReplenishRuleCond cond = new WhWmsReplenishRuleCond();
        cond.setPhysicalWarehouseCode(phyCode);
        List<WhWmsReplenishRule> replenishRules = this.listWhWmsReplenishRuleByCond(cond);
        if (CollectionUtils.isNotEmpty(replenishRules)) {
            return replenishRules.get(0);
        }
        return null;
    }

    private void aggregationWmsSkuStock(List<WhWmsSkuStockVO> wmsSkuStockVOs, Map<String, WhWmsSkuStockVO> skuStockVOMap) {
        String key = "";
        for (WhWmsSkuStockVO skuStockVO : wmsSkuStockVOs) {
            key = skuStockVO.getSkuCode() + skuStockVO.getShelvesCode();
            WhWmsSkuStockVO skuStockVO1 = skuStockVOMap.get(key);
            if (EmptyUtil.isEmpty((Object)skuStockVO1)) {
                skuStockVOMap.put(key, skuStockVO);
                continue;
            }
            skuStockVO1.setTotalAmount(this.getStockRemoveNull(skuStockVO.getTotalAmount()) + this.getStockRemoveNull(skuStockVO1.getTotalAmount()));
            skuStockVO1.setAvailableAmount(this.getStockRemoveNull(skuStockVO.getAvailableAmount()) + this.getStockRemoveNull(skuStockVO1.getAvailableAmount()));
        }
    }

    private int getStockRemoveNull(Integer quantity) {
        return EmptyUtil.isEmpty((Object)quantity) ? 0 : quantity;
    }

    private Set<String> fetchBlackListSkus(WhWmsReplenishRuleVO replenishRuleVO) {
        ArrayList<String> blacklistSkus = new ArrayList<String>();
        ArrayList<Long> blacklistCategorys = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(replenishRuleVO.getRuleBlacklistVOs())) {
            for (WhWmsReplenishRuleBlacklistVO blacklistVO : replenishRuleVO.getRuleBlacklistVOs()) {
                if (EmptyUtil.isNotEmpty((String)blacklistVO.getSkuCode())) {
                    blacklistSkus.add(blacklistVO.getSkuCode());
                }
                if (!EmptyUtil.isNotEmpty((Object)blacklistVO.getSecondCategoryId())) continue;
                blacklistCategorys.add(blacklistVO.getSecondCategoryId());
            }
        }
        HashSet<String> skuCodeSet = new HashSet<String>();
        if (blacklistCategorys.size() > 0) {
            WhWmsReplenishRuleCond replenishRuleCond = new WhWmsReplenishRuleCond();
            replenishRuleCond.setSecondCategoryIds(blacklistCategorys);
            List<WhWmsReplenishRuleVO> replenishRuleVOs = this.listPcsSkuVOsByCond(replenishRuleCond);
            for (WhWmsReplenishRuleVO ruleVO : replenishRuleVOs) {
                skuCodeSet.add(ruleVO.getSkuCode());
            }
        }
        if (blacklistSkus.size() > 0) {
            skuCodeSet.addAll(blacklistSkus);
        }
        return skuCodeSet;
    }

    private WhWmsReplenishRuleVO checkBeformReplenish(WhWmsReplenishInfoCond cond) {
        Validation.paramNotNull((Object)cond.getPhysicalWarehouseCode(), (String)"\u7269\u7406\u4ed3\u4e3a\u7a7a");
        WhWmsReplenishRule replenishRule = this.findWhWmsReplenishRuleByPhyCode(cond.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty((Object)replenishRule)) {
            throw new WarehouseException("WH0001", "\u4ed3\u5e93[" + cond.getPhysicalWarehouseCode() + "]\uff0c\u6ca1\u6709\u8bbe\u7f6e\u6b64\u4ed3\u5e93\u7684\u8865\u8d27\u89c4\u5219!");
        }
        if (1 != replenishRule.getRuleState()) {
            throw new WarehouseException("WH0001", "\u4ed3\u5e93[" + cond.getPhysicalWarehouseCode() + "]\uff0c\u8865\u8d27\u89c4\u5219\u672a\u5f00\u542f!");
        }
        WhWmsReplenishRuleVO replenishRuleVO = this.findWhWmsReplenishRuleVOById(replenishRule.getId(), true, true);
        if (CollectionUtils.isEmpty(replenishRuleVO.getRuleHousetypeVOs())) {
            throw new WarehouseException("WH0001", "\u4ed3\u5e93[" + cond.getPhysicalWarehouseCode() + "]\uff0c\u9002\u7528\u5e93\u533a\u89c4\u5219\u672a\u8bbe\u7f6e!");
        }
        return replenishRuleVO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String replenishInfoGenerateByCond(WhWmsReplenishInfoCond cond) throws WarehouseException {
        WhWmsReplenishRuleVO replenishRuleVO = this.checkBeformReplenish(cond);
        ArrayList<String> houseTypes = new ArrayList<String>();
        for (WhWmsReplenishRuleHousetypeVO housetypeVO : replenishRuleVO.getRuleHousetypeVOs()) {
            houseTypes.add(housetypeVO.getHouseType());
        }
        Set<String> skuCodeSet = this.fetchBlackListSkus(replenishRuleVO);
        WhWmsShelvesSkuInfoCond skuInfoCond = new WhWmsShelvesSkuInfoCond();
        skuInfoCond.setHouseTypes(houseTypes);
        if (skuCodeSet.size() > 0) {
            if (CollectionUtils.isNotEmpty(cond.getSkuCodes())) {
                HashSet<String> needSkuCodeSet = new HashSet<String>();
                for (String skuCode : cond.getSkuCodes()) {
                    if (skuCodeSet.contains(skuCode)) continue;
                    needSkuCodeSet.add(skuCode);
                }
                if (!CollectionUtils.isNotEmpty(needSkuCodeSet)) throw new WarehouseException("WH0001", "\u7ed9\u5b9a\u7684sku\u90fd\u4e0d\u5141\u8bb8\u8865\u8d27!");
                skuInfoCond.setSkuCodes(Arrays.asList(needSkuCodeSet.toArray(new String[needSkuCodeSet.size()])));
            } else {
                skuInfoCond.setNoSkuCodes(Arrays.asList(skuCodeSet.toArray(new String[skuCodeSet.size()])));
            }
        } else if (CollectionUtils.isNotEmpty(cond.getSkuCodes())) {
            skuInfoCond.setSkuCodes(cond.getSkuCodes());
        }
        skuInfoCond.setFetchSkuPickShelvesFlag(true);
        List<WhWmsShelvesSkuInfoVO> skuInfos = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(skuInfoCond);
        StringBuilder warnMsg = new StringBuilder();
        HashSet<String> shelvesCodes = new HashSet<String>();
        if (!CollectionUtils.isNotEmpty(skuInfos)) throw new WarehouseException("WH0001", "\u5f53\u524d\u4ed3\u5e93[" + cond.getPhysicalWarehouseCode() + "]\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684SKU\u4fe1\u606f!");
        ArrayList<String> skuInfoCodes = new ArrayList<String>();
        HashMap<String, Map<String, WhWmsSkuPickShelves>> skuPickShelvesMap = new HashMap<String, Map<String, WhWmsSkuPickShelves>>();
        for (WhWmsShelvesSkuInfoVO skuInfoVO : skuInfos) {
            if (!CollectionUtils.isNotEmpty(skuInfoVO.getWhWmsSkuPickShelves())) continue;
            skuInfoCodes.add(skuInfoVO.getSkuCode());
            for (WhWmsSkuPickShelves skuPickShelves : skuInfoVO.getWhWmsSkuPickShelves()) {
                HashMap<String, WhWmsSkuPickShelves> shelvesCodePickShelvesMap = (HashMap<String, WhWmsSkuPickShelves>)skuPickShelvesMap.get(skuInfoVO.getSkuCode());
                if (EmptyUtil.isEmpty((Map)shelvesCodePickShelvesMap)) {
                    shelvesCodePickShelvesMap = new HashMap<String, WhWmsSkuPickShelves>();
                    skuPickShelvesMap.put(skuPickShelves.getSkuCode(), shelvesCodePickShelvesMap);
                }
                shelvesCodes.add(skuPickShelves.getShelvesCode());
                shelvesCodePickShelvesMap.put(skuPickShelves.getShelvesCode(), skuPickShelves);
            }
        }
        ArrayList<WhWmsSkuStockVO> newWmsSkuStockVOs = new ArrayList<WhWmsSkuStockVO>();
        WhWmsSkuStockVO skuStockCond = new WhWmsSkuStockVO();
        if (skuInfoCodes.size() <= 0) return warnMsg.toString();
        skuStockCond.setSkuCodeList(skuInfoCodes);
        this.buildNewWmsSkuStockVOs(newWmsSkuStockVOs, skuStockCond, shelvesCodes, skuPickShelvesMap, cond);
        if (newWmsSkuStockVOs.size() <= 0) throw new WarehouseException("WH0001", "\u5f53\u524d\u4ed3\u5e93[" + cond.getPhysicalWarehouseCode() + "]\u6ca1\u6709\u9700\u8981\u751f\u6210\u8865\u8d27\u7684\u6570\u636e!");
        this.buildAndCreateReplenishInfo(newWmsSkuStockVOs, skuStockCond, cond, warnMsg);
        return warnMsg.toString();
    }

    private void buildAndCreateReplenishInfo(List<WhWmsSkuStockVO> newWmsSkuStockVOs, WhWmsSkuStockVO skuStockCond, WhWmsReplenishInfoCond cond, StringBuilder warnMsg) {
        ArrayList<WhWmsReplenishInfoVO> wmsReplenishInfoVOs = new ArrayList<WhWmsReplenishInfoVO>();
        ArrayList<String> primaryKey = new ArrayList<String>();
        String keyStr = "";
        for (WhWmsSkuStockVO skuStockVO1 : newWmsSkuStockVOs) {
            WhWmsReplenishInfoVO replenishInfoVO = new WhWmsReplenishInfoVO();
            replenishInfoVO.setPhysicalWarehouseCode(skuStockCond.getPhysicalWarehouseCode());
            replenishInfoVO.setSkuCode(skuStockVO1.getSkuCode());
            replenishInfoVO.setShelvesCode(skuStockVO1.getShelvesCode());
            replenishInfoVO.setHouseType(skuStockVO1.getHouseType());
            replenishInfoVO.setReplenishStates(WhWmsReplenishInfoVO.STATES_WAIT_REPLENISH);
            replenishInfoVO.setLessSafeMinStock(skuStockVO1.isLessSafeMinStock());
            keyStr = skuStockCond.getPhysicalWarehouseCode() + skuStockVO1.getSkuCode() + skuStockVO1.getShelvesCode();
            if (primaryKey.contains(keyStr + replenishInfoVO.getReplenishStates())) continue;
            primaryKey.add(keyStr + replenishInfoVO.getReplenishStates());
            WhWmsReplenishInfoCond replenishInfoCond = new WhWmsReplenishInfoCond();
            replenishInfoCond.setPhysicalWarehouseCode(skuStockCond.getPhysicalWarehouseCode());
            replenishInfoCond.setSkuCode(skuStockVO1.getSkuCode());
            replenishInfoCond.setShelvesCode(skuStockVO1.getShelvesCode());
            replenishInfoCond.setReplenishStates(WhWmsReplenishInfoVO.STATES_WAIT_REPLENISH);
            List<WhWmsReplenishInfo> replenishInfos = this.whWmsReplenishInfoService.listWhWmsReplenishInfoByCond(replenishInfoCond);
            if (CollectionUtils.isNotEmpty(replenishInfos)) {
                warnMsg.append("\u540c\u4e00:" + replenishInfoCond.toCustomString() + " \u53ea\u80fd\u5b58\u5728\u4e00\u6761\uff01<br/>");
                continue;
            }
            replenishInfoVO.setCreateUserId(cond.getCreateUserId());
            if (EmptyUtil.isEmpty((String)replenishInfoVO.getShelvesCode())) continue;
            wmsReplenishInfoVOs.add(replenishInfoVO);
        }
        if (wmsReplenishInfoVOs.size() > 0) {
            WhWmsBatchReplenishInfoVO batchReplenishInfo = new WhWmsBatchReplenishInfoVO();
            batchReplenishInfo.setReplenishInfoList(wmsReplenishInfoVOs);
            batchReplenishInfo.setAutoReplenish(cond.isAutoReplenish());
            batchReplenishInfo.setSourceConnectStart(cond.isSourceConnectStart());
            warnMsg.append(this.whWmsReplenishInfoService.batchSaveWhWmsReplenishInfoVO(batchReplenishInfo));
        }
    }

    private void buildNewWmsSkuStockVOs(List<WhWmsSkuStockVO> newWmsSkuStockVOs, WhWmsSkuStockVO skuStockCond, Set<String> shelvesCodes, Map<String, Map<String, WhWmsSkuPickShelves>> skuPickShelvesMap, WhWmsReplenishInfoCond cond) {
        skuStockCond.setPhysicalWarehouseCode(cond.getPhysicalWarehouseCode());
        skuStockCond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        ArrayList<Integer> shelvesTypeList = new ArrayList<Integer>();
        shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);
        skuStockCond.setShelvesTypeList(shelvesTypeList);
        List<WhWmsSkuStockVO> wmsSkuStockVOs = null;
        wmsSkuStockVOs = cond.isSourceConnectStart() ? this.whWmsSkuStockService.findWmsSkuAvailableAccountWithPreOccupy(skuStockCond, true) : this.whWmsSkuStockService.getSkuStocksByShelvesCondForReport(skuStockCond);
        List<String> shelvesCodeList = Arrays.asList(shelvesCodes.toArray(new String[shelvesCodes.size()]));
        List<WhWmsHouseShelves> houseShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(shelvesCodeList);
        HashMap<String, String> houseShelveMap = new HashMap<String, String>();
        for (WhWmsHouseShelves houseShelves1 : houseShelves) {
            houseShelveMap.put(houseShelves1.getCode(), houseShelves1.getHouseType());
        }
        HashMap<String, WhWmsSkuStockVO> skuStockVOMap = new HashMap<String, WhWmsSkuStockVO>();
        this.aggregationWmsSkuStock(wmsSkuStockVOs, skuStockVOMap);
        String shelvesCodeTmp = "";
        ArrayList<String> checkRepetition = new ArrayList<String>();
        for (String skuCode : skuStockCond.getSkuCodeList()) {
            String primaryKey;
            WhWmsSkuPickShelves skuPickShelvesTmp;
            Map<String, WhWmsSkuPickShelves> shelvesCodePickShelvesMap = skuPickShelvesMap.get(skuCode);
            if (!EmptyUtil.isNotEmpty(shelvesCodePickShelvesMap) || EmptyUtil.isEmpty((String)(shelvesCodeTmp = (skuPickShelvesTmp = shelvesCodePickShelvesMap.values().iterator().next()).getShelvesCode())) || checkRepetition.contains(primaryKey = skuPickShelvesTmp.getShelvesCode() + skuPickShelvesTmp.getSkuCode())) continue;
            WhWmsSkuStockVO wmsSkuStockVO = (WhWmsSkuStockVO)skuStockVOMap.get(skuCode + shelvesCodeTmp);
            if (EmptyUtil.isNotEmpty((Object)wmsSkuStockVO)) {
                int stockAmount = wmsSkuStockVO.getAvailableAmount();
                if (!EmptyUtil.isNotEmpty((Object)skuPickShelvesTmp) || stockAmount >= skuPickShelvesTmp.getSafeMaxStock() && stockAmount >= skuPickShelvesTmp.getSafeMinStock()) continue;
                if (stockAmount < skuPickShelvesTmp.getSafeMinStock()) {
                    wmsSkuStockVO.setLessSafeMinStock(true);
                }
                newWmsSkuStockVOs.add(wmsSkuStockVO);
                checkRepetition.add(primaryKey);
                continue;
            }
            checkRepetition.add(primaryKey);
            this.makeNeedReplenishSkuStock(skuStockCond.getPhysicalWarehouseCode(), skuPickShelvesTmp, houseShelveMap, newWmsSkuStockVOs);
        }
    }

    private void makeNeedReplenishSkuStock(String phyCode, WhWmsSkuPickShelves skuPickShelvesTmp, Map<String, String> houseShelveMap, List<WhWmsSkuStockVO> newWmsSkuStockVOs) {
        WhWmsSkuStockVO wmsSkuStockVO = new WhWmsSkuStockVO();
        wmsSkuStockVO.setPhysicalWarehouseCode(phyCode);
        wmsSkuStockVO.setShelvesCode(skuPickShelvesTmp.getShelvesCode());
        wmsSkuStockVO.setHouseType(houseShelveMap.get(skuPickShelvesTmp.getShelvesCode()));
        wmsSkuStockVO.setSkuCode(skuPickShelvesTmp.getSkuCode());
        wmsSkuStockVO.setAvailableAmount(0);
        wmsSkuStockVO.setLessSafeMinStock(true);
        newWmsSkuStockVOs.add(wmsSkuStockVO);
    }

    @Override
    public WhWmsReplenishRuleVO findWhWmsReplenishRuleVOById(Long id, boolean fetchHouse, boolean fetchBlack) {
        WhWmsReplenishRuleVO replenishRuleVO = this.whWmsReplenishRuleCustomMapper.findVOById(id);
        if (EmptyUtil.isNotEmpty((Object)replenishRuleVO)) {
            if (fetchHouse) {
                replenishRuleVO.setRuleHousetypeVOs(this.listWhWmsReplenishRuleHousetypeVOByRuleId(id));
            }
            if (fetchBlack) {
                replenishRuleVO.setRuleBlacklistVOs(this.listWhWmsReplenishRuleBlacklistVOByRuleId(id));
            }
        }
        return replenishRuleVO;
    }

    @Override
    public WhWmsReplenishRuleVO findWhWmsReplenishRuleVOByPhyCode(String phyCode, boolean fetchHouse, boolean fetchBlack) {
        WhWmsReplenishRule replenishRule = this.findWhWmsReplenishRuleByPhyCode(phyCode);
        if (EmptyUtil.isNotEmpty((Object)replenishRule)) {
            return this.findWhWmsReplenishRuleVOById(replenishRule.getId(), fetchHouse, fetchBlack);
        }
        return null;
    }

    @Override
    public List<WhWmsReplenishRuleVO> listPcsSkuVOsByCond(WhWmsReplenishRuleCond cond) {
        return this.whWmsReplenishRuleCustomMapper.listPcsSkuVOsByCond(cond);
    }

    @Override
    public WhWmsReplenishRuleVO saveOrUpdateWhWmsReplenishRuleVO(WhWmsReplenishRuleVO replenishRuleVO) {
        if (EmptyUtil.isNotEmpty((Object)replenishRuleVO.getId())) {
            this.updateWhWmsReplenishRuleVO(replenishRuleVO);
        } else {
            this.saveWhWmsReplenishRuleVO(replenishRuleVO);
        }
        return replenishRuleVO;
    }

    @Override
    public boolean saveWhWmsReplenishRuleVO(WhWmsReplenishRuleVO replenishRuleVO) {
        boolean result;
        WhWmsReplenishRule replenishRule = (WhWmsReplenishRule)BeanUtil.buildFrom((Object)replenishRuleVO, WhWmsReplenishRule.class);
        replenishRule.setCreateTime(DateUtil.getNow());
        boolean bl = result = this.whWmsReplenishRuleMapper.insert(replenishRule) > 0;
        if (result) {
            if (CollectionUtils.isNotEmpty(replenishRuleVO.getRuleHousetypeVOs())) {
                this.batchInsertHousetypeByHousetypeVOs(replenishRuleVO.getRuleHousetypeVOs(), replenishRule.getId());
            }
            if (CollectionUtils.isNotEmpty(replenishRuleVO.getRuleBlacklistVOs())) {
                this.batchInsertBlacklistByBlacklistVOs(replenishRuleVO.getRuleBlacklistVOs(), replenishRule.getId());
            }
            replenishRuleVO.setId(replenishRule.getId());
        }
        return result;
    }

    private void batchInsertHousetypeByHousetypeVOs(List<WhWmsReplenishRuleHousetypeVO> ruleHousetypeVOs, Long ruleId) {
        List ruleHousetypes = BeanUtil.buildListFrom(ruleHousetypeVOs, WhWmsReplenishRuleHousetype.class);
        for (WhWmsReplenishRuleHousetype ruleHousetype : ruleHousetypes) {
            ruleHousetype.setReplenishRuleId(ruleId);
        }
        this.whWmsReplenishRuleCustomMapper.batchInsertWhWmsReplenishRuleHousetype(ruleHousetypes);
    }

    private void batchInsertBlacklistByBlacklistVOs(List<WhWmsReplenishRuleBlacklistVO> ruleBlacklistVOs, Long ruleId) {
        List ruleBlacklists = BeanUtil.buildListFrom(ruleBlacklistVOs, WhWmsReplenishRuleBlacklist.class);
        for (WhWmsReplenishRuleBlacklist ruleBlacklist : ruleBlacklists) {
            ruleBlacklist.setReplenishRuleId(ruleId);
        }
        this.whWmsReplenishRuleCustomMapper.batchInsertWhWmsReplenishRuleBlacklist(ruleBlacklists);
    }

    @Override
    public boolean updateWhWmsReplenishRuleVO(WhWmsReplenishRuleVO replenishRuleVO) {
        boolean result;
        WhWmsReplenishRule replenishRule = (WhWmsReplenishRule)BeanUtil.buildFrom((Object)replenishRuleVO, WhWmsReplenishRule.class);
        replenishRule.setUpdateTime(DateUtil.getNow());
        boolean bl = result = this.whWmsReplenishRuleMapper.updateByPrimaryKeySelective(replenishRule) > 0;
        if (result) {
            if (CollectionUtils.isNotEmpty(replenishRuleVO.getRuleHousetypeVOs())) {
                this.deleteWhWmsReplenishRuleHousetypeByRuleId(replenishRuleVO.getId());
                this.batchInsertHousetypeByHousetypeVOs(replenishRuleVO.getRuleHousetypeVOs(), replenishRuleVO.getId());
            }
            if (CollectionUtils.isNotEmpty(replenishRuleVO.getRuleBlacklistVOs())) {
                this.deleteWhWmsReplenishRuleBlacklistByRuleId(replenishRuleVO.getId());
                this.batchInsertBlacklistByBlacklistVOs(replenishRuleVO.getRuleBlacklistVOs(), replenishRuleVO.getId());
            }
        }
        return result;
    }

    @Override
    public List<WhWmsReplenishRuleHousetypeVO> listWhWmsReplenishRuleHousetypeVOByCond(WhWmsReplenishRuleCond cond) {
        return this.whWmsReplenishRuleCustomMapper.listWhWmsReplenishRuleHousetypeVOByCond(cond);
    }

    @Override
    public List<WhWmsReplenishRuleHousetypeVO> listWhWmsReplenishRuleHousetypeVOByRuleId(Long ruleId) {
        WhWmsReplenishRuleCond cond = new WhWmsReplenishRuleCond();
        cond.setId(ruleId);
        return this.listWhWmsReplenishRuleHousetypeVOByCond(cond);
    }

    @Override
    public boolean deleteWhWmsReplenishRuleHousetypeByRuleId(Long ruleId) {
        WhWmsReplenishRuleHousetypeExample example = new WhWmsReplenishRuleHousetypeExample();
        example.createCriteria().andReplenishRuleIdEqualTo(ruleId);
        return this.whWmsReplenishRuleHousetypeMapper.deleteByExample(example) >= 0;
    }

    @Override
    public List<WhWmsReplenishRuleBlacklistVO> listWhWmsReplenishRuleBlacklistVOByCond(WhWmsReplenishRuleCond cond) {
        return this.whWmsReplenishRuleCustomMapper.listWhWmsReplenishRuleBlacklistVOByCond(cond);
    }

    @Override
    public List<WhWmsReplenishRuleBlacklistVO> listWhWmsReplenishRuleBlacklistVOByRuleId(Long ruleId) {
        WhWmsReplenishRuleCond cond = new WhWmsReplenishRuleCond();
        cond.setId(ruleId);
        return this.listWhWmsReplenishRuleBlacklistVOByCond(cond);
    }

    @Override
    public boolean deleteWhWmsReplenishRuleBlacklistByRuleId(Long ruleId) {
        WhWmsReplenishRuleBlacklistExample example = new WhWmsReplenishRuleBlacklistExample();
        example.createCriteria().andReplenishRuleIdEqualTo(ruleId);
        return this.whWmsReplenishRuleBlacklistMapper.deleteByExample(example) >= 0;
    }

    private int countWhWmsReplenishRule(WhWmsReplenishRuleCond cond) {
        return this.whWmsReplenishRuleCustomMapper.countWhWmsReplenishRuleByCond(cond);
    }

    private WhWmsReplenishRuleExample buildWhWmsReplenishRuleExampleByCond(WhWmsReplenishRuleCond cond) {
        WhWmsReplenishRuleExample example = new WhWmsReplenishRuleExample();
        WhWmsReplenishRuleExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getRuleState())) {
            criteria.andRuleStateEqualTo(cond.getRuleState());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getRunInterval())) {
            criteria.andRunIntervalEqualTo(cond.getRunInterval());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getPhysicalWarehouseCode())) {
            criteria.andPhysicalWarehouseCodeEqualTo(cond.getPhysicalWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateTimeStart())) {
            criteria.andCreateTimeGreaterThanOrEqualTo(cond.getCreateTimeStart());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateTimeEnd())) {
            criteria.andCreateTimeLessThanOrEqualTo(cond.getCreateTimeEnd());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getOrderBy())) {
            example.setOrderByClause(cond.getOrderBy());
        }
        return example;
    }
}

