/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishInfoCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsReplenishInfoMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhWmsReplenishInfoCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishInfoExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReplenishInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsBatchReplenishInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitPutawayVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whWmsReplenishInfoService")
public class WhWmsReplenishInfoServiceImpl
implements WhWmsReplenishInfoService {
    @Autowired
    private WhWmsReplenishInfoMapper whWmsReplenishInfoMapper;
    @Autowired
    private WhWmsReplenishInfoCustomMapper whWmsReplenishInfoCustomMapper;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;
    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;
    @Autowired
    private WhWmsWaitPutawayService whWmsWaitPutawayService;

    @Override
    public Pagination<WhWmsReplenishInfoVO> pageWhWmsReplenishInfoVOByCond(WhWmsReplenishInfoCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.countWhWmsReplenishInfo(cond);
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return page;
        }
        List<WhWmsReplenishInfoVO> replenishRuleVOs = this.whWmsReplenishInfoCustomMapper.listWhWmsReplenishInfoVOByCond(cond);
        page.setResultList(replenishRuleVOs);
        return page;
    }

    @Override
    public List<WhWmsReplenishInfoVO> listWhWmsReplenishInfoVOByCond(WhWmsReplenishInfoCond cond) {
        return this.whWmsReplenishInfoCustomMapper.listWhWmsReplenishInfoVOByCond(cond);
    }

    @Override
    public List<WhWmsReplenishInfo> listWhWmsReplenishInfoByCond(WhWmsReplenishInfoCond cond) {
        cond.setCurrpage(null);
        WhWmsReplenishInfoExample example = this.buildWhWmsReplenishInfoExampleByCond(cond);
        return this.whWmsReplenishInfoMapper.selectByExample(example);
    }

    @Override
    public WhWmsReplenishInfo findWhWmsReplenishInfoById(Long id) {
        return this.whWmsReplenishInfoMapper.selectByPrimaryKey(id);
    }

    @Override
    public WhWmsReplenishInfoVO findWhWmsReplenishInfoVOById(Long id) {
        return this.whWmsReplenishInfoCustomMapper.findVOById(id);
    }

    @Override
    public WhWmsReplenishInfoVO saveOrUpdateWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishRuleVO) {
        if (EmptyUtil.isNotEmpty((Object)replenishRuleVO.getId())) {
            this.updateWhWmsReplenishInfoVO(replenishRuleVO);
        } else {
            this.saveWhWmsReplenishInfoVO(replenishRuleVO);
        }
        return replenishRuleVO;
    }

    @Override
    public boolean batchSaveWhWmsReplenishInfo(List<WhWmsReplenishInfo> replenishInfos) {
        return this.whWmsReplenishInfoCustomMapper.batchInsertWhWmsReplenishInfo(replenishInfos) > 0;
    }

    @Override
    @Transactional
    public String batchSaveWhWmsReplenishInfoVO(WhWmsBatchReplenishInfoVO batchReplenishInfo) throws WarehouseException {
        WhWmsReplenishInfo replenishInfo = null;
        List<WhWmsReplenishInfoVO> replenishInfoVOs = batchReplenishInfo.getReplenishInfoList();
        StringBuilder warnMsg = new StringBuilder();
        HashSet<String> skuCodeSet = new HashSet<String>();
        for (WhWmsReplenishInfo whWmsReplenishInfo : replenishInfoVOs) {
            skuCodeSet.add(whWmsReplenishInfo.getSkuCode());
        }
        Map<String, Boolean> skuBooleanMap = this.usedSupplierAndEffectiveGoods(Arrays.asList(skuCodeSet.toArray(new String[skuCodeSet.size()])));
        for (WhWmsReplenishInfoVO replenishInfoVO : replenishInfoVOs) {
            try {
                replenishInfo = (WhWmsReplenishInfo)BeanUtil.buildFrom((Object)replenishInfoVO, WhWmsReplenishInfo.class);
                replenishInfo.setCreateTime(DateUtil.getNow());
                if ((replenishInfoVO.isLessSafeMinStock() || batchReplenishInfo.isAutoReplenish()) && !this.checkReplenishInfoUnique(replenishInfo, warnMsg)) continue;
                this.whWmsReplenishInfoMapper.insert(replenishInfo);
                if (!replenishInfoVO.isLessSafeMinStock() && !batchReplenishInfo.isAutoReplenish()) continue;
                WhWmsReplenishInfoCond cond = new WhWmsReplenishInfoCond();
                cond.setId(replenishInfo.getId());
                cond.setCreateUserId(replenishInfoVOs.get(0).getCreateUserId());
                cond.setSourceConnectStart(batchReplenishInfo.isSourceConnectStart());
                String result = this.buildAndCreateMoveStock(replenishInfo, skuBooleanMap, cond);
                warnMsg.append(result);
                if (!EmptyUtil.isNotEmpty((String)result)) continue;
                this.whWmsReplenishInfoMapper.deleteByPrimaryKey(replenishInfo.getId());
            }
            catch (Exception exception) {}
        }
        return warnMsg.toString();
    }

    private boolean checkReplenishInfoUnique(WhWmsReplenishInfo replenishInfo, StringBuilder warnMsg) {
        WhWmsReplenishInfoCond replenishInfoCond = new WhWmsReplenishInfoCond();
        replenishInfoCond.setPhysicalWarehouseCode(replenishInfo.getPhysicalWarehouseCode());
        replenishInfoCond.setSkuCode(replenishInfo.getSkuCode());
        replenishInfoCond.setShelvesCode(replenishInfo.getShelvesCode());
        replenishInfoCond.setReplenishStates(WhWmsReplenishInfoVO.STATES_REPLENISHING);
        if (CollectionUtils.isNotEmpty(this.listWhWmsReplenishInfoByCond(replenishInfoCond))) {
            warnMsg.append("\u540c\u4e00:" + replenishInfoCond.toCustomString() + " \u53ea\u80fd\u5b58\u5728\u4e00\u6761\uff01<br/>");
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public String createReplenishMoveStock(WhWmsReplenishInfoCond cond) throws Exception {
        List<WhWmsReplenishInfo> replenishInfos = this.listWhWmsReplenishInfoByCond(cond);
        String warnMsg = "";
        if (CollectionUtils.isNotEmpty(replenishInfos)) {
            HashSet<String> skuCodeSet = new HashSet<String>();
            for (WhWmsReplenishInfo replenishInfo : replenishInfos) {
                skuCodeSet.add(replenishInfo.getSkuCode());
            }
            Map<String, Boolean> skuBooleanMap = this.usedSupplierAndEffectiveGoods(Arrays.asList(skuCodeSet.toArray(new String[skuCodeSet.size()])));
            for (WhWmsReplenishInfo replenishInfo : replenishInfos) {
                try {
                    warnMsg = warnMsg + this.buildAndCreateMoveStock(replenishInfo, skuBooleanMap, cond);
                }
                catch (Exception exception) {}
            }
        }
        return warnMsg;
    }

    @Override
    public Map<String, Boolean> usedSupplierAndEffectiveGoods(List<String> skuCodes) {
        WhWmsWaitPutawayVO cond = new WhWmsWaitPutawayVO();
        cond.setCerSkuCodeList(skuCodes);
        List<WhWmsWaitPutawayVO> waitPutawayVOs = this.whWmsWaitPutawayService.listPutawayListBySkuCode(cond);
        return this.buildUseSupplierCodeByWaitPutaway(waitPutawayVOs);
    }

    public Map<String, Boolean> buildUseSupplierCodeByWaitPutaway(List<WhWmsWaitPutawayVO> whWmsWaitPutawayVOs) {
        HashMap<String, Boolean> skuBooleanMap = new HashMap<String, Boolean>();
        for (WhWmsWaitPutawayVO whWmsWaitPutawayVO : whWmsWaitPutawayVOs) {
            if (!this.getBooleanByCheckIntValue(whWmsWaitPutawayVO.getIsHasTag(), 1) || !this.getBooleanByCheckIntValue(whWmsWaitPutawayVO.getCerType(), 2) || this.getBooleanByCheckIntValue(whWmsWaitPutawayVO.getPrintMpCode(), 1) || !this.getBooleanByCheckIntValue(whWmsWaitPutawayVO.getSkuType(), 3) || !EmptyUtil.isNotEmpty((Object)whWmsWaitPutawayVO.getShelfLife()) || whWmsWaitPutawayVO.getShelfLife() <= 0 || skuBooleanMap.keySet().contains(whWmsWaitPutawayVO.getSkuCode())) continue;
            skuBooleanMap.put(whWmsWaitPutawayVO.getSkuCode(), true);
        }
        return skuBooleanMap;
    }

    public boolean getBooleanByCheckIntValue(Integer value, int flag) {
        return EmptyUtil.isNotEmpty((Object)value) && flag == value;
    }

    @Override
    public boolean saveWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishRuleVO) {
        WhWmsReplenishInfo replenishRule = (WhWmsReplenishInfo)BeanUtil.buildFrom((Object)replenishRuleVO, WhWmsReplenishInfo.class);
        replenishRule.setCreateTime(DateUtil.getNow());
        return this.whWmsReplenishInfoMapper.insert(replenishRule) > 0;
    }

    @Override
    public boolean updateWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishRuleVO) {
        WhWmsReplenishInfo replenishRule = (WhWmsReplenishInfo)BeanUtil.buildFrom((Object)replenishRuleVO, WhWmsReplenishInfo.class);
        return this.whWmsReplenishInfoMapper.updateByPrimaryKeySelective(replenishRule) > 0;
    }

    @Override
    public boolean updateWhWmsReplenishInfoByCond(WhWmsReplenishInfo replenishInfo, WhWmsReplenishInfoCond cond) {
        WhWmsReplenishInfoExample example = this.buildWhWmsReplenishInfoExampleByCond(cond);
        return this.whWmsReplenishInfoMapper.updateByExampleSelective(replenishInfo, example) > 0;
    }

    @Override
    public boolean updateWhWmsReplenishInfoStatesByRefCode(String refCode, Integer refType, Integer newReplenishStates) {
        WhWmsReplenishInfo replenishInfo = new WhWmsReplenishInfo();
        replenishInfo.setReplenishStates(newReplenishStates);
        WhWmsReplenishInfoCond cond = new WhWmsReplenishInfoCond();
        cond.setRefCode(refCode);
        cond.setRefType(refType);
        return this.updateWhWmsReplenishInfoByCond(replenishInfo, cond);
    }

    private int countWhWmsReplenishInfo(WhWmsReplenishInfoCond cond) {
        return this.whWmsReplenishInfoCustomMapper.countWhWmsReplenishInfoByCond(cond);
    }

    private List<WhWmsSkuStockVO> listWmsSkuStockByCond(WhWmsSkuStockVO stockCond, WhWmsReplenishInfo replenishInfo) {
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setPhysicalWarehouseCode(stockCond.getPhysicalWarehouseCode());
        cond.setShelvesCode(replenishInfo.getShelvesCode());
        cond.setSkuCode(replenishInfo.getSkuCode());
        cond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        cond.setGtZero(true);
        return this.whWmsSkuStockService.getSkuStocksByShelvesCondForReport(cond);
    }

    @Override
    public String buildAndCreateMoveStock(WhWmsReplenishInfo replenishInfo, Map<String, Boolean> skuBooleanMap, WhWmsReplenishInfoCond cond) throws WarehouseException {
        if (EmptyUtil.isNotEmpty((Object)replenishInfo)) {
            if (EmptyUtil.isEmpty((String)cond.getPhysicalWarehouseCode())) {
                cond.setPhysicalWarehouseCode(replenishInfo.getPhysicalWarehouseCode());
            }
            ArrayList<String> barCodes = new ArrayList<String>();
            HashMap<String, WhWmsSkuBarcode> barcodeMap = new HashMap<String, WhWmsSkuBarcode>();
            List<WhWmsSkuBarcode> skuBarcodeList = this.whWmsSkuBarcodeService.findBarCodesForPickSkuStock(replenishInfo.getSkuCode());
            for (WhWmsSkuBarcode barcode : skuBarcodeList) {
                barCodes.add(barcode.getBarCode());
                barcodeMap.put(barcode.getBarCode(), barcode);
            }
            Map<String, WhWmsWarehouseArea> areaMap = this.whWmsWarehouseAreaService.getAreaHouseMapByType("NORMAL");
            List<String> houseTypes = Arrays.asList(areaMap.keySet().toArray(new String[areaMap.size()]));
            List<WhWmsSkuStockVO> stockList = null;
            if (EmptyUtil.isNotEmpty(barCodes)) {
                WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
                stockCond.setPhysicalWarehouseCode(cond.getPhysicalWarehouseCode());
                stockCond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
                stockCond.setBarCodeList(barCodes);
                stockCond.setHouseTypes(houseTypes);
                ArrayList<Integer> shelvesTypeList = new ArrayList<Integer>();
                shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING);
                stockCond.setShelvesTypeList(shelvesTypeList);
                stockList = cond.isSourceConnectStart() ? this.whWmsSkuStockService.findWmsSkuAvailableAccountWithPreOccupy(stockCond, true) : this.whWmsSkuStockService.getSkuStocksByShelvesCondForReport(stockCond);
                if (CollectionUtils.isEmpty(stockList)) {
                    return "\u4ed3\u5e93:" + stockCond.getPhysicalWarehouseCode() + "\uff0cSKU\uff1a" + replenishInfo.getSkuCode() + "\uff0c\u4fdd\u7ba1\u5e93\u4f4d\u6ca1\u6709\u53ef\u7528\u826f\u54c1\u5e93\u5b58\uff0c\u65e0\u6cd5\u521b\u5efa\u8865\u8d27\u79fb\u5e93\u5355!</br>";
                }
                for (WhWmsSkuStockVO skuStockVO : stockList) {
                    WhWmsHouseShelvesVO shelvesVO;
                    if (!EmptyUtil.isNotEmpty((Object)skuStockVO) || skuStockVO.getAvailableAmount() <= 0 || !EmptyUtil.isEmpty((String)skuStockVO.getHouseType()) || !EmptyUtil.isNotEmpty((String)skuStockVO.getShelvesCode()) || !EmptyUtil.isNotEmpty((Object)(shelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStockVO.getShelvesCode())))) continue;
                    skuStockVO.setHouseType(shelvesVO.getHouseType());
                }
                this.sortStock(stockList, barcodeMap);
                Map<String, List<WhWmsSkuStockVO>> skuStockMap = this.organizeStock(stockList);
                return this.buildAndCreateMoveStock(replenishInfo, skuStockMap, skuBooleanMap, stockCond, cond);
            }
            return "SKU\uff1a" + replenishInfo.getSkuCode() + "\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u6279\u6b21\uff0c\u65e0\u6cd5\u521b\u5efa\u8865\u8d27\u79fb\u5e93\u5355!</br>";
        }
        return "";
    }

    private String buildAndCreateMoveStock(WhWmsReplenishInfo replenishInfo, Map<String, List<WhWmsSkuStockVO>> skuStockMap, Map<String, Boolean> skuBooleanMap, WhWmsSkuStockVO stockCond, WhWmsReplenishInfoCond cond) {
        Boolean skuBooleanFlag = skuBooleanMap.get(replenishInfo.getSkuCode());
        List<WhWmsSkuStockVO> targetStockList = null;
        if (skuBooleanFlag != null && skuBooleanFlag.booleanValue() && CollectionUtils.isNotEmpty(targetStockList = this.listWmsSkuStockByCond(stockCond, replenishInfo)) && targetStockList.size() > 1) {
            return "\u6548\u671f\u5546\u54c1:[" + replenishInfo.getSkuCode() + "]\uff0c\u4ed3\u5e93:[" + stockCond.getPhysicalWarehouseCode() + "]\uff0c\u76ee\u6807\u5e93\u4f4d\uff1a[" + replenishInfo.getShelvesCode() + "]\u5b58\u5728\u591a\u4e2a\u6279\u6b21\uff0c\u65e0\u6cd5\u521b\u5efa\u8865\u8d27\u79fb\u5e93\u5355!</br>";
        }
        List<WhWmsSkuStockVO> skuStockList = skuStockMap.get(replenishInfo.getSkuCode());
        ArrayList<WhWmsMoveSkuVO> moveSkuList = new ArrayList<WhWmsMoveSkuVO>();
        if (EmptyUtil.isNotEmpty(skuStockList)) {
            WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
            moveSkuVO.setPhysicalWarehouseCode(replenishInfo.getPhysicalWarehouseCode());
            moveSkuVO.setCreateTime(DateUtil.getNow());
            Iterator<WhWmsSkuStockVO> it = skuStockList.iterator();
            while (it.hasNext()) {
                WhWmsSkuStockVO stockVO = it.next();
                moveSkuVO.setBarCode(stockVO.getBarCode());
                moveSkuVO.setAmount(stockVO.getAvailableAmount());
                it.remove();
                if (moveSkuVO.getAmount() <= 0) continue;
                moveSkuVO.setOriginalShelvesCode(stockVO.getShelvesCode());
                if (moveSkuVO.getOriginalShelvesCode().equals(replenishInfo.getShelvesCode())) {
                    moveSkuVO.setTargetShelvesCode(replenishInfo.getShelvesCode());
                    continue;
                }
                moveSkuVO.setTargetShelvesCode("");
                moveSkuVO.setOriginalHouseType(stockVO.getHouseType());
                if (skuBooleanFlag == null || !skuBooleanFlag.booleanValue() || !CollectionUtils.isNotEmpty(targetStockList)) break;
                WhWmsSkuStockVO targetWmsSkuStockVO = targetStockList.get(0);
                if (!moveSkuVO.getBarCode().equals(targetWmsSkuStockVO.getBarCode())) {
                    moveSkuVO.setTargetBarcode(targetWmsSkuStockVO.getBarCode());
                    continue;
                }
                moveSkuVO.setTargetBarcode("");
                break;
            }
            if (NumberUtil.isNullOrZero((Number)moveSkuVO.getAmount())) {
                return "\u4ed3\u5e93:" + stockCond.getPhysicalWarehouseCode() + "\uff0cSKU\uff1a" + replenishInfo.getSkuCode() + "\uff0c\u4fdd\u7ba1\u5e93\u4f4d\u6ca1\u6709\u53ef\u7528\u826f\u54c1\u5e93\u5b58\uff0c\u65e0\u6cd5\u521b\u5efa\u8865\u8d27\u79fb\u5e93\u5355!</br>";
            }
            if (EmptyUtil.isNotEmpty((String)moveSkuVO.getTargetShelvesCode())) {
                return "SKU:[" + replenishInfo.getSkuCode() + "]\uff0c\u4ed3\u5e93:[" + stockCond.getPhysicalWarehouseCode() + "]\uff0c\u6e90\u5e93\u4f4d,\u76ee\u6807\u5e93\u4f4d\u4e0d\u80fd\u76f8\u540c:[" + moveSkuVO.getTargetShelvesCode() + "]!</br>";
            }
            if (EmptyUtil.isNotEmpty((String)moveSkuVO.getTargetBarcode())) {
                return "\u6548\u671f\u5546\u54c1:[" + replenishInfo.getSkuCode() + "]\uff0c\u4ed3\u5e93:[" + stockCond.getPhysicalWarehouseCode() + "]\uff0c\u6e90\u5e93\u4f4d\u6279\u6b21:[" + moveSkuVO.getBarCode() + "]\uff0c\u76ee\u6807\u5e93\u4f4d\u6279\u6b21:[" + moveSkuVO.getTargetBarcode() + "]\u4e0d\u76f8\u7b49\uff0c\u65e0\u6cd5\u521b\u5efa\u8865\u8d27\u79fb\u5e93\u5355!</br>";
            }
            moveSkuVO.setTargetShelvesCode(replenishInfo.getShelvesCode());
            moveSkuVO.setTargetHouseType(this.getHouseTypeByCode(moveSkuVO.getTargetShelvesCode()));
            moveSkuVO.setSkuCode(replenishInfo.getSkuCode());
            moveSkuVO.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            moveSkuVO.setStatus(WhWmsMoveSku.MOVE_SKU_STATUS_WAIT_MOVE);
            moveSkuList.add(moveSkuVO);
        }
        if (EmptyUtil.isNotEmpty(moveSkuList)) {
            boolean result;
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(replenishInfo.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(cond.getCreateUserId());
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SUPPLEMENT);
            moveStockVO.setMoveSkuList(moveSkuList);
            WhWmsReplenishInfoCond replenishInfoCond = new WhWmsReplenishInfoCond();
            replenishInfoCond.setPhysicalWarehouseCode(moveStockVO.getPhysicalWarehouseCode());
            replenishInfoCond.setReplenishStates(WhWmsReplenishInfoVO.STATES_REPLENISHING);
            String warnMsg = this.checkWhWmsReplenishInfoPrimary(replenishInfoCond, cond.getIds());
            if (EmptyUtil.isNotEmpty((String)warnMsg)) {
                return warnMsg;
            }
            try {
                result = this.whWmsMoveStockService.newMoveStock(moveStockVO);
            }
            catch (WarehouseException e) {
                return e.getMessage();
            }
            if (result) {
                WhWmsReplenishInfo record = new WhWmsReplenishInfo();
                record.setReplenishStates(WhWmsReplenishInfoVO.STATES_REPLENISHING);
                record.setRefCode(moveStockVO.getCode());
                record.setRefType(WhWmsReplenishInfoVO.REF_TYPE_MOVE_STOCK);
                cond.setCreateUserId(null);
                this.updateWhWmsReplenishInfoByCond(record, cond);
            }
        } else {
            return "\u4ed3\u5e93:" + stockCond.getPhysicalWarehouseCode() + "\uff0cSKU\uff1a" + replenishInfo.getSkuCode() + "\uff0c\u4fdd\u7ba1\u5e93\u4f4d\u6ca1\u6709\u53ef\u7528\u826f\u54c1\u5e93\u5b58\uff0c\u65e0\u6cd5\u521b\u5efa\u8865\u8d27\u79fb\u5e93\u5355!</br>";
        }
        return "";
    }

    private String checkWhWmsReplenishInfoPrimary(WhWmsReplenishInfoCond replenishInfoCond, List<Long> replenishInfoIds) {
        List<WhWmsReplenishInfo> oldReplenishInfos = this.listWhWmsReplenishInfoByCond(replenishInfoCond);
        StringBuilder warnMsg = new StringBuilder();
        if (CollectionUtils.isNotEmpty(oldReplenishInfos)) {
            ArrayList<String> primaryKeys = new ArrayList<String>();
            for (WhWmsReplenishInfo oldReplenishInfo : oldReplenishInfos) {
                primaryKeys.add(oldReplenishInfo.getPhysicalWarehouseCode() + oldReplenishInfo.getSkuCode() + oldReplenishInfo.getShelvesCode());
            }
            if (CollectionUtils.isNotEmpty(replenishInfoIds)) {
                replenishInfoCond = new WhWmsReplenishInfoCond();
                replenishInfoCond.setIds(replenishInfoIds);
                List<WhWmsReplenishInfo> replenishInfos = this.listWhWmsReplenishInfoByCond(replenishInfoCond);
                if (CollectionUtils.isNotEmpty(replenishInfos)) {
                    String key = "";
                    for (WhWmsReplenishInfo replenishInfo : replenishInfos) {
                        key = replenishInfo.getPhysicalWarehouseCode() + replenishInfo.getSkuCode() + replenishInfo.getShelvesCode();
                        if (!primaryKeys.contains(key)) continue;
                        warnMsg.append("\u540c\u4e00:" + new WhWmsReplenishInfoCond(replenishInfo.getPhysicalWarehouseCode(), replenishInfo.getSkuCode(), replenishInfo.getShelvesCode(), WhWmsReplenishInfoVO.STATES_REPLENISHING).toCustomString()).append("\u53ea\u80fd\u5b58\u5728\u4e00\u6761\uff01<br/>");
                    }
                }
            }
        }
        return warnMsg.toString();
    }

    private Map<String, List<WhWmsSkuStockVO>> organizeStock(List<WhWmsSkuStockVO> stockList) {
        HashMap<String, List<WhWmsSkuStockVO>> skuStockMap = new HashMap<String, List<WhWmsSkuStockVO>>();
        for (WhWmsSkuStockVO skuStockVO : stockList) {
            ArrayList<WhWmsSkuStockVO> stockInfoList = (ArrayList<WhWmsSkuStockVO>)skuStockMap.get(skuStockVO.getSkuCode());
            if (NullUtil.isNull((Object)stockInfoList)) {
                stockInfoList = new ArrayList<WhWmsSkuStockVO>();
                skuStockMap.put(skuStockVO.getSkuCode(), stockInfoList);
            }
            stockInfoList.add(skuStockVO);
        }
        return skuStockMap;
    }

    private void sortStock(List<WhWmsSkuStockVO> stockList, final Map<String, WhWmsSkuBarcode> barcodeMap) {
        Collections.sort(stockList, new Comparator<WhWmsSkuStockVO>(){

            @Override
            public int compare(WhWmsSkuStockVO s1, WhWmsSkuStockVO s2) {
                int result = WhWmsReplenishInfoServiceImpl.this.compareBarCode((WhWmsSkuBarcode)barcodeMap.get(s1.getBarCode()), (WhWmsSkuBarcode)barcodeMap.get(s2.getBarCode()));
                if (result == 0) {
                    result = s1.getAvailableAccount() - s2.getAvailableAccount();
                }
                return result;
            }
        });
    }

    private String getHouseTypeByCode(String shelvesCode) {
        if (EmptyUtil.isEmpty((String)shelvesCode)) {
            return "";
        }
        WhWmsHouseShelvesVO houseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(shelvesCode);
        if (EmptyUtil.isNotEmpty((Object)houseShelvesVO)) {
            return houseShelvesVO.getHouseType();
        }
        return "";
    }

    private void getAndSortBarcodeBySku(List<String> skuCodes, Map<String, List<WhWmsSkuBarcode>> skuBarcodeMap) {
        List<WhWmsSkuBarcode> skuBarcodeList = this.whWmsSkuBarcodeService.findBarCodesForPickSkuStock(skuCodes);
        for (WhWmsSkuBarcode whWmsSkuBarcode : skuBarcodeList) {
            List<WhWmsSkuBarcode> barcodes = skuBarcodeMap.get(whWmsSkuBarcode.getSkuCode());
            if (CollectionUtils.isEmpty(barcodes)) {
                barcodes = new ArrayList<WhWmsSkuBarcode>();
                skuBarcodeMap.put(whWmsSkuBarcode.getSkuCode(), barcodes);
            }
            barcodes.add(whWmsSkuBarcode);
        }
        for (Map.Entry entry : skuBarcodeMap.entrySet()) {
            Collections.sort((List)entry.getValue(), new Comparator<WhWmsSkuBarcode>(){

                @Override
                public int compare(WhWmsSkuBarcode s1, WhWmsSkuBarcode s2) {
                    return WhWmsReplenishInfoServiceImpl.this.compareBarCode(s1, s2);
                }
            });
        }
    }

    private void sortSkuStock(List<WhWmsSkuStockVO> stockList) {
        if (CollectionUtils.isNotEmpty(stockList)) {
            Collections.sort(stockList, new Comparator<WhWmsSkuStockVO>(){

                @Override
                public int compare(WhWmsSkuStockVO s1, WhWmsSkuStockVO s2) {
                    return s1.getAvailableAmount() - s2.getAvailableAmount();
                }
            });
        }
    }

    private int compareShelvesType(WhWmsHouseShelves s1, WhWmsHouseShelves s2) {
        if (NullUtil.isNull((Object)s1.getShelvesType()) && NullUtil.isNull((Object)s2.getShelvesType())) {
            return 0;
        }
        if (NullUtil.isNull((Object)s1.getShelvesType())) {
            return 1;
        }
        if (NullUtil.isNull((Object)s2.getShelvesType())) {
            return -1;
        }
        return s1.getShelvesType().compareTo(s2.getShelvesType());
    }

    private int compareShelvesSortOrder(WhWmsHouseShelves s1, WhWmsHouseShelves s2) {
        if (NullUtil.isNull((Object)s1.getSortOrder()) && NullUtil.isNull((Object)s1.getSortOrder())) {
            return 0;
        }
        if (NullUtil.isNull((Object)s1.getSortOrder())) {
            return 1;
        }
        if (NullUtil.isNull((Object)s1.getSortOrder())) {
            return -1;
        }
        return s1.getSortOrder().compareTo(s1.getSortOrder());
    }

    private int compareShelvesArea(WhWmsWarehouseArea a1, WhWmsWarehouseArea a2) {
        if (NullUtil.isNull((Object)a1.getSortOrder()) && NullUtil.isNull((Object)a2.getSortOrder())) {
            return 0;
        }
        if (NullUtil.isNull((Object)a1.getSortOrder())) {
            return 1;
        }
        if (NullUtil.isNull((Object)a2.getSortOrder())) {
            return -1;
        }
        return a1.getSortOrder().compareTo(a2.getSortOrder());
    }

    public int compareBarCode(WhWmsSkuBarcode barcode1, WhWmsSkuBarcode barcode2) {
        return this.whWmsSkuBarcodeService.compareBarCode(barcode1, barcode2);
    }

    private Integer buildMoveStockAmount(WhWmsMoveSkuVO moveSkuVO) {
        WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
        stockCond.setPhysicalWarehouseCode(moveSkuVO.getPhysicalWarehouseCode());
        stockCond.setShelvesCode(moveSkuVO.getOriginalShelvesCode());
        stockCond.setBarCode(moveSkuVO.getBarCode());
        stockCond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        List<WhWmsSkuStockVO> stockList = this.whWmsSkuStockService.getSkuStocksByShelvesCondForReport(stockCond);
        if (CollectionUtils.isNotEmpty(stockList)) {
            return stockList.get(0).getAvailableAmount();
        }
        return 0;
    }

    private WhWmsSkuStockVO generateSourceShelvesCodeByRule(WhWmsMoveSkuVO moveSkuVO) throws Exception {
        WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
        stockCond.setPhysicalWarehouseCode(moveSkuVO.getPhysicalWarehouseCode());
        stockCond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        stockCond.setBarCode(moveSkuVO.getBarCode());
        ArrayList<Integer> shelvesTypeList = new ArrayList<Integer>();
        shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING);
        stockCond.setShelvesTypeList(shelvesTypeList);
        List<WhWmsSkuStockVO> stockList = this.whWmsSkuStockService.getSkuStocksByShelvesCondForReport(stockCond);
        this.sortSkuStock(stockList);
        if (CollectionUtils.isNotEmpty(stockList)) {
            for (WhWmsSkuStockVO skuStockVO : stockList) {
                if (!EmptyUtil.isNotEmpty((Object)skuStockVO) || skuStockVO.getAvailableAmount() <= 0) continue;
                WhWmsHouseShelvesVO shelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStockVO.getShelvesCode());
                if (EmptyUtil.isNotEmpty((Object)shelvesVO)) {
                    skuStockVO.setHouseType(shelvesVO.getHouseType());
                }
                return skuStockVO;
            }
        }
        throw new WarehouseException("WH0001", "\u4ed3\u5e93:" + stockCond.getPhysicalWarehouseCode() + " \u6279\u6b21\uff1a" + stockCond.getBarCode() + ",\u6ca1\u6709\u4fdd\u7ba1\u5e93\u4f4d\u826f\u54c1\u5e93\u5b58!");
    }

    private WhWmsReplenishInfoExample buildWhWmsReplenishInfoExampleByCond(WhWmsReplenishInfoCond cond) {
        WhWmsReplenishInfoExample example = new WhWmsReplenishInfoExample();
        WhWmsReplenishInfoExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getPhysicalWarehouseCode())) {
            criteria.andPhysicalWarehouseCodeEqualTo(cond.getPhysicalWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getHouseType())) {
            criteria.andHouseTypeEqualTo(cond.getHouseType());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getShelvesCode())) {
            criteria.andShelvesCodeEqualTo(cond.getShelvesCode());
        } else if (EmptyUtil.isNotEmpty((String)cond.getShelvesCodeLike())) {
            criteria.andShelvesCodeLike(SQLUtils.allLike((String)cond.getShelvesCodeLike()));
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateTimeStart())) {
            criteria.andCreateTimeGreaterThanOrEqualTo(cond.getCreateTimeStart());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateTimeEnd())) {
            criteria.andCreateTimeLessThanOrEqualTo(cond.getCreateTimeEnd());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getRefCode())) {
            criteria.andRefCodeEqualTo(cond.getRefCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getRefType())) {
            criteria.andRefTypeEqualTo(cond.getRefType());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getReplenishStates())) {
            criteria.andReplenishStatesEqualTo(cond.getReplenishStates());
        } else if (CollectionUtils.isNotEmpty(cond.getReplenishStatesList())) {
            criteria.andReplenishStatesIn((List)cond.getReplenishStatesList());
        }
        return example;
    }
}

